/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;

public class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(GeoTiffFormat.class);
    public static final DefaultParameterDescriptor<Boolean> WRITE_TFW = new DefaultParameterDescriptor("WRITE_TFW", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final DefaultParameterDescriptor<Boolean> RETAIN_AXES_ORDER = new DefaultParameterDescriptor("RETAIN_AXES_ORDER", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    static final TIFFImageWriterSpi IMAGEIO_WRITER_FACTORY = new TIFFImageWriterSpi();
    private static final TIFFImageReaderSpi IMAGEIO_READER_FACTORY = new TIFFImageReaderSpi();

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org/geotiff/spec/geotiffhome.html");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, SUGGESTED_TILE_SIZE}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{RETAIN_AXES_ORDER, AbstractGridFormat.GEOTOOLS_WRITE_PARAMS, AbstractGridFormat.PROGRESS_LISTENER}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean accepts(Object o, Hints hints) {
        boolean bl;
        boolean closeMe;
        ImageInputStream inputStream;
        ImageReader reader;
        block68: {
            block66: {
                boolean bl2;
                block67: {
                    block64: {
                        boolean t4222222222;
                        block65: {
                            IIOMetadata metadata;
                            block62: {
                                boolean t22222222222;
                                block63: {
                                    block60: {
                                        boolean url22222222222222222222;
                                        block61: {
                                            block58: {
                                                boolean url22222222222222222222;
                                                block59: {
                                                    if (o == null) {
                                                        return false;
                                                    }
                                                    reader = null;
                                                    inputStream = null;
                                                    closeMe = true;
                                                    if (o instanceof URL) {
                                                        URL url22222222222222222222 = (URL)o;
                                                        o = DataUtilities.urlToFile(url22222222222222222222);
                                                    } else if (o instanceof ImageInputStream) {
                                                        closeMe = false;
                                                    }
                                                    inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o));
                                                    if (inputStream != null) break block58;
                                                    if (LOGGER.isLoggable(Level.FINE)) {
                                                        LOGGER.fine("Unable to get an ImageInputStream");
                                                    }
                                                    url22222222222222222222 = false;
                                                    if (reader == null) break block59;
                                                    try {
                                                        reader.dispose();
                                                    }
                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (closeMe && inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Throwable t3) {
                                                        // empty catch block
                                                    }
                                                }
                                                return url22222222222222222222;
                                            }
                                            if (IMAGEIO_READER_FACTORY.canDecodeInput((Object)inputStream)) break block60;
                                            url22222222222222222222 = false;
                                            if (reader == null) break block61;
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (closeMe && inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Throwable t22222222222) {
                                                // empty catch block
                                            }
                                        }
                                        return url22222222222222222222;
                                    }
                                    reader = IMAGEIO_READER_FACTORY.createReaderInstance();
                                    inputStream.mark();
                                    reader.setInput(inputStream);
                                    metadata = reader.getImageMetadata(0);
                                    if (metadata != null) break block62;
                                    t22222222222 = false;
                                    if (reader == null) break block63;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (closeMe && inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable t4222222222) {
                                        // empty catch block
                                    }
                                }
                                return t22222222222;
                            }
                            GeoTiffIIOMetadataDecoder metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                            if (!metadataAdapter.hasGeoKey() && LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Unable to find geokey directory for this tif file");
                            }
                            if (!metadataAdapter.hasModelTrasformation() && (!metadataAdapter.hasPixelScales() || !metadataAdapter.hasTiePoints())) break block64;
                            t4222222222 = true;
                            if (reader == null) break block65;
                            try {
                                reader.dispose();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (closeMe && inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable t5) {
                                // empty catch block
                            }
                        }
                        return t4222222222;
                    }
                    MathTransform raster2Model = GeoTiffReader.parseWorldFile(o);
                    if (raster2Model == null) break block66;
                    bl2 = true;
                    if (reader == null) break block67;
                    try {
                        reader.dispose();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find georeferencing for this tif file");
            }
            bl = false;
            if (reader == null) break block68;
            try {
                reader.dispose();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (closeMe && inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable e) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Exception e2) {}
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    public GeoTiffReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GeoTiffReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                File file = DataUtilities.urlToFile(url);
                return new GeoTiffReader(file, hints);
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

