/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.type.FeatureTypeImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeImpl
extends FeatureTypeImpl
implements SimpleFeatureType {
    List<AttributeType> types = null;
    Map<String, Integer> index = SimpleFeatureTypeImpl.buildIndex(this);

    public SimpleFeatureTypeImpl(Name name, List<AttributeDescriptor> schema, GeometryDescriptor defaultGeometry, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, schema, defaultGeometry, isAbstract, restrictions, superType, description);
    }

    public final List<AttributeDescriptor> getAttributeDescriptors() {
        return (List)this.getDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeType> getTypes() {
        if (this.types == null) {
            SimpleFeatureTypeImpl simpleFeatureTypeImpl = this;
            synchronized (simpleFeatureTypeImpl) {
                if (this.types == null) {
                    this.types = new ArrayList<AttributeType>();
                    for (AttributeDescriptor ad : this.getAttributeDescriptors()) {
                        this.types.add(ad.getType());
                    }
                }
            }
        }
        return this.types;
    }

    public AttributeType getType(Name name) {
        AttributeDescriptor attribute = this.getDescriptor(name);
        if (attribute != null) {
            return attribute.getType();
        }
        return null;
    }

    public AttributeType getType(String name) {
        AttributeDescriptor attribute = this.getDescriptor(name);
        if (attribute != null) {
            return attribute.getType();
        }
        return null;
    }

    public AttributeType getType(int index) {
        return this.getTypes().get(index);
    }

    public AttributeDescriptor getDescriptor(Name name) {
        return (AttributeDescriptor)super.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(String name) {
        return (AttributeDescriptor)super.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(int index) {
        return this.getAttributeDescriptors().get(index);
    }

    public int indexOf(Name name) {
        if (name.getNamespaceURI() == null) {
            return this.indexOf(name.getLocalPart());
        }
        int index = 0;
        for (AttributeDescriptor descriptor : this.getAttributeDescriptors()) {
            if (descriptor.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOf(String name) {
        Integer idx = this.index.get(name);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    public int getAttributeCount() {
        return this.getAttributeDescriptors().size();
    }

    public String getTypeName() {
        return this.getName().getLocalPart();
    }

    static Map<String, Integer> buildIndex(SimpleFeatureType featureType) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        int i = 0;
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            index.put(ad.getLocalName(), i++);
        }
        if (featureType.getGeometryDescriptor() != null) {
            index.put((String)null, (Integer)index.get(featureType.getGeometryDescriptor().getLocalName()));
        }
        return index;
    }
}

