/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.resources.i18n.Errors;

public final class LRULinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -6668885347230182669L;
    private static final double DEFAULT_LOAD_FACTOR = 0.75;
    private static final int DEFAULT_MAXIMUM_SIZE = 100;
    private int maximumSize;

    public LRULinkedHashMap() {
        this.maximumSize = 100;
    }

    public LRULinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.maximumSize = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maximumSize = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maximumSize = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, int maximumSize) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maximumSize = maximumSize;
        LRULinkedHashMap.checkMaximumSize(maximumSize);
    }

    private LRULinkedHashMap(boolean accessOrder, int maximumSize) {
        super((int)Math.ceil((double)maximumSize / 0.75), 0.75f, accessOrder);
        this.maximumSize = maximumSize;
    }

    public LRULinkedHashMap(Map<K, V> map) {
        super(map);
        this.maximumSize = map.size();
    }

    public LRULinkedHashMap(Map<K, V> map, int maximumSize) {
        super(map);
        this.maximumSize = maximumSize;
        LRULinkedHashMap.checkMaximumSize(maximumSize);
        this.removeExtraEntries();
    }

    private static void checkMaximumSize(int maximumSize) throws IllegalArgumentException {
        if (maximumSize <= 0) {
            throw new IllegalArgumentException(Errors.format(125, maximumSize));
        }
    }

    private void removeExtraEntries() {
        if (this.size() > this.maximumSize) {
            Iterator it = this.entrySet().iterator();
            for (int c = 0; c < this.maximumSize; ++c) {
                it.next();
            }
            while (it.hasNext()) {
                it.remove();
            }
        }
    }

    public static <K, V> LRULinkedHashMap<K, V> createForRecentAccess(int maximumSize) {
        LRULinkedHashMap.checkMaximumSize(maximumSize);
        return new LRULinkedHashMap<K, V>(true, maximumSize);
    }

    public static <K, V> LRULinkedHashMap<K, V> createForRecentInserts(int maximumSize) {
        LRULinkedHashMap.checkMaximumSize(maximumSize);
        return new LRULinkedHashMap<K, V>(false, maximumSize);
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int max) {
        LRULinkedHashMap.checkMaximumSize(max);
        this.maximumSize = max;
        this.removeExtraEntries();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maximumSize;
    }
}

