/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;

public abstract class AbstractMapInfoReader
extends AbstractReader
implements OdConstants {
    protected static final String VERSION_1 = "1";
    protected static final String VERSION_2 = "2";
    protected static final String VERSION_300 = "300";
    protected static final String VERSION_450 = "450";
    protected static final String CHARSET_WINDOWS = "WindowsLatin1";
    protected static final String CHARSET_NEUTRAL = "Neutral";
    protected static final String CHARSET_MAC = "MacRoman";
    protected BufferedReader headerReader;
    protected String line;
    protected int lineNum = 0;
    protected String version;
    protected int numcolumns = -1;
    protected List<String> columns;

    protected final File getDataFile(File headerFile, String extension) {
        String filename = headerFile.getName().substring(0, headerFile.getName().lastIndexOf(46));
        File dataFile = new File(headerFile.getParent() + File.separator + filename + extension.toUpperCase());
        if (!dataFile.exists()) {
            dataFile = new File(headerFile.getParent() + File.separator + filename + extension.toLowerCase());
        }
        return dataFile;
    }

    protected final BufferedReader getDataReader(File headerFile, String extension, Charset charset) throws FileNotFoundException {
        File dataFile = this.getDataFile(headerFile, extension);
        return dataFile.exists() ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), charset)) : null;
    }

    protected Charset parseCharset(String[] words) {
        return this.parseCharset(words, 1);
    }

    protected Charset parseCharset(String[] words, int index) {
        words[index] = words[index].replace("\"", "");
        if (words[index].equalsIgnoreCase(CHARSET_WINDOWS)) {
            return Charset.forName("Cp1252");
        }
        if (words[index].equalsIgnoreCase(CHARSET_NEUTRAL)) {
            return Charset.forName("ISO-8859-15");
        }
        if (words[index].equalsIgnoreCase(CHARSET_MAC)) {
            return Charset.forName(CHARSET_MAC);
        }
        System.err.println("Line " + this.lineNum + ". Unknown charset detected: " + this.line);
        return Charset.forName(words[index]);
    }

    protected void parseVersion(String[] words) {
        this.version = words[1];
    }

    protected void parseColumns(String[] words) {
        this.columns = new ArrayList<String>();
        this.numcolumns = Integer.parseInt(words[1]);
    }

    protected final void parseHeader() throws IOException {
        while ((this.line = this.headerReader.readLine()) != null) {
            ++this.lineNum;
            while (this.line.contains("  ")) {
                this.line = this.line.replace("  ", " ");
            }
            String[] words = this.line.isEmpty() ? null : this.line.trim().split(" ");
            if (words == null || words.length <= 0) continue;
            this.parseHeaderLine(words);
        }
    }

    protected abstract void parseHeaderLine(String[] var1) throws IOException;
}

