/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class HorodateurHandler
extends ToulouseDataSetHandler {
    public HorodateurHandler() {
        super(12540, "vending=parking_tickets");
        this.setWikiPage("Horodateurs");
        this.setCategory(CAT_TRANSPORT);
        this.setMenuIcon("presets/vending_machine.png");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Horodateur"});
    }

    private String parseHour(String hour) {
        String s = hour.replaceFirst("[hH]", ":");
        if (s.endsWith(":")) {
            s = s + "00";
        }
        return s;
    }

    protected String parseOpeningHours(String horaire) {
        String hour = "\\p{Digit}{1,2}[hH]\\p{Digit}{0,2}";
        String sep = "[ -/]+";
        String hours = "(\\p{Digit}{1,2}[hH]\\p{Digit}{0,2}[ -/]+\\p{Digit}{1,2}[hH]\\p{Digit}{0,2})";
        Pattern p = Pattern.compile("(\\p{Digit}{1,2}[hH]\\p{Digit}{0,2}[ -/]+\\p{Digit}{1,2}[hH]\\p{Digit}{0,2})(?:[ -/]+(\\p{Digit}{1,2}[hH]\\p{Digit}{0,2}[ -/]+\\p{Digit}{1,2}[hH]\\p{Digit}{0,2}))*");
        Matcher m = p.matcher(horaire);
        String opening_hours = "";
        if (m.matches()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                Pattern p2;
                Matcher m2;
                if (m.group(i) == null) continue;
                if (!opening_hours.isEmpty()) {
                    opening_hours = opening_hours + "; ";
                }
                if ((m2 = (p2 = Pattern.compile("(\\p{Digit}{1,2}[hH]\\p{Digit}{0,2})[ -/]+(\\p{Digit}{1,2}[hH]\\p{Digit}{0,2})")).matcher(m.group(i))).matches()) {
                    opening_hours = opening_hours + this.parseHour(m2.group(1)) + "-" + this.parseHour(m2.group(2));
                    continue;
                }
                System.err.println(m.group(i) + " does not match " + p2);
            }
        } else {
            System.err.println(horaire + " does not match " + p);
        }
        return opening_hours;
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "vending_machine");
            n.put("vending", "parking_tickets");
            n.remove("name");
            n.remove("Code_Insee");
            n.remove("Lib_voie");
            n.remove("Mot_dir");
            n.remove("No");
            n.remove("Reglementation");
            n.remove("color");
            this.replace((IPrimitive)n, "commune", "operator", new AbstractDataSetHandler.ValueReplacer(){

                public String replace(String value) {
                    return "Mairie de " + WordUtils.capitalizeFully((String)value);
                }
            });
            this.replace((IPrimitive)n, "horaire", "opening_hours", new AbstractDataSetHandler.ValueReplacer(){

                public String replace(String value) {
                    return HorodateurHandler.this.parseOpeningHours(value);
                }
            });
            this.replace((IPrimitive)n, "maj_date", "source:date", new AbstractDataSetHandler.ValueReplacer(){

                public String replace(String value) {
                    return value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6, 8);
                }
            });
            this.replace((IPrimitive)n, "observations", "note");
            this.replace((IPrimitive)n, "quartier_residant", "parking:ticket:zone", new AbstractDataSetHandler.ValueReplacer(){

                public String replace(String value) {
                    return WordUtils.capitalizeFully((String)value.trim()).replace(" Iv", " IV").replace("Sebastopol", "S\u00e9bastopol").replace("St ", "Saint-").replace("Peri", "P\u00e9ri");
                }
            });
        }
    }
}

