/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import messages.Messages;
import panels.PanelPat;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelMore
extends JPanel {
    private SmedAction dlg;
    public JLabel infoLabel;
    public JTextField infoBox;
    private FocusListener flInfo = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelMore.this.dlg;
            SmedAction.panelMain.mark.setInfo(PanelMore.this.infoBox.getText());
        }
    };
    public JLabel sourceLabel;
    public JTextField sourceBox;
    private FocusListener flSource = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelMore.this.dlg;
            SmedAction.panelMain.mark.setSource(PanelMore.this.sourceBox.getText());
        }
    };
    public JLabel elevLabel;
    public JTextField elevBox;
    private FocusListener flElev = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelMore.this.dlg;
            SmedAction.panelMain.mark.setElevation(PanelMore.this.elevBox.getText());
        }
    };
    public JLabel heightLabel;
    public JTextField heightBox;
    private FocusListener flHeight = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelMore.this.dlg;
            SmedAction.panelMain.mark.setObjectHeight(PanelMore.this.heightBox.getText());
        }
    };
    public JLabel statusLabel;
    public JComboBox statusBox;
    public EnumMap<SeaMark.Sts, Integer> statuses = new EnumMap(SeaMark.Sts.class);
    private ActionListener alStatus = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Sts sts : PanelMore.this.statuses.keySet()) {
                int idx = PanelMore.this.statuses.get((Object)sts);
                PanelMore.this.dlg;
                if (SmedAction.panelMain.mark == null || idx != PanelMore.this.statusBox.getSelectedIndex()) continue;
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setStatus(sts);
            }
        }
    };
    public JLabel constrLabel;
    public JComboBox constrBox;
    public EnumMap<SeaMark.Cns, Integer> constructions = new EnumMap(SeaMark.Cns.class);
    private ActionListener alConstr = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Cns cns : PanelMore.this.constructions.keySet()) {
                int idx = PanelMore.this.constructions.get((Object)cns);
                PanelMore.this.dlg;
                if (SmedAction.panelMain.mark == null || idx != PanelMore.this.constrBox.getSelectedIndex()) continue;
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setConstr(cns);
            }
        }
    };
    public JLabel conLabel;
    public JComboBox conBox;
    public EnumMap<SeaMark.Con, Integer> conspicuities = new EnumMap(SeaMark.Con.class);
    private ActionListener alCon = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Con con : PanelMore.this.conspicuities.keySet()) {
                int idx = PanelMore.this.conspicuities.get((Object)con);
                PanelMore.this.dlg;
                if (SmedAction.panelMain.mark == null || idx != PanelMore.this.conBox.getSelectedIndex()) continue;
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setConsp(con);
            }
        }
    };
    public JLabel reflLabel;
    public JComboBox reflBox;
    public EnumMap<SeaMark.Con, Integer> reflectivities = new EnumMap(SeaMark.Con.class);
    private ActionListener alRefl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Con con : PanelMore.this.reflectivities.keySet()) {
                int idx = PanelMore.this.reflectivities.get((Object)con);
                PanelMore.this.dlg;
                if (SmedAction.panelMain.mark == null || idx != PanelMore.this.reflBox.getSelectedIndex()) continue;
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setRefl(con);
            }
        }
    };
    public PanelPat panelPat;
    private ButtonGroup regionButtons = new ButtonGroup();
    public JRadioButton regionAButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RegionAButton.png")));
    public JRadioButton regionBButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RegionBButton.png")));
    public JRadioButton regionCButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RegionCButton.png")));
    private ActionListener alRegion = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelMore.this.regionAButton.isSelected()) {
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setRegion(SeaMark.Reg.A);
                PanelMore.this.dlg;
                switch (SmedAction.panelMain.mark.getCategory()) {
                    case LAM_PORT: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                        break;
                    }
                    case LAM_PPORT: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                        break;
                    }
                    case LAM_STBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                        break;
                    }
                    case LAM_PSTBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                    }
                }
                PanelMore.this.regionAButton.setBorderPainted(true);
            } else {
                PanelMore.this.regionAButton.setBorderPainted(false);
            }
            if (PanelMore.this.regionBButton.isSelected()) {
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setRegion(SeaMark.Reg.B);
                PanelMore.this.dlg;
                switch (SmedAction.panelMain.mark.getCategory()) {
                    case LAM_PORT: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                        break;
                    }
                    case LAM_PPORT: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                        break;
                    }
                    case LAM_STBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                        break;
                    }
                    case LAM_PSTBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                    }
                }
                PanelMore.this.regionBButton.setBorderPainted(true);
            } else {
                PanelMore.this.regionBButton.setBorderPainted(false);
            }
            if (PanelMore.this.regionCButton.isSelected()) {
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setRegion(SeaMark.Reg.C);
                PanelMore.this.dlg;
                SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                PanelMore.this.dlg;
                switch (SmedAction.panelMain.mark.getCategory()) {
                    case LAM_PORT: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                        break;
                    }
                    case LAM_PPORT: 
                    case LAM_PSTBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        break;
                    }
                    case LAM_STBD: {
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        PanelMore.this.dlg;
                        SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                    }
                }
                PanelMore.this.regionCButton.setBorderPainted(true);
            } else {
                PanelMore.this.regionCButton.setBorderPainted(false);
            }
            PanelMore.this.panelPat.syncPanel();
        }
    };

    public PanelMore(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.panelPat = new PanelPat(this.dlg, SeaMark.Ent.BODY);
        this.panelPat.setBounds(new Rectangle(0, 0, 110, 160));
        this.add(this.panelPat);
        this.add(this.getRegionButton(this.regionAButton, 110, 0, 34, 30, "RegionA"));
        this.add(this.getRegionButton(this.regionBButton, 110, 32, 34, 30, "RegionB"));
        this.add(this.getRegionButton(this.regionCButton, 110, 64, 34, 30, "RegionC"));
        this.elevLabel = new JLabel(Messages.getString("Elevation"), 0);
        this.elevLabel.setBounds(new Rectangle(140, 0, 90, 20));
        this.add(this.elevLabel);
        this.elevBox = new JTextField();
        this.elevBox.setBounds(new Rectangle(160, 20, 50, 20));
        this.elevBox.setHorizontalAlignment(0);
        this.add(this.elevBox);
        this.elevBox.addFocusListener(this.flElev);
        this.heightLabel = new JLabel(Messages.getString("Height"), 0);
        this.heightLabel.setBounds(new Rectangle(140, 40, 90, 20));
        this.add(this.heightLabel);
        this.heightBox = new JTextField();
        this.heightBox.setBounds(new Rectangle(160, 60, 50, 20));
        this.heightBox.setHorizontalAlignment(0);
        this.add(this.heightBox);
        this.heightBox.addFocusListener(this.flHeight);
        this.sourceLabel = new JLabel(Messages.getString("Source"), 0);
        this.sourceLabel.setBounds(new Rectangle(110, 80, 130, 20));
        this.add(this.sourceLabel);
        this.sourceBox = new JTextField();
        this.sourceBox.setBounds(new Rectangle(110, 100, 130, 20));
        this.sourceBox.setHorizontalAlignment(0);
        this.add(this.sourceBox);
        this.sourceBox.addFocusListener(this.flSource);
        this.infoLabel = new JLabel(Messages.getString("Information"), 0);
        this.infoLabel.setBounds(new Rectangle(110, 120, 130, 20));
        this.add(this.infoLabel);
        this.infoBox = new JTextField();
        this.infoBox.setBounds(new Rectangle(110, 140, 130, 20));
        this.infoBox.setHorizontalAlignment(0);
        this.add(this.infoBox);
        this.infoBox.addFocusListener(this.flInfo);
        this.statusLabel = new JLabel(Messages.getString("Status"), 0);
        this.statusLabel.setBounds(new Rectangle(250, 0, 100, 20));
        this.add(this.statusLabel);
        this.statusBox = new JComboBox();
        this.statusBox.setBounds(new Rectangle(250, 20, 100, 20));
        this.addStsItem("", SeaMark.Sts.UNKSTS);
        this.addStsItem(Messages.getString("Permanent"), SeaMark.Sts.PERM);
        this.addStsItem(Messages.getString("Occasional"), SeaMark.Sts.OCC);
        this.addStsItem(Messages.getString("Recommended"), SeaMark.Sts.REC);
        this.addStsItem(Messages.getString("NotInUse"), SeaMark.Sts.NIU);
        this.addStsItem(Messages.getString("Intermittent"), SeaMark.Sts.INT);
        this.addStsItem(Messages.getString("Reserved"), SeaMark.Sts.RESV);
        this.addStsItem(Messages.getString("Temporary"), SeaMark.Sts.TEMP);
        this.addStsItem(Messages.getString("Private"), SeaMark.Sts.PRIV);
        this.addStsItem(Messages.getString("Mandatory"), SeaMark.Sts.MAND);
        this.addStsItem(Messages.getString("Destroyed"), SeaMark.Sts.DEST);
        this.addStsItem(Messages.getString("Extinguished"), SeaMark.Sts.EXT);
        this.addStsItem(Messages.getString("Illuminated"), SeaMark.Sts.ILLUM);
        this.addStsItem(Messages.getString("Historic"), SeaMark.Sts.HIST);
        this.addStsItem(Messages.getString("Public"), SeaMark.Sts.PUB);
        this.addStsItem(Messages.getString("Synchronized"), SeaMark.Sts.SYNC);
        this.addStsItem(Messages.getString("Watched"), SeaMark.Sts.WATCH);
        this.addStsItem(Messages.getString("UnWatched"), SeaMark.Sts.UNWAT);
        this.addStsItem(Messages.getString("Doubtful"), SeaMark.Sts.DOUBT);
        this.add(this.statusBox);
        this.statusBox.addActionListener(this.alStatus);
        this.constrLabel = new JLabel(Messages.getString("Construction"), 0);
        this.constrLabel.setBounds(new Rectangle(250, 40, 100, 20));
        this.add(this.constrLabel);
        this.constrBox = new JComboBox();
        this.constrBox.setBounds(new Rectangle(250, 60, 100, 20));
        this.addCnsItem("", SeaMark.Cns.UNKCNS);
        this.addCnsItem(Messages.getString("Masonry"), SeaMark.Cns.BRICK);
        this.addCnsItem(Messages.getString("Concreted"), SeaMark.Cns.CONC);
        this.addCnsItem(Messages.getString("Boulders"), SeaMark.Cns.BOULD);
        this.addCnsItem(Messages.getString("HardSurfaced"), SeaMark.Cns.HSURF);
        this.addCnsItem(Messages.getString("Unsurfaced"), SeaMark.Cns.USURF);
        this.addCnsItem(Messages.getString("Wooden"), SeaMark.Cns.WOOD);
        this.addCnsItem(Messages.getString("Metal"), SeaMark.Cns.METAL);
        this.addCnsItem(Messages.getString("GRP"), SeaMark.Cns.GLAS);
        this.addCnsItem(Messages.getString("Painted"), SeaMark.Cns.PAINT);
        this.add(this.constrBox);
        this.constrBox.addActionListener(this.alConstr);
        this.conLabel = new JLabel(Messages.getString("Conspicuity"), 0);
        this.conLabel.setBounds(new Rectangle(250, 80, 100, 20));
        this.add(this.conLabel);
        this.conBox = new JComboBox();
        this.conBox.setBounds(new Rectangle(250, 100, 100, 20));
        this.addConItem("", SeaMark.Con.UNKCON);
        this.addConItem(Messages.getString("Conspicuous"), SeaMark.Con.CONSP);
        this.addConItem(Messages.getString("NotConspicuous"), SeaMark.Con.NCONS);
        this.add(this.conBox);
        this.conBox.addActionListener(this.alCon);
        this.reflLabel = new JLabel(Messages.getString("Reflectivity"), 0);
        this.reflLabel.setBounds(new Rectangle(250, 120, 100, 20));
        this.add(this.reflLabel);
        this.reflBox = new JComboBox();
        this.reflBox.setBounds(new Rectangle(250, 140, 100, 20));
        this.addReflItem("", SeaMark.Con.UNKCON);
        this.addReflItem(Messages.getString("Conspicuous"), SeaMark.Con.CONSP);
        this.addReflItem(Messages.getString("NotConspicuous"), SeaMark.Con.NCONS);
        this.addReflItem(Messages.getString("Reflector"), SeaMark.Con.REFL);
        this.add(this.reflBox);
        this.reflBox.addActionListener(this.alRefl);
    }

    public void syncPanel() {
        int item;
        this.panelPat.syncPanel();
        this.regionAButton.setBorderPainted(SmedAction.panelMain.mark.getRegion() == SeaMark.Reg.A);
        this.regionBButton.setBorderPainted(SmedAction.panelMain.mark.getRegion() == SeaMark.Reg.B);
        this.regionCButton.setBorderPainted(SmedAction.panelMain.mark.getRegion() == SeaMark.Reg.C);
        this.elevBox.setText(SmedAction.panelMain.mark.getElevation());
        this.heightBox.setText(SmedAction.panelMain.mark.getObjectHeight());
        this.sourceBox.setText(SmedAction.panelMain.mark.getSource());
        this.infoBox.setText(SmedAction.panelMain.mark.getInfo());
        for (SeaMark.Sts sts : this.statuses.keySet()) {
            item = this.statuses.get((Object)sts);
            if (SmedAction.panelMain.mark.getStatus() != sts) continue;
            this.statusBox.setSelectedIndex(item);
        }
        for (SeaMark.Cns cns : this.constructions.keySet()) {
            item = this.constructions.get((Object)cns);
            if (SmedAction.panelMain.mark.getConstr() != cns) continue;
            this.constrBox.setSelectedIndex(item);
        }
        for (SeaMark.Con con : this.conspicuities.keySet()) {
            item = this.conspicuities.get((Object)con);
            if (SmedAction.panelMain.mark.getConsp() != con) continue;
            this.conBox.setSelectedIndex(item);
        }
        for (SeaMark.Con con : this.reflectivities.keySet()) {
            item = this.reflectivities.get((Object)con);
            if (SmedAction.panelMain.mark.getRefl() != con) continue;
            this.reflBox.setSelectedIndex(item);
        }
    }

    private void addStsItem(String str, SeaMark.Sts sts) {
        this.statuses.put(sts, this.statusBox.getItemCount());
        this.statusBox.addItem(str);
    }

    private void addCnsItem(String str, SeaMark.Cns cns) {
        this.constructions.put(cns, this.constrBox.getItemCount());
        this.constrBox.addItem(str);
    }

    private void addConItem(String str, SeaMark.Con con) {
        this.conspicuities.put(con, this.conBox.getItemCount());
        this.conBox.addItem(str);
    }

    private void addReflItem(String str, SeaMark.Con con) {
        this.reflectivities.put(con, this.reflBox.getItemCount());
        this.reflBox.addItem(str);
    }

    private JRadioButton getRegionButton(JRadioButton button, int x, int y, int w, int h, String tip) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alRegion);
        this.regionButtons.add(button);
        return button;
    }
}

