/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTile;

public class ElevationGridTileController
extends TileController {
    private JobDispatcher jobDispatcher;

    public ElevationGridTileController(TileSource source, TileCache tileCache, TileLoaderListener listener, TileLoader loader) {
        super(source, tileCache, listener);
        this.tileSource = source;
        this.tileLoader = loader;
        this.jobDispatcher = JobDispatcher.getInstance();
    }

    public Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new ElevationGridTile(this.tileSource, tilex, tiley, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (tile.hasError()) {
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(tile));
        }
        return tile;
    }

    public void cancelOutstandingJobs() {
        super.cancelOutstandingJobs();
        this.jobDispatcher.cancelOutstandingJobs();
    }
}

