/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.LinkedHashSet;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.TxBlock;
import org.mapdb.TxRollbackException;

public class TxMaker {
    protected static final Fun.Tuple2<Object, Serializer> DELETED = new Fun.Tuple2<Object, Serializer<String>>(null, Serializer.STRING_SERIALIZER);
    protected Engine engine;
    protected final Object lock = new Object();
    protected final LongMap<TxEngine> globalMod = new LongHashMap<TxEngine>();

    public TxMaker(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    public DB makeTx() {
        return new DB(new TxEngine(this.engine));
    }

    public void close() {
        if (this.engine == null) {
            this.engine.close();
        }
    }

    public void execute(TxBlock txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                txBlock.tx(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return;
            }
            catch (TxRollbackException txRollbackException) {
                continue;
            }
            break;
        }
    }

    protected class TxEngine
    extends EngineWrapper {
        protected LongMap<Fun.Tuple2<?, Serializer>> modItems;
        protected Set<Long> newItems;

        protected TxEngine(Engine engine) {
            super(engine);
            this.modItems = new LongHashMap();
            this.newItems = new LinkedHashSet<Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            if (this.isClosed()) {
                throw new IllegalAccessError("already closed");
            }
            Object object = TxMaker.this.lock;
            synchronized (object) {
                long recid = TxMaker.this.engine.put("", Serializer.EMPTY_SERIALIZER);
                this.newItems.add(recid);
                this.modItems.put(recid, Fun.t2(value, serializer));
                TxMaker.this.globalMod.put(recid, this);
                return recid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            if (this.isClosed()) {
                throw new IllegalAccessError("already closed");
            }
            Object object = TxMaker.this.lock;
            synchronized (object) {
                Fun.Tuple2<?, Serializer> t = this.modItems.get(recid);
                if (t != null) {
                    return t.a;
                }
                return super.get(recid, serializer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            if (this.isClosed()) {
                throw new IllegalAccessError("already closed");
            }
            Object object = TxMaker.this.lock;
            synchronized (object) {
                TxEngine other = TxMaker.this.globalMod.get(recid);
                if (other != null && other != this) {
                    this.rollback();
                    throw new TxRollbackException();
                }
                this.modItems.put(recid, new Fun.Tuple2<A, Serializer<A>>(value, serializer));
                TxMaker.this.globalMod.put(recid, this);
            }
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            if (this.isClosed()) {
                throw new IllegalAccessError("already closed");
            }
            throw new IllegalAccessError("Compare and Swap not supported in Tx mode");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            if (this.isClosed()) {
                throw new IllegalAccessError("already closed");
            }
            Object object = TxMaker.this.lock;
            synchronized (object) {
                TxEngine other = TxMaker.this.globalMod.get(recid);
                if (other != null && other != this) {
                    this.rollback();
                    throw new TxRollbackException();
                }
                this.modItems.put(recid, DELETED);
                TxMaker.this.globalMod.put(recid, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            Object object = TxMaker.this.lock;
            synchronized (object) {
                LongMap.LongMapIterator<Fun.Tuple2<?, Serializer>> iter = this.modItems.longMapIterator();
                while (iter.moveToNext()) {
                    TxEngine other = TxMaker.this.globalMod.remove(iter.key());
                    if (other != this) {
                        throw new InternalError();
                    }
                    Fun.Tuple2<?, Serializer> t = iter.value();
                    TxMaker.this.engine.update(iter.key(), t.a, (Serializer)t.b);
                }
                this.modItems = null;
                this.newItems = null;
                TxMaker.this.engine.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            Object object = TxMaker.this.lock;
            synchronized (object) {
                LongMap.LongMapIterator<Fun.Tuple2<?, Serializer>> iter = this.modItems.longMapIterator();
                while (iter.moveToNext()) {
                    TxEngine other = TxMaker.this.globalMod.remove(iter.key());
                    if (other == this) continue;
                    throw new InternalError();
                }
                for (long recid : this.newItems) {
                    TxMaker.this.engine.delete(recid, Serializer.EMPTY_SERIALIZER);
                }
                this.modItems = null;
                this.newItems = null;
            }
        }

        @Override
        public void close() {
            this.rollback();
        }
    }
}

