/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.StoreDirect;
import org.mapdb.Utils;
import org.mapdb.Volume;

public class StoreWAL
extends StoreDirect {
    protected static final byte WAL_INDEX_LONG = 101;
    protected static final byte WAL_PHYS_LONG = 102;
    protected static final byte WAL_PHYS_SIX_LONG = 103;
    protected static final byte WAL_PHYS_ARRAY = 104;
    protected static final byte WAL_SKIP_REST_OF_BLOCK = 105;
    protected static final byte WAL_SEAL = 111;
    protected static final long LOG_SEAL = 4566556446554645L;
    public static final String TRANS_LOG_FILE_EXT = ".t";
    protected static final long[] TOMBSTONE = new long[1];
    protected final Volume.Factory volFac;
    protected Volume log;
    protected long logSize;
    protected final LongConcurrentHashMap<long[]> modified = new LongConcurrentHashMap();

    public StoreWAL(Volume.Factory volFac) {
        this(volFac, false, false);
    }

    public StoreWAL(Volume.Factory volFac, boolean readOnly, boolean deleteFilesAfterClose) {
        super(volFac, readOnly, deleteFilesAfterClose);
        this.volFac = volFac;
        this.log = volFac.createTransLogVolume();
        this.reloadIndexFile();
        this.replayLogFile();
        this.log = null;
    }

    protected void reloadIndexFile() {
        this.logSize = 0L;
        this.modified.clear();
        this.indexSize = this.index.getLong(8L);
        this.physSize = this.index.getLong(16L);
    }

    protected void openLogIfNeeded() {
        if (this.log != null) {
            return;
        }
        this.log = this.volFac.createTransLogVolume();
        this.log.ensureAvailable(16L);
        this.log.putLong(0L, 9032094932889042394L);
        this.log.putLong(8L, 0L);
        this.logSize = 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long[] logPos;
        long[] physPos;
        long ioRecid;
        DataOutput2 out = this.serialize(value, serializer);
        this.structuralLock.lock();
        try {
            this.openLogIfNeeded();
            ioRecid = this.freeIoRecidTake(false);
            physPos = this.physAllocate(out.pos, false);
            logPos = this.logAllocate(physPos);
        }
        finally {
            this.structuralLock.unlock();
        }
        this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0]);
        this.walPhysArray(out, physPos, logPos);
        this.modified.put(ioRecid, logPos);
        return (ioRecid - 16512L) / 8L;
    }

    protected void walPhysArray(DataOutput2 out, long[] physPos, long[] logPos) {
        int outPos = 0;
        for (int i = 0; i < logPos.length; ++i) {
            int c = StoreWAL.ccc(logPos.length, i);
            long pos = logPos[i] & 0xFFFFFFFFFFFFL;
            int size = (int)((logPos[i] & 0x7FFF000000000000L) >>> 48);
            this.log.putByte(pos - 8L - 1L, (byte)104);
            this.log.putLong(pos - 8L, physPos[i]);
            if (c > 0) {
                this.log.putLong(pos, physPos[i + 1]);
                pos += 8L;
            }
            if (c == 12) {
                this.log.putInt(pos, out.pos);
                pos += 4L;
            }
            this.log.putData(pos, out.buf, outPos, size - c);
            outPos += size - c;
        }
        if (outPos != out.pos) {
            throw new InternalError();
        }
    }

    protected void walIndexVal(long logPos, long ioRecid, long indexVal) {
        this.log.putByte(logPos, (byte)101);
        this.log.putLong(logPos + 1L, ioRecid);
        this.log.putLong(logPos + 9L, indexVal);
    }

    protected long[] logAllocate(long[] physPos) {
        this.openLogIfNeeded();
        this.logSize += 17L;
        long[] ret = new long[physPos.length];
        for (int i = 0; i < physPos.length; ++i) {
            long size = (physPos[i] & 0x7FFF000000000000L) >>> 48;
            this.checkLogRounding();
            this.logSize += 9L;
            ret[i] = size << 48 | this.logSize;
            this.logSize += size;
        }
        this.log.ensureAvailable(this.logSize);
        return ret;
    }

    protected void checkLogRounding() {
        if (this.logSize % 0x40000000L + 65534L > 0x40000000L) {
            this.log.ensureAvailable(this.logSize + 1L);
            this.log.putByte(this.logSize, (byte)105);
            this.logSize += 0x40000000L - this.logSize % 0x40000000L;
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.readLock(this.locks, recid);
        try {
            A a = this.get2(ioRecid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            Utils.readUnlock(this.locks, recid);
        }
    }

    @Override
    protected <A> A get2(long ioRecid, Serializer<A> serializer) throws IOException {
        long[] r = this.modified.get(ioRecid);
        if (r == null) {
            return super.get2(ioRecid, serializer);
        }
        if (r == TOMBSTONE || r.length == 0) {
            return null;
        }
        if (r.length == 1) {
            int size = (int)((r[0] & 0x7FFF000000000000L) >>> 48);
            DataInput2 in = this.log.getDataInput(r[0] & 0xFFFFFFFFFFFFL, size);
            return serializer.deserialize(in, size);
        }
        int totalSize = 0;
        for (int i = 0; i < r.length; ++i) {
            int c = StoreWAL.ccc(r.length, i);
            totalSize += (int)((r[i] & 0x7FFF000000000000L) >>> 48) - c;
        }
        byte[] b = new byte[totalSize];
        int pos = 0;
        for (int i = 0; i < r.length; ++i) {
            int c = StoreWAL.ccc(r.length, i);
            int size = (int)((r[i] & 0x7FFF000000000000L) >>> 48) - c;
            this.log.getDataInput((r[i] & 0xFFFFFFFFFFFFL) + (long)c, size).readFully(b, pos, size);
            pos += size;
        }
        if (pos != totalSize) {
            throw new InternalError();
        }
        return serializer.deserialize(new DataInput2(b), totalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        DataOutput2 out = this.serialize(value, serializer);
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long[] logPos;
            long[] physPos;
            this.structuralLock.lock();
            try {
                this.openLogIfNeeded();
                physPos = this.physAllocate(out.pos, false);
                logPos = this.logAllocate(physPos);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0]);
            this.walPhysArray(out, physPos, logPos);
            this.modified.put(ioRecid, logPos);
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long[] logPos;
            long[] physPos;
            A oldVal = this.get2(ioRecid, serializer);
            if (oldVal == null && expectedOldValue != null || oldVal != null && !oldVal.equals(expectedOldValue)) {
                boolean bl = false;
                return bl;
            }
            DataOutput2 out = this.serialize(newValue, serializer);
            this.structuralLock.lock();
            try {
                this.openLogIfNeeded();
                physPos = this.physAllocate(out.pos, false);
                logPos = this.logAllocate(physPos);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0]);
            this.walPhysArray(out, physPos, logPos);
            this.modified.put(ioRecid, logPos);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long logPos;
            this.structuralLock.lock();
            try {
                this.openLogIfNeeded();
                logPos = this.logSize;
                this.checkLogRounding();
                this.logSize += 17L;
                this.log.ensureAvailable(this.logSize);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal(logPos, ioRecid, 0L);
            this.modified.put(ioRecid, TOMBSTONE);
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.structuralLock.lock();
        Utils.writeLockAll(this.locks);
        try {
            if (this.log == null) {
                return;
            }
            this.log.ensureAvailable(this.logSize + 17L + 17L + 1L);
            this.walIndexVal(this.logSize, 16L, this.physSize);
            this.logSize += 17L;
            this.walIndexVal(this.logSize, 8L, this.indexSize);
            this.logSize += 17L;
            this.log.putByte(this.logSize, (byte)111);
            ++this.logSize;
            this.log.sync();
            this.log.putLong(8L, 4566556446554645L);
            this.log.sync();
            this.replayLogFile();
            this.reloadIndexFile();
        }
        finally {
            Utils.writeUnlockAll(this.locks);
            this.structuralLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replayLogFile() {
        this.logSize = 0L;
        if (this.log != null) {
            this.log.sync();
        }
        if (this.log.isEmpty() || this.log.getLong(0L) != 9032094932889042394L || this.log.getLong(8L) != 4566556446554645L) {
            this.log.close();
            this.log.deleteFile();
            this.log = null;
            return;
        }
        this.logSize = 16L;
        byte ins = this.log.getByte(this.logSize);
        ++this.logSize;
        while (ins != 111) {
            long val;
            long offset;
            if (ins == 101) {
                long ioRecid = this.log.getLong(this.logSize);
                this.logSize += 8L;
                long indexVal = this.log.getLong(this.logSize);
                this.logSize += 8L;
                this.index.ensureAvailable(ioRecid + 8L);
                this.index.putLong(ioRecid, indexVal);
            } else if (ins == 102) {
                offset = this.log.getLong(this.logSize);
                this.logSize += 8L;
                val = this.log.getLong(this.logSize);
                this.logSize += 8L;
                this.phys.ensureAvailable(offset + 8L);
                this.phys.putLong(offset, val);
            } else if (ins == 103) {
                offset = this.log.getLong(this.logSize);
                this.logSize += 8L;
                val = this.log.getSixLong(this.logSize);
                this.logSize += 6L;
                this.phys.ensureAvailable(offset + 6L);
                this.phys.putSixLong(offset, val);
            } else if (ins == 104) {
                offset = this.log.getLong(this.logSize);
                this.logSize += 8L;
                int size = (int)((offset & 0x7FFF000000000000L) >>> 48);
                offset &= 0xFFFFFFFFFFFFL;
                DataInput2 input = this.log.getDataInput(this.logSize, size);
                ByteBuffer byteBuffer = input.buf;
                synchronized (byteBuffer) {
                    input.buf.position(input.pos);
                    input.buf.limit(input.pos + size);
                    this.phys.ensureAvailable(offset + (long)size);
                    this.phys.putData(offset, input.buf);
                    input.buf.clear();
                }
                this.logSize += (long)size;
            } else if (ins == 105) {
                this.logSize += 0x40000000L - this.logSize % 0x40000000L;
            } else {
                throw new InternalError("unknown trans log instruction: " + ins + " at log offset: " + (this.logSize - 1L));
            }
            ins = this.log.getByte(this.logSize);
            ++this.logSize;
        }
        this.logSize = 0L;
        this.phys.sync();
        this.index.sync();
        this.log.putLong(0L, 0L);
        this.log.putLong(8L, 0L);
        this.log.close();
        this.log.deleteFile();
        this.log = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.structuralLock.lock();
        Utils.writeLockAll(this.locks);
        try {
            if (this.log != null) {
                this.log.close();
                this.log.deleteFile();
                this.log = null;
            }
            this.reloadIndexFile();
        }
        finally {
            Utils.writeUnlockAll(this.locks);
            this.structuralLock.unlock();
        }
    }

    @Override
    protected long longStackTake(long ioList) {
        return 0L;
    }

    @Override
    protected void longStackPut(long ioList, long offset) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.structuralLock.lock();
        Utils.writeLockAll(this.locks);
        try {
            if (this.log != null) {
                this.log.sync();
                this.log.close();
                if (this.deleteFilesAfterClose) {
                    this.log.deleteFile();
                }
            }
            this.index.sync();
            this.phys.sync();
            this.index.close();
            this.phys.close();
            if (this.deleteFilesAfterClose) {
                this.index.deleteFile();
                this.phys.deleteFile();
            }
            this.index = null;
            this.phys = null;
        }
        finally {
            Utils.writeUnlockAll(this.locks);
            this.structuralLock.unlock();
        }
    }
}

