/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public final class CompressLZF {
    private static final int HASH_SIZE = 16384;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private int[] cachedHashTable;
    public static final Serializer<byte[]> SERIALIZER = new Serializer<byte[]>(){
        final ThreadLocal<CompressLZF> LZF = new ThreadLocal<CompressLZF>(){

            @Override
            protected CompressLZF initialValue() {
                return new CompressLZF();
            }
        };

        @Override
        public void serialize(DataOutput out, byte[] value) throws IOException {
            byte[] outbuf;
            if (value == null || value.length == 0) {
                Utils.packInt(out, 0);
                out.write(value);
                return;
            }
            CompressLZF lzf = this.LZF.get();
            int len = lzf.compress(value, value.length, outbuf = new byte[value.length + 40], 0);
            if (value.length <= len) {
                Utils.packInt(out, 0);
                out.write(value);
            } else {
                Utils.packInt(out, value.length);
                out.write(outbuf, 0, len);
            }
        }

        @Override
        public byte[] deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            DataInput2 in2 = (DataInput2)in;
            int origPos = in2.pos;
            int expendedLen = Utils.unpackInt(in);
            byte[] inbuf = new byte[available - (in2.pos - origPos)];
            in.readFully(inbuf);
            if (expendedLen == 0) {
                return inbuf;
            }
            byte[] outbuf = new byte[expendedLen + 40];
            CompressLZF lzf = this.LZF.get();
            lzf.expand(inbuf, 0, inbuf.length, outbuf, 0, expendedLen);
            outbuf = Arrays.copyOf(outbuf, expendedLen);
            return outbuf;
        }
    };

    private static int first(byte[] in, int inPos) {
        return in[inPos] << 8 | in[inPos + 1] & 0xFF;
    }

    private static int next(int v, byte[] in, int inPos) {
        return v << 8 | in[inPos + 2] & 0xFF;
    }

    private static int hash(int h) {
        return h * 2777 >> 9 & 0x3FFF;
    }

    public int compress(byte[] in, int inLen, byte[] out, int outPos) {
        int inPos = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] hashTab = this.cachedHashTable;
        int literals = 0;
        ++outPos;
        int future = CompressLZF.first(in, 0);
        while (inPos < inLen - 4) {
            byte p2 = in[inPos + 2];
            future = (future << 8) + (p2 & 0xFF);
            int off = CompressLZF.hash(future);
            int ref = hashTab[off];
            hashTab[off] = inPos;
            if (ref < inPos && ref > 0 && (off = inPos - ref - 1) < 8192 && in[ref + 2] == p2 && in[ref + 1] == (byte)(future >> 8) && in[ref] == (byte)(future >> 16)) {
                int len;
                int maxLen = inLen - inPos - 2;
                if (maxLen > 264) {
                    maxLen = 264;
                }
                if (literals == 0) {
                    --outPos;
                } else {
                    out[outPos - literals - 1] = (byte)(literals - 1);
                    literals = 0;
                }
                for (len = 3; len < maxLen && in[ref + len] == in[inPos + len]; ++len) {
                }
                if ((len -= 2) < 7) {
                    out[outPos++] = (byte)((off >> 8) + (len << 5));
                } else {
                    out[outPos++] = (byte)((off >> 8) + 224);
                    out[outPos++] = (byte)(len - 7);
                }
                out[outPos++] = (byte)off;
                ++outPos;
                future = CompressLZF.first(in, inPos += len);
                future = CompressLZF.next(future, in, inPos);
                hashTab[CompressLZF.hash((int)future)] = inPos++;
                future = CompressLZF.next(future, in, inPos);
                hashTab[CompressLZF.hash((int)future)] = inPos++;
                continue;
            }
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        while (inPos < inLen) {
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        out[outPos - literals - 1] = (byte)(literals - 1);
        if (literals == 0) {
            --outPos;
        }
        return outPos;
    }

    public void expand(byte[] in, int inPos, int inLen, byte[] out, int outPos, int outLen) {
        if (inPos < 0 || outPos < 0 || outLen < 0) {
            throw new IllegalArgumentException();
        }
        do {
            int ctrl;
            if ((ctrl = in[inPos++] & 0xFF) < 32) {
                System.arraycopy(in, inPos, out, outPos, ++ctrl);
                outPos += ctrl;
                inPos += ctrl;
                continue;
            }
            int len = ctrl >> 5;
            if (len == 7) {
                len += in[inPos++] & 0xFF;
            }
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            ctrl -= in[inPos++] & 0xFF;
            ctrl += outPos;
            if (outPos + (len += 2) >= out.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < len; ++i) {
                out[outPos++] = out[ctrl++];
            }
        } while (outPos < outLen);
    }

    public static <E> Serializer<E> CompressionWrapper(Serializer<E> serializer) {
        return new Serializer.CompressSerializerWrapper<E>(serializer);
    }
}

