/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.binding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LoggingProxy;
import uk.co.caprica.vlcj.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.version.Version;

public class LibVlcFactory {
    private static final String NATIVE_LIBRARY_HELP = "Failed to load the native library.\n\nThe error was \"{0}\".\n\nThe required native libraries are named \"{1}\" and \"{2}\".\n\nIn the text below <libvlc-path> represents the name of the directory containing \"{1}\" and \"{2}\"...\n\nThere are a number of different ways to specify where to find the native libraries:\n 1. Include NativeLibrary.addSearchPath(\"{3}\", \"<libvlc-path>\"); at the start of your application code.\n 2. Include System.setProperty(\"jna.library.path\", \"<libvlc-path>\"); at the start of your application code.\n 3. Specify -Djna.library.path=<libvlc-path> on the command-line when starting your application.\n 4. Add <libvlc-path> to the system search path (and reboot).\n\nIf this still does not work, then it may be necessary to explicitly add the native library directory to the operating\nsystem configuration - e.g. on Linux this might mean setting the LD_LIBRARY_PATH environment variable, or adding\nconfiguration to the \"/etc/ld.so.conf\" file or the \"/etc/ld.so.conf.d\" directory. Of these options, setting\nLD_LIBRARY_PATH is the only one that would not require root privileges.\n\nFinally, it is not possible to mix CPU architectures - it is not possible for a 64-bit Java Virtual Machine to load\n32-bit native libraries.\n\nMore information may be available in the log, specify -Dvlcj.log=DEBUG on the command-line when starting your application.\n";
    private boolean synchronise;
    private boolean log;
    private Version requiredVersion;
    private NativeDiscovery discovery;

    private LibVlcFactory() {
    }

    public static LibVlcFactory factory() {
        return new LibVlcFactory();
    }

    public LibVlcFactory synchronise() {
        this.synchronise = true;
        return this;
    }

    public LibVlcFactory log() {
        this.log = true;
        return this;
    }

    public LibVlcFactory atLeast(String version) {
        this.requiredVersion = new Version(version);
        return this;
    }

    public LibVlcFactory discovery(NativeDiscovery discovery) {
        this.discovery = discovery;
        return this;
    }

    public LibVlc create() {
        if (this.discovery != null) {
            this.discovery.discover();
        }
        try {
            LibVlc instance;
            LibVlc libVlc = instance = this.synchronise ? LibVlc.SYNC_INSTANCE : LibVlc.INSTANCE;
            if (this.log) {
                instance = (LibVlc)Proxy.newProxyInstance(LibVlc.class.getClassLoader(), new Class[]{LibVlc.class}, (InvocationHandler)new LoggingProxy(instance));
            }
            String nativeVersion = instance.libvlc_get_version();
            Logger.info("vlc: {}, changeset {}", nativeVersion, LibVlc.INSTANCE.libvlc_get_changeset());
            Logger.info("libvlc: {}", LibVlcFactory.getNativeLibraryPath(instance));
            if (this.requiredVersion != null) {
                Version actualVersion;
                try {
                    actualVersion = new Version(nativeVersion);
                }
                catch (Throwable t) {
                    Logger.error("Unable to parse native library version {} because of {}", nativeVersion, t);
                    actualVersion = null;
                }
                if (actualVersion != null) {
                    if (!actualVersion.atLeast(this.requiredVersion)) {
                        Logger.fatal("This version of vlcj requires version {} or later of libvlc, found too old version {}", this.requiredVersion, actualVersion);
                        throw new RuntimeException("This version of vlcj requires version " + this.requiredVersion + " or later of libvlc, found too old version " + actualVersion + ".");
                    }
                } else {
                    Logger.fatal("Unable to check the native library version '{}'", nativeVersion);
                    throw new RuntimeException("Unable to check the native library version " + nativeVersion);
                }
            }
            return instance;
        }
        catch (UnsatisfiedLinkError e) {
            Logger.error("Failed to load native library", new Object[0]);
            String msg = MessageFormat.format(NATIVE_LIBRARY_HELP, e.getMessage(), RuntimeUtil.getLibVlcName(), RuntimeUtil.getLibVlcCoreName(), RuntimeUtil.getLibVlcLibraryName());
            throw new RuntimeException(msg);
        }
    }

    private static String getNativeLibraryPath(Object library) {
        int end;
        String s = library.toString();
        int start = s.indexOf(60);
        if (start != -1 && (end = s.indexOf(64, ++start)) != -1) {
            s = s.substring(start, end);
            return s;
        }
        return s;
    }
}

