/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import messages.Messages;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelFog
extends JPanel {
    private SmedAction dlg;
    private ButtonGroup fogButtons = new ButtonGroup();
    public JRadioButton noFogButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/OffButton.png")));
    public JRadioButton yesFogButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogYesButton.png")));
    public JRadioButton hornButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogHornButton.png")));
    public JRadioButton sirenButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogSirenButton.png")));
    public JRadioButton diaButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogDiaButton.png")));
    public JRadioButton bellButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogBellButton.png")));
    public JRadioButton whisButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogWhisButton.png")));
    public JRadioButton gongButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogGongButton.png")));
    public JRadioButton explosButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FogExplosButton.png")));
    private EnumMap<SeaMark.Fog, JRadioButton> fogs = new EnumMap(SeaMark.Fog.class);
    private ActionListener alFog = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Fog fog : PanelFog.this.fogs.keySet()) {
                JRadioButton button = (JRadioButton)PanelFog.this.fogs.get((Object)fog);
                if (button.isSelected()) {
                    PanelFog.this.dlg;
                    SmedAction.panelMain.mark.setFogSound(fog);
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
        }
    };
    public JLabel groupLabel;
    public JTextField groupBox;
    private FocusListener flGroup = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            PanelFog.this.dlg;
            SmedAction.panelMain.mark.setFogGroup(PanelFog.this.groupBox.getText());
        }
    };
    public JLabel periodLabel;
    public JTextField periodBox;
    private FocusListener flPeriod = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            PanelFog.this.dlg;
            SmedAction.panelMain.mark.setFogPeriod(PanelFog.this.periodBox.getText());
        }
    };
    public JLabel seqLabel;
    public JTextField seqBox;
    private FocusListener flSeq = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            PanelFog.this.dlg;
            SmedAction.panelMain.mark.setFogSequence(PanelFog.this.seqBox.getText());
        }
    };
    public JLabel rangeLabel;
    public JTextField rangeBox;
    private FocusListener flRange = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            PanelFog.this.dlg;
            SmedAction.panelMain.mark.setFogRange(PanelFog.this.rangeBox.getText());
        }
    };

    public PanelFog(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getFogButton(this.noFogButton, 0, 2, 27, 27, "NoFog", SeaMark.Fog.NOFOG));
        this.add(this.getFogButton(this.yesFogButton, 0, 32, 27, 27, "FogSignal", SeaMark.Fog.FOGSIG));
        this.add(this.getFogButton(this.hornButton, 0, 62, 27, 27, "Horn", SeaMark.Fog.HORN));
        this.add(this.getFogButton(this.sirenButton, 0, 92, 27, 27, "Siren", SeaMark.Fog.SIREN));
        this.add(this.getFogButton(this.gongButton, 0, 122, 27, 27, "Gong", SeaMark.Fog.GONG));
        this.add(this.getFogButton(this.diaButton, 30, 2, 27, 27, "Diaphone", SeaMark.Fog.DIA));
        this.add(this.getFogButton(this.bellButton, 30, 32, 27, 27, "Bell", SeaMark.Fog.BELL));
        this.add(this.getFogButton(this.whisButton, 30, 62, 27, 27, "Whistle", SeaMark.Fog.WHIS));
        this.add(this.getFogButton(this.explosButton, 30, 92, 27, 27, "Explosion", SeaMark.Fog.EXPLOS));
        this.groupLabel = new JLabel(Messages.getString("Group"), 0);
        this.groupLabel.setBounds(new Rectangle(75, 0, 100, 20));
        this.add(this.groupLabel);
        this.groupBox = new JTextField();
        this.groupBox.setBounds(new Rectangle(100, 20, 50, 20));
        this.groupBox.setHorizontalAlignment(0);
        this.add(this.groupBox);
        this.groupBox.addFocusListener(this.flGroup);
        this.periodLabel = new JLabel(Messages.getString("Period"), 0);
        this.periodLabel.setBounds(new Rectangle(75, 40, 100, 20));
        this.add(this.periodLabel);
        this.periodBox = new JTextField();
        this.periodBox.setBounds(new Rectangle(100, 60, 50, 20));
        this.periodBox.setHorizontalAlignment(0);
        this.add(this.periodBox);
        this.periodBox.addFocusListener(this.flPeriod);
        this.seqLabel = new JLabel(Messages.getString("Sequence"), 0);
        this.seqLabel.setBounds(new Rectangle(75, 80, 100, 20));
        this.add(this.seqLabel);
        this.seqBox = new JTextField();
        this.seqBox.setBounds(new Rectangle(100, 100, 50, 20));
        this.seqBox.setHorizontalAlignment(0);
        this.add(this.seqBox);
        this.seqBox.addFocusListener(this.flSeq);
        this.rangeLabel = new JLabel(Messages.getString("Range"), 0);
        this.rangeLabel.setBounds(new Rectangle(75, 120, 100, 20));
        this.add(this.rangeLabel);
        this.rangeBox = new JTextField();
        this.rangeBox.setBounds(new Rectangle(100, 140, 50, 20));
        this.rangeBox.setHorizontalAlignment(0);
        this.add(this.rangeBox);
        this.rangeBox.addFocusListener(this.flRange);
    }

    public void syncPanel() {
        for (SeaMark.Fog fog : this.fogs.keySet()) {
            JRadioButton button = this.fogs.get((Object)fog);
            button.setBorderPainted(SmedAction.panelMain.mark.getFogSound() == fog);
        }
        this.groupBox.setText(SmedAction.panelMain.mark.getFogGroup());
        this.seqBox.setText(SmedAction.panelMain.mark.getFogSequence());
        this.periodBox.setText(SmedAction.panelMain.mark.getFogPeriod());
        this.rangeBox.setText(SmedAction.panelMain.mark.getFogRange());
    }

    private JRadioButton getFogButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Fog fog) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alFog);
        this.fogButtons.add(button);
        this.fogs.put(fog, button);
        return button;
    }
}

