/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveRelationMemberCommand
extends Command {
    private final Relation relation;
    private final RelationMember member;
    private int location = -1;

    public RemoveRelationMemberCommand(Relation _relation, RelationMember _member) {
        this.relation = _relation;
        this.member = _member;
    }

    public RemoveRelationMemberCommand(Relation _relation, RelationMember _member, int _location) {
        this.relation = _relation;
        this.member = _member;
        this.location = _location;
    }

    public boolean executeCommand() {
        super.executeCommand();
        int removeIndex = this.relation.getMembers().indexOf(this.member);
        if (this.location != -1 && removeIndex != this.location) {
            Main.debug((String)"error removing relation member");
            return false;
        }
        this.relation.removeMember(removeIndex);
        this.relation.setModified(true);
        return true;
    }

    public void undoCommand() {
        super.undoCommand();
        this.relation.addMember(this.member);
        this.relation.setModified(this.getOrig((OsmPrimitive)this.relation).isModified());
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        String msg = "";
        switch (OsmPrimitiveType.from((IPrimitive)this.member.getMember())) {
            case NODE: {
                msg = I18n.marktr((String)"Remove node ''{0}'' at position {1} from relation ''{2}''");
                break;
            }
            case WAY: {
                msg = I18n.marktr((String)"Remove way ''{0}'' at position {1} from relation ''{2}''");
                break;
            }
            case RELATION: {
                msg = I18n.marktr((String)"Remove relation ''{0}'' at position {1} from relation ''{2}''");
            }
        }
        return I18n.tr((String)msg, (Object[])new Object[]{this.member.getMember().getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.relation.getMembers().indexOf(this.member), this.relation.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((OsmPrimitiveType)OsmPrimitiveType.from((IPrimitive)this.relation));
    }
}

