/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.npm;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.plugins.npm.NPMType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class NPMCredentialsAgent
extends AbstractCredentialsAgent {
    private KeyringProvider provider;
    private NPMType type;
    private Map<Authenticator.RequestorType, PasswordAuthentication> credentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();
    private OAuthToken oauthCache;

    public NPMCredentialsAgent(NPMType type) {
        this.type = type;
    }

    private KeyringProvider getProvider() {
        if (this.provider == null) {
            this.provider = this.type.getProvider();
        }
        return this.provider;
    }

    protected String getServerDescriptor() {
        String pref = Main.pref.getPreferenceFile().getAbsolutePath();
        String url = Main.pref.get("osm-server.url", null);
        if (url == null) {
            url = "http://api.openstreetmap.org/api";
        }
        CRC32 id = new CRC32();
        id.update((pref + "/" + url).getBytes());
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.api." + hash;
    }

    protected String getProxyDescriptor() {
        String pref = Main.pref.getPreferenceFile().getAbsolutePath();
        String host = Main.pref.get("proxy.http.host", "");
        String port = Main.pref.get("proxy.http.port", "");
        CRC32 id = new CRC32();
        id.update((pref + "/" + host + "/" + port).getBytes());
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.proxy." + hash;
    }

    protected String getOAuthDescriptor() {
        String pref = Main.pref.getPreferenceFile().getAbsolutePath();
        CRC32 id = new CRC32();
        id.update(pref.getBytes());
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.oauth." + hash;
    }

    public PasswordAuthentication lookup(Authenticator.RequestorType rt, String host) throws CredentialsAgentException {
        PasswordAuthentication auth;
        PasswordAuthentication cache = this.credentialsCache.get((Object)rt);
        if (cache != null) {
            return cache;
        }
        switch (rt) {
            case SERVER: {
                char[] password;
                String user;
                if (OsmApi.getOsmApi().getHost().equals(host)) {
                    user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(this.getServerDescriptor() + ".username"));
                    password = this.getProvider().read(this.getServerDescriptor() + ".password");
                } else {
                    user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(host + ".username"));
                    password = this.getProvider().read(host + ".password");
                }
                auth = new PasswordAuthentication(user, password == null ? new char[]{} : password);
                break;
            }
            case PROXY: {
                String user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(this.getProxyDescriptor() + ".username"));
                char[] password = this.getProvider().read(this.getProxyDescriptor() + ".password");
                auth = new PasswordAuthentication(user, password == null ? new char[]{} : password);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.credentialsCache.put(rt, auth);
        return auth;
    }

    public void store(Authenticator.RequestorType rt, String host, PasswordAuthentication credentials) throws CredentialsAgentException {
        String passwordDescription;
        String usernameDescription;
        String prefix;
        char[] password;
        char[] username;
        if (credentials == null) {
            username = null;
            password = null;
        } else {
            username = credentials.getUserName() == null ? null : credentials.getUserName().toCharArray();
            password = credentials.getPassword();
        }
        if (username != null && username.length == 0) {
            username = null;
        }
        switch (rt) {
            case SERVER: {
                if (OsmApi.getOsmApi().getHost().equals(host)) {
                    prefix = this.getServerDescriptor();
                    usernameDescription = I18n.tr((String)"JOSM/OSM API/Username", (Object[])new Object[0]);
                    passwordDescription = I18n.tr((String)"JOSM/OSM API/Password", (Object[])new Object[0]);
                    break;
                }
                prefix = host;
                usernameDescription = I18n.tr((String)"{0}/Username", (Object[])new Object[]{host});
                passwordDescription = I18n.tr((String)"{0}/Password", (Object[])new Object[]{host});
                break;
            }
            case PROXY: {
                prefix = this.getProxyDescriptor();
                usernameDescription = I18n.tr((String)"JOSM/Proxy/Username", (Object[])new Object[0]);
                passwordDescription = I18n.tr((String)"JOSM/Proxy/Password", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (username == null) {
            this.getProvider().delete(prefix + ".username");
            this.getProvider().delete(prefix + ".password");
            this.credentialsCache.remove((Object)rt);
        } else {
            this.getProvider().save(prefix + ".username", username, usernameDescription);
            if (password == null) {
                this.getProvider().delete(prefix + ".password");
            } else {
                this.getProvider().save(prefix + ".password", password, passwordDescription);
            }
            this.credentialsCache.put(rt, new PasswordAuthentication(NPMCredentialsAgent.stringNotNull(username), password));
        }
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        if (this.oauthCache != null) {
            return this.oauthCache;
        }
        String prolog = this.getOAuthDescriptor();
        char[] key = this.getProvider().read(prolog + ".key");
        char[] secret = this.getProvider().read(prolog + ".secret");
        return new OAuthToken(NPMCredentialsAgent.stringNotNull(key), NPMCredentialsAgent.stringNotNull(secret));
    }

    public void storeOAuthAccessToken(OAuthToken oat) throws CredentialsAgentException {
        String secret;
        String key;
        if (oat == null) {
            key = null;
            secret = null;
        } else {
            key = oat.getKey();
            secret = oat.getSecret();
        }
        String prolog = this.getOAuthDescriptor();
        if (key == null || Utils.equal((Object)key, (Object)"") || secret == null || Utils.equal((Object)secret, (Object)"")) {
            this.getProvider().delete(prolog + ".key");
            this.getProvider().delete(prolog + ".secret");
            this.oauthCache = null;
        } else {
            this.getProvider().save(prolog + ".key", key.toCharArray(), I18n.tr((String)"JOSM/OAuth/OSM API/Key", (Object[])new Object[0]));
            this.getProvider().save(prolog + ".secret", secret.toCharArray(), I18n.tr((String)"JOSM/OAuth/OSM API/Secret", (Object[])new Object[0]));
            this.oauthCache = new OAuthToken(key, secret);
        }
    }

    private static String stringNotNull(char[] charData) {
        if (charData == null) {
            return "";
        }
        return String.valueOf(charData);
    }

    public Component getPreferencesDecorationPanel() {
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        StringBuilder text = new StringBuilder();
        text.append("<html><body><p class=\"warning-body\"><strong>" + I18n.tr((String)"Native Password Manager Plugin", (Object[])new Object[0]) + "</strong><br>" + I18n.tr((String)"The username and password is protected by {0}.", (Object[])new Object[]{this.type.getName()}));
        ArrayList<String> sensitive = new ArrayList<String>();
        if (Main.pref.get("osm-server.username", null) != null) {
            sensitive.add(I18n.tr((String)"username", (Object[])new Object[0]));
        }
        if (Main.pref.get("osm-server.password", null) != null) {
            sensitive.add(I18n.tr((String)"password", (Object[])new Object[0]));
        }
        if (Main.pref.get("proxy.user", null) != null) {
            sensitive.add(I18n.tr((String)"proxy username", (Object[])new Object[0]));
        }
        if (Main.pref.get("proxy.pass", null) != null) {
            sensitive.add(I18n.tr((String)"proxy password", (Object[])new Object[0]));
        }
        if (Main.pref.get("oauth.access-token.key", null) != null) {
            sensitive.add(I18n.tr((String)"oauth key", (Object[])new Object[0]));
        }
        if (Main.pref.get("oauth.access-token.secret", null) != null) {
            sensitive.add(I18n.tr((String)"oauth secret", (Object[])new Object[0]));
        }
        if (!sensitive.isEmpty()) {
            text.append(I18n.tr((String)"<br><strong>Warning:</strong> There may be sensitive data left in your preference file. ({0})", (Object[])new Object[]{Utils.join((String)", ", sensitive)}));
        }
        pnlMessage.setText(text.toString());
        return pnlMessage;
    }

    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr((String)"Save user and password ({0})", (Object[])new Object[]{this.type.getName()});
    }
}

