/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HgtReader {
    private static final int SECONDS_PER_MINUTE = 60;
    public static final String HGT_EXT = ".hgt";
    public static final int HGT_RES = 3;
    public static final int HGT_ROW_LENGTH = 1201;
    public static final int HGT_VOID = Short.MIN_VALUE;
    private HashMap<String, ShortBuffer> cache = new HashMap();

    public double getElevationFromHgt(LatLon coor) {
        try {
            String file = this.getHgtFileName(coor);
            if (!this.cache.containsKey(file)) {
                this.cache.put(file, null);
                for (String location : Main.pref.getAllPossiblePreferenceDirs()) {
                    String fullPath = new File(location + File.separator + "elevation", file).getPath();
                    File f = new File(fullPath);
                    if (!f.exists()) continue;
                    ShortBuffer data = this.readHgtFile(fullPath);
                    this.cache.put(file, data);
                    break;
                }
            }
            return this.readElevation(coor);
        }
        catch (FileNotFoundException e) {
            System.err.println("Get elevation from HGT " + coor + " failed: => " + e.getMessage());
            return ElevationHelper.NO_ELEVATION;
        }
        catch (Exception ioe) {
            ioe.printStackTrace(System.err);
            return ElevationHelper.NO_ELEVATION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortBuffer readHgtFile(String file) throws Exception {
        CheckParameterUtil.ensureParameterNotNull((Object)file);
        FileChannel fc = null;
        ShortBuffer sb = null;
        try {
            fc = new FileInputStream(file).getChannel();
            ByteBuffer bb = ByteBuffer.allocateDirect((int)fc.size());
            while (bb.remaining() > 0) {
                fc.read(bb);
            }
            bb.flip();
            sb = bb.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
        return sb;
    }

    public double readElevation(LatLon coor) {
        String tag = this.getHgtFileName(coor);
        ShortBuffer sb = this.cache.get(tag);
        if (sb == null) {
            return ElevationHelper.NO_ELEVATION;
        }
        double fLat = HgtReader.frac(coor.lat()) * 60.0;
        double fLon = HgtReader.frac(coor.lon()) * 60.0;
        int row = (int)Math.round(fLat * 60.0 / 3.0);
        int col = (int)Math.round(fLon * 60.0 / 3.0);
        int cell = 1201 * ((row = 1201 - row) - 1) + col;
        if (cell < sb.limit()) {
            short ele = sb.get(cell);
            if (ele == Short.MIN_VALUE) {
                return ElevationHelper.NO_ELEVATION;
            }
            return ele;
        }
        return ElevationHelper.NO_ELEVATION;
    }

    public String getHgtFileName(LatLon latLon) {
        int lat = (int)latLon.lat();
        int lon = (int)latLon.lon();
        String latPref = "N";
        if (lat < 0) {
            latPref = "S";
        }
        String lonPref = "E";
        if (lon < 0) {
            lonPref = "W";
        }
        return String.format("%s%02d%s%03d%s", latPref, lat, lonPref, lon, HGT_EXT);
    }

    public static double frac(double d) {
        long iPart = (long)d;
        double fPart = d - (double)iPart;
        return fPart;
    }
}

