/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public abstract class AbstractNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    private final List<String> fileNames = new ArrayList<String>(2);

    public AbstractNativeDiscoveryStrategy() {
        this.fileNames.add(RuntimeUtil.getLibVlcName());
        this.fileNames.add(RuntimeUtil.getLibVlcCoreName());
    }

    @Override
    public final String discover() {
        Logger.debug("discover()", new Object[0]);
        String result = null;
        ArrayList<String> directoryNames = new ArrayList<String>();
        this.getDirectoryNames(directoryNames);
        Logger.debug("directoryNames={}", directoryNames);
        if (directoryNames != null) {
            Logger.debug("fileNames={}", this.fileNames);
            for (String directoryName : directoryNames) {
                Logger.debug("directoryName={}", directoryName);
                result = directoryName;
                File dir = new File(directoryName);
                for (String fileName : this.fileNames) {
                    Logger.debug("fileName={}", fileName);
                    File file = new File(dir, fileName);
                    if (file.exists()) continue;
                    Logger.debug("File does not exist", new Object[0]);
                    result = null;
                    break;
                }
                if (result == null) continue;
                break;
            }
        }
        Logger.debug("result={}", result);
        return result;
    }

    protected final List<String> getSystemPath() {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] paths = path.split(File.pathSeparator);
            return Arrays.asList(paths);
        }
        return Collections.emptyList();
    }

    protected abstract void getDirectoryNames(List<String> var1);
}

