/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.data;

import java.util.Collection;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;

public class XmlBoundsConverter
implements XmlBoundsConstants {
    public static DataSet convertImageryEntries(List<ImageryInfo> entries) {
        DataSet dataSet = new DataSet();
        for (ImageryInfo imagery : entries) {
            ImageryInfo.ImageryBounds bounds;
            if (imagery.isBlacklisted() || (bounds = imagery.getBounds()) == null) continue;
            dataSet.addPrimitive(XmlBoundsConverter.convertImagery(imagery, bounds, dataSet));
        }
        return dataSet;
    }

    private static void safePut(OsmPrimitive p, String key, Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                String s = "";
                for (Object elt : (Collection)value) {
                    if (elt == null || elt.toString() == null || elt.toString().isEmpty()) continue;
                    if (!s.isEmpty()) {
                        s = s + ";";
                    }
                    s = s + elt.toString();
                }
                if (!s.isEmpty()) {
                    p.put(key, s);
                }
            } else if (!value.equals(0) && value.toString() != null && !value.toString().isEmpty()) {
                p.put(key, value.toString());
            }
        }
    }

    private static Node getNode(LatLon latlon, DataSet dataSet) {
        List nodes = dataSet.searchNodes(new BBox(latlon, latlon));
        if (!nodes.isEmpty()) {
            return (Node)nodes.get(0);
        }
        Node node = new Node(latlon);
        dataSet.addPrimitive((OsmPrimitive)node);
        return node;
    }

    private static Node getNode(double lat, double lon, DataSet dataSet) {
        return XmlBoundsConverter.getNode(new LatLon(lat, lon), dataSet);
    }

    private static void ensureWayIsClosed(Way way) {
        if (!way.getNode(0).equals((Object)way.getNode(way.getNodesCount() - 1))) {
            way.addNode(way.getNode(0));
        }
    }

    private static OsmPrimitive convertImagery(ImageryInfo imagery, ImageryInfo.ImageryBounds bounds, DataSet dataSet) {
        Relation osmImagery = null;
        if (bounds.getShapes().isEmpty()) {
            LatLon bottomLeft = bounds.getMin();
            LatLon topRight = bounds.getMax();
            LatLon topLeft = new LatLon(topRight.lat(), bottomLeft.lon());
            LatLon bottomRight = new LatLon(bottomLeft.lat(), topRight.lon());
            Way way = new Way();
            for (LatLon ll : new LatLon[]{bottomLeft, topLeft, topRight, bottomRight}) {
                way.addNode(XmlBoundsConverter.getNode(ll, dataSet));
            }
            XmlBoundsConverter.ensureWayIsClosed(way);
            osmImagery = way;
        } else {
            Relation relation = new Relation();
            relation.put("type", "multipolygon");
            for (Shape shape : bounds.getShapes()) {
                Way way = new Way();
                for (Coordinate coor : shape.getPoints()) {
                    way.addNode(XmlBoundsConverter.getNode(coor.getLat(), coor.getLon(), dataSet));
                }
                XmlBoundsConverter.ensureWayIsClosed(way);
                dataSet.addPrimitive((OsmPrimitive)way);
                relation.addMember(new RelationMember("outer", (OsmPrimitive)way));
            }
            osmImagery = relation;
        }
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "name", imagery.getName());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:type", imagery.getImageryType().getTypeString());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:default", imagery.isDefaultEntry());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:url", imagery.getUrl());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:projections", imagery.getServerProjections());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:eula", imagery.getEulaAcceptanceRequired());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:attribution-text", imagery.getAttributionText(0, null, null));
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:attribution-url", imagery.getAttributionLinkURL());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:terms-of-use-text", imagery.getTermsOfUseText());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:terms-of-use-url", imagery.getTermsOfUseURL());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:country-code", imagery.getCountryCode());
        XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:logo-url", imagery.getAttributionImageURL());
        if (imagery.getImageryType().equals((Object)ImageryInfo.ImageryType.TMS)) {
            XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:max-zoom", imagery.getMaxZoom());
            XmlBoundsConverter.safePut((OsmPrimitive)osmImagery, "imagery:min-zoom", imagery.getMinZoom());
        }
        return osmImagery;
    }
}

