/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenInBrowserAction
extends OsbAction {
    private static final long serialVersionUID = 1L;
    private Node node;

    public OpenInBrowserAction(OsbDialog dialog) {
        super(I18n.tr((String)"Open in browser", (Object[])new Object[0]), dialog);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) throws Exception {
        this.node = this.dialog.getSelectedNode();
        if (this.node != null) {
            String uri = "http://openstreetbugs.schokokeks.org/?lon=" + this.node.getCoor().getX() + "&lat=" + this.node.getCoor().getY() + "&zoom=16&layers=B00T";
            System.out.println("Opening URI " + uri);
            OpenBrowser.displayUrl((String)uri);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No item selected", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }

    @Override
    public void execute() throws IOException {
    }

    public String toString() {
        return I18n.tr((String)("Open in browser: " + this.node.get("note")), (Object[])new Object[0]);
    }

    @Override
    public OpenInBrowserAction clone() {
        OpenInBrowserAction action = new OpenInBrowserAction(this.dialog);
        action.node = this.node;
        return action;
    }
}

