/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class PutninsP5Projection
extends Projection {
    protected double A = 2.0;
    protected double B = 1.0;
    private static final double C = 1.01346;
    private static final double D = 1.2158542;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        xy.x = 1.01346 * lplam * (this.A - this.B * Math.sqrt(1.0 + 1.2158542 * lpphi * lpphi));
        xy.y = 1.01346 * lpphi;
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate lp) {
        lp.y = xyy / 1.01346;
        lp.x = xyx / (1.01346 * (this.A - this.B * Math.sqrt(1.0 + 1.2158542 * lp.y * lp.y)));
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Putnins P5";
    }
}

