/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.RepaintManager;

class PrintPreview
extends JPanel {
    protected PageFormat format = null;
    protected double zoom = 1.0;
    protected boolean zoomToPage = true;
    protected boolean paintingDisabled = false;
    protected Printable printable = null;

    public PrintPreview() {
    }

    public PrintPreview(Printable p) {
        this.printable = p;
    }

    public void setPrintable(Printable p) {
        this.printable = p;
        this.repaint();
    }

    public void setPageFormat(PageFormat format) {
        this.format = format;
        this.revalidate();
        this.repaint();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, false);
    }

    public void zoomIn() {
        double zoom = this.getZoom();
        if (zoom < 5.0) {
            this.setZoom(2.0 * zoom);
        }
    }

    public void zoomOut() {
        double zoom = this.getZoom();
        if (zoom > 0.1) {
            this.setZoom(0.5 * zoom);
        }
    }

    public void zoomToPage() {
        Container parent = this.getParent();
        Dimension dim = parent instanceof JViewport ? this.getParent().getSize() : this.getVisibleRect().getSize();
        int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        double widthZoom = 72.0 * dim.getWidth() / (double)resolution / this.format.getWidth();
        double heightZoom = 72.0 * dim.getHeight() / (double)resolution / this.format.getHeight();
        this.setZoom(Math.min(widthZoom, heightZoom), true);
    }

    protected void setZoom(double zoom, boolean zoomToPage) {
        if (this.format == null || zoom == this.zoom) {
            return;
        }
        Dimension oldDim = this.getZoomedPageDimension();
        Rectangle oldView = this.getVisibleRect();
        this.paintingDisabled = true;
        this.zoom = zoom;
        this.zoomToPage = zoomToPage;
        this.revalidate();
        RepaintManager.currentManager(this).validateInvalidComponents();
        Dimension dim = this.getZoomedPageDimension();
        Rectangle view = this.getVisibleRect();
        view.x = (int)((0.5 * (double)oldView.width + (double)oldView.x) / (double)Math.max(oldView.width, oldDim.width) * (double)Math.max(view.width, dim.width) - 0.5 * (double)view.width);
        view.y = (int)((0.5 * (double)oldView.height + (double)oldView.y) / (double)Math.max(oldView.height, oldDim.height) * (double)Math.max(view.height, dim.height) - 0.5 * (double)view.height);
        this.scrollRectToVisible(view);
        this.paintingDisabled = false;
        this.repaint(view);
    }

    public double getZoom() {
        if (this.zoomToPage || this.zoom < 0.01) {
            Dimension dim = this.getParent().getSize();
            int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            double widthZoom = 72.0 * dim.getWidth() / (double)resolution / this.format.getWidth();
            double heightZoom = 72.0 * dim.getHeight() / (double)resolution / this.format.getHeight();
            return Math.min(widthZoom, heightZoom);
        }
        return this.zoom;
    }

    public Dimension getZoomedPageDimension() {
        int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        double zoom = this.getZoom();
        int width = (int)(zoom * (double)resolution * this.format.getWidth() / 72.0);
        int height = (int)(zoom * (double)resolution * this.format.getHeight() / 72.0);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.format == null || this.zoomToPage || this.zoom < 0.01) {
            return new Dimension(0, 0);
        }
        return this.getZoomedPageDimension();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.paintingDisabled) {
            return;
        }
        super.paintComponent(g);
        if (this.format == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        Dimension out = this.getZoomedPageDimension();
        double scale = Math.min(out.getHeight() / this.format.getHeight(), out.getWidth() / this.format.getWidth());
        double left = 0.5 * ((double)this.getWidth() - scale * this.format.getWidth());
        double top = 0.5 * ((double)this.getHeight() - scale * this.format.getHeight());
        g2d.translate(left, top);
        g2d.setColor(Color.black);
        g2d.drawRect(-1, -1, out.width + 1, out.height + 1);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, out.width, out.height);
        g2d.scale(scale, scale);
        g2d.clip(new Rectangle2D.Double(this.format.getImageableX(), this.format.getImageableY(), this.format.getImageableWidth(), this.format.getImageableHeight()));
        if (this.printable != null) {
            try {
                this.printable.print(g2d, this.format, 0);
            }
            catch (PrinterException e) {}
        } else {
            g2d.setColor(Color.gray);
            g2d.fillRect(0, 0, (int)this.format.getWidth(), (int)this.format.getHeight());
        }
        g2d.setTransform(at);
    }
}

