/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementImpl
implements ContrastEnhancement {
    private FilterFactory filterFactory;
    private Expression gamma;
    private Expression type;
    private ContrastMethod method;

    public ContrastEnhancementImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public ContrastEnhancementImpl(FilterFactory factory) {
        this(factory, null);
    }

    public ContrastEnhancementImpl(FilterFactory factory, ContrastMethod method) {
        this.filterFactory = factory;
        this.method = method;
    }

    public ContrastEnhancementImpl(org.opengis.style.ContrastEnhancement contrastEnhancement) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        this.method = contrastEnhancement.getMethod();
        this.gamma = contrastEnhancement.getGammaValue();
    }

    public ContrastEnhancementImpl(FilterFactory2 factory, Expression gamma, ContrastMethod method) {
        this.filterFactory = factory;
        this.gamma = gamma;
        this.method = method;
        this.type = factory.literal(method.name());
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    @Override
    public Expression getGammaValue() {
        return this.gamma;
    }

    @Override
    public Expression getType() {
        return this.type;
    }

    @Override
    public void setGammaValue(Expression gamma) {
        this.gamma = gamma;
    }

    @Override
    public void setHistogram() {
        this.type = this.filterFactory.literal("Histogram");
        this.method = ContrastMethod.HISTOGRAM;
    }

    @Override
    public void setNormalize() {
        this.type = this.filterFactory.literal("Normalize");
        this.method = ContrastMethod.NORMALIZE;
    }

    @Override
    public void setLogarithmic() {
        this.type = this.filterFactory.literal("Logarithmic");
        this.method = ContrastMethod.NONE;
    }

    @Override
    public void setExponential() {
        this.type = this.filterFactory.literal("Exponential");
        this.method = ContrastMethod.NONE;
    }

    @Override
    public void setType(Expression type) {
        String value;
        this.type = type;
        this.method = type instanceof Literal ? ("Histogram".equalsIgnoreCase(value = type.evaluate(null, String.class)) ? ContrastMethod.HISTOGRAM : ("Normalize".equalsIgnoreCase(value) ? ContrastMethod.NORMALIZE : ContrastMethod.NONE)) : ContrastMethod.NONE;
    }

    @Override
    public void setMethod(ContrastMethod method) {
        if (method == ContrastMethod.NORMALIZE) {
            this.type = this.filterFactory.literal("Normalize");
            this.method = ContrastMethod.NORMALIZE;
        } else if (method == ContrastMethod.HISTOGRAM) {
            this.type = this.filterFactory.literal("Histogram");
            this.method = ContrastMethod.HISTOGRAM;
        } else {
            this.method = method;
        }
    }

    @Override
    public ContrastMethod getMethod() {
        return this.method;
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object extraData) {
        return null;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.gamma != null) {
            result = 1000003 * result + this.gamma.hashCode();
        }
        if (this.type != null) {
            result = 1000003 * result + this.type.hashCode();
        }
        if (this.method != null) {
            result = 1000003 * result + this.method.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContrastEnhancementImpl) {
            ContrastEnhancementImpl other = (ContrastEnhancementImpl)obj;
            return Utilities.equals(this.gamma, other.gamma) && Utilities.equals(this.type, other.type) && Utilities.equals(this.method, other.method);
        }
        return false;
    }

    static ContrastEnhancementImpl cast(org.opengis.style.ContrastEnhancement enhancement) {
        if (enhancement == null) {
            return null;
        }
        if (enhancement instanceof ContrastEnhancementImpl) {
            return (ContrastEnhancementImpl)enhancement;
        }
        ContrastEnhancementImpl copy = new ContrastEnhancementImpl();
        copy.setGammaValue(enhancement.getGammaValue());
        copy.setMethod(enhancement.getMethod());
        return copy;
    }
}

