/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.DirectPropertyAccessorFactory;
import org.geotools.filter.expression.NullPropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;

public class PropertyAccessors {
    static final PropertyAccessorFactory[] FACTORY_CACHE;

    private PropertyAccessors() {
    }

    public static PropertyAccessor findPropertyAccessor(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        for (PropertyAccessorFactory factory : FACTORY_CACHE) {
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor == null || !accessor.canHandle(object, xpath, target)) continue;
            return accessor;
        }
        return null;
    }

    public static List<PropertyAccessor> findPropertyAccessors(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        ArrayList<PropertyAccessor> list = new ArrayList<PropertyAccessor>();
        for (PropertyAccessorFactory factory : FACTORY_CACHE) {
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor == null || !accessor.canHandle(object, xpath, target)) continue;
            list.add(accessor);
        }
        return list;
    }

    static {
        ArrayList<PropertyAccessorFactory> cache = new ArrayList<PropertyAccessorFactory>();
        cache.add(new NullPropertyAccessorFactory());
        cache.add(new SimpleFeaturePropertyAccessorFactory());
        cache.add(new DirectPropertyAccessorFactory());
        Iterator<PropertyAccessorFactory> factories = FactoryRegistry.lookupProviders(PropertyAccessorFactory.class);
        while (factories.hasNext()) {
            PropertyAccessorFactory factory = factories.next();
            if (factory instanceof SimpleFeaturePropertyAccessorFactory || factory instanceof DirectPropertyAccessorFactory || factory instanceof NullPropertyAccessorFactory) continue;
            cache.add(factory);
        }
        FACTORY_CACHE = cache.toArray(new PropertyAccessorFactory[cache.size()]);
    }
}

