/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.tools.I18n;

public class TagEditorModel
extends org.openstreetmap.josm.gui.tagging.TagEditorModel {
    private DefaultComboBoxModel appliedPresets = new DefaultComboBoxModel();

    public TagEditorModel(DefaultListSelectionModel rowSelectionModel, DefaultListSelectionModel colSelectionModel) {
        super(rowSelectionModel, colSelectionModel);
    }

    public void applyPreset(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("argument 'item' must not be null");
        }
        for (int i = 0; i < this.appliedPresets.getSize(); ++i) {
            if (!this.appliedPresets.getElementAt(i).equals(item)) continue;
            return;
        }
        for (Tag tag : item.getTags()) {
            TagModel tagModel;
            if (tag.isOptional()) continue;
            if (!this.includesTag(tag.getKey())) {
                tagModel = new TagModel(tag.getKey(), tag.getValue());
                this.prepend(tagModel);
                continue;
            }
            tagModel = this.get(tag.getKey());
            if (tag.getValue() == null) continue;
            tagModel.setValue(tag.getValue());
        }
        this.appliedPresets.addElement(item);
        this.appliedPresets.setSelectedItem(item);
        this.fireTableDataChanged();
    }

    public void applyKeyValuePair(KeyValuePair pair) {
        TagModel tagModel = this.get(pair.getKey());
        if (tagModel == null) {
            tagModel = new TagModel(pair.getKey(), pair.getValue());
            this.prepend(tagModel);
        } else {
            tagModel.setValue(pair.getValue());
        }
        this.fireTableDataChanged();
    }

    public DefaultComboBoxModel getAppliedPresetsModel() {
        return this.appliedPresets;
    }

    public void removeAppliedPreset(Item item) {
        if (item == null) {
            return;
        }
        for (Tag tag : item.getTags()) {
            TagModel tagModel;
            if (tag.getValue() != null) {
                tagModel = this.get(tag.getKey());
                if (tagModel == null || !tag.getValue().equals(tagModel.getValue())) continue;
                this.tags.remove(tagModel);
                this.setDirty(true);
                continue;
            }
            tagModel = this.get(tag.getKey());
            if (tagModel == null) continue;
            this.tags.remove(tagModel);
            this.setDirty(true);
        }
        this.appliedPresets.removeElement(item);
        this.fireTableDataChanged();
    }

    public void clearAppliedPresets() {
        this.appliedPresets.removeAllElements();
        this.fireTableDataChanged();
    }

    public void highlightCurrentPreset() {
        this.fireTableDataChanged();
    }

    public void updateJOSMSelection() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        if (selection == null) {
            return;
        }
        for (TagModel tag : this.tags) {
            Command command = this.createUpdateTagCommand(selection, tag);
            if (command == null) continue;
            commands.add(command);
        }
        Command deleteCommand = this.createDeleteTagsCommand(selection);
        if (deleteCommand != null) {
            commands.add(deleteCommand);
        }
        SequenceCommand command = new SequenceCommand(I18n.trn((String)"Updating properties of up to {0} object", (String)"Updating properties of up to {0} objects", (long)selection.size(), (Object[])new Object[]{selection.size()}), commands);
        Main.main.undoRedo.add((Command)command);
    }

    public void initFromJOSMSelection() {
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        this.clear();
        for (OsmPrimitive element : selection) {
            for (String key : element.keySet()) {
                String value = element.get(key);
                this.add(key, value);
            }
        }
        this.sort();
        this.setDirty(false);
    }
}

