/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.plugins.tageditor.editor.PresetItemListCellRenderer;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.tools.I18n;

public class PresetManager
extends JPanel {
    private JComboBox presets;
    private JButton btnRemove;
    private JButton btnHighlight;
    private TagEditorModel model = null;

    protected void build() {
        this.setLayout(new FlowLayout(0));
        this.presets = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 200;
                return d;
            }
        };
        this.presets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PresetManager.this.syncWidgetStates();
            }
        });
        this.presets.setRenderer(new PresetItemListCellRenderer());
        this.add(this.presets);
        this.btnHighlight = new JButton(I18n.tr((String)"Highlight", (Object[])new Object[0]));
        this.btnHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PresetManager.this.highlightCurrentPreset();
            }
        });
        this.add(this.btnHighlight);
        this.btnRemove = new JButton(I18n.tr((String)"Remove", (Object[])new Object[0]));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PresetManager.this.removeCurrentPreset();
            }
        });
        this.add(this.btnRemove);
        this.syncWidgetStates();
    }

    protected void syncWidgetStates() {
        this.btnRemove.setEnabled(this.presets.getSelectedItem() != null);
        this.btnHighlight.setEnabled(this.presets.getSelectedItem() != null);
    }

    protected void removeCurrentPreset() {
        Item item = (Item)this.presets.getSelectedItem();
        if (item != null && this.model != null) {
            this.model.removeAppliedPreset(item);
        }
    }

    protected void highlightCurrentPreset() {
        this.model.highlightCurrentPreset();
    }

    public PresetManager() {
        this.build();
    }

    public void setModel(TagEditorModel model) {
        this.presets.setModel(model.getAppliedPresetsModel());
        this.model = model;
    }
}

