/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeASCII;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;

public class SanselanFixes
implements TiffConstants {
    public static void setGPSInDegrees(TiffOutputSet outputSet, double longitude, double latitude) throws ImageWriteException {
        TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGPSDirectory();
        String longitudeRef = longitude < 0.0 ? "W" : "E";
        longitude = Math.abs(longitude);
        String latitudeRef = latitude < 0.0 ? "S" : "N";
        latitude = Math.abs(latitude);
        TiffOutputField longitudeRefField = SanselanFixes.create(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF, outputSet.byteOrder, longitudeRef);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF);
        gpsDirectory.add(longitudeRefField);
        TiffOutputField latitudeRefField = SanselanFixes.create(TiffConstants.GPS_TAG_GPS_LATITUDE_REF, outputSet.byteOrder, latitudeRef);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LATITUDE_REF);
        gpsDirectory.add(latitudeRefField);
        double value = longitude;
        double longitudeDegrees = (long)value;
        value %= 1.0;
        double longitudeMinutes = (long)(value *= 60.0);
        value %= 1.0;
        double longitudeSeconds = value *= 60.0;
        Number[] values = new Double[]{new Double(longitudeDegrees), new Double(longitudeMinutes), new Double(longitudeSeconds)};
        TiffOutputField longitudeField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LONGITUDE, outputSet.byteOrder, values);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LONGITUDE);
        gpsDirectory.add(longitudeField);
        value = latitude;
        double latitudeDegrees = (long)value;
        value %= 1.0;
        double latitudeMinutes = (long)(value *= 60.0);
        value %= 1.0;
        double latitudeSeconds = value *= 60.0;
        values = new Double[]{new Double(latitudeDegrees), new Double(latitudeMinutes), new Double(latitudeSeconds)};
        TiffOutputField latitudeField = TiffOutputField.create(TiffConstants.GPS_TAG_GPS_LATITUDE, outputSet.byteOrder, values);
        gpsDirectory.removeField(TiffConstants.GPS_TAG_GPS_LATITUDE);
        gpsDirectory.add(latitudeField);
    }

    public static TiffOutputField create(TagInfo tagInfo, int byteOrder, String value) throws ImageWriteException {
        FieldTypeASCII fieldType;
        if (tagInfo.dataTypes == null) {
            fieldType = FIELD_TYPE_ASCII;
        } else if (tagInfo.dataTypes == FIELD_TYPE_DESCRIPTION_ASCII) {
            fieldType = FIELD_TYPE_ASCII;
        } else {
            throw new ImageWriteException("Tag has unexpected data type.");
        }
        String newValue = value + '\u0000';
        byte[] bytes = ((FieldType)fieldType).writeData(newValue, byteOrder);
        return new TiffOutputField(tagInfo.tag, tagInfo, fieldType, newValue.length(), bytes);
    }
}

