/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.LittleEndianOutput;

public class CellRangeAddressList {
    protected final List<CellRangeAddress> _list = new ArrayList<CellRangeAddress>();

    public CellRangeAddressList() {
    }

    public CellRangeAddressList(RecordInputStream recordInputStream) {
        this();
        int n = recordInputStream.readUShort();
        for (int i = 0; i < n; ++i) {
            this._list.add(new CellRangeAddress(recordInputStream));
        }
    }

    public int countRanges() {
        return this._list.size();
    }

    public CellRangeAddress getCellRangeAddress(int n) {
        return this._list.get(n);
    }

    public int getSize() {
        return CellRangeAddressList.getEncodedSize(this._list.size());
    }

    public static int getEncodedSize(int n) {
        return 2 + CellRangeAddress.getEncodedSize(n);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._list.size();
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            CellRangeAddress cellRangeAddress = this._list.get(i);
            cellRangeAddress.serialize(littleEndianOutput);
        }
    }
}

