/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.DataInputBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.util.IOUtils;

public final class DocumentBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private byte[] _data;
    private int _bytes_read;

    public DocumentBlock(RawDataBlock rawDataBlock) throws IOException {
        super(rawDataBlock.getBigBlockSize() == 512 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS);
        this._data = rawDataBlock.getData();
        this._bytes_read = this._data.length;
    }

    public DocumentBlock(InputStream inputStream, POIFSBigBlockSize pOIFSBigBlockSize) throws IOException {
        this(pOIFSBigBlockSize);
        int n = IOUtils.readFully(inputStream, this._data);
        this._bytes_read = n == -1 ? 0 : n;
    }

    private DocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        super(pOIFSBigBlockSize);
        this._data = new byte[pOIFSBigBlockSize.getBigBlockSize()];
        Arrays.fill(this._data, (byte)-1);
    }

    public int size() {
        return this._bytes_read;
    }

    public boolean partiallyRead() {
        return this._bytes_read != this.bigBlockSize.getBigBlockSize();
    }

    public static DataInputBlock getDataInputBlock(DocumentBlock[] documentBlockArray, int n) {
        if (documentBlockArray == null || documentBlockArray.length == 0) {
            return null;
        }
        POIFSBigBlockSize pOIFSBigBlockSize = documentBlockArray[0].bigBlockSize;
        short s = pOIFSBigBlockSize.getHeaderValue();
        int n2 = pOIFSBigBlockSize.getBigBlockSize();
        int n3 = n2 - 1;
        int n4 = n >> s;
        int n5 = n & n3;
        return new DataInputBlock(documentBlockArray[n4]._data, n5);
    }

    @Override
    void writeData(OutputStream outputStream) throws IOException {
        this.doWriteData(outputStream, this._data);
    }
}

