/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.walkingpapers;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import org.openstreetmap.josm.plugins.walkingpapers.WalkingPapersLayer;

public class WalkingPapersTile {
    private Image tileImage;
    long timestamp;
    int x;
    int y;
    int z;
    WalkingPapersLayer parentLayer;

    public WalkingPapersTile(int x, int y, int z, WalkingPapersLayer parent) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.parentLayer = parent;
        this.timestamp = System.currentTimeMillis();
    }

    public URL getImageUrl() {
        return this.parentLayer.formatImageUrl(this.x, this.y, this.z);
    }

    public void loadImage() {
        URL imageUrl = this.getImageUrl();
        this.tileImage = Toolkit.getDefaultToolkit().createImage(imageUrl);
        Toolkit.getDefaultToolkit().sync();
        this.timestamp = System.currentTimeMillis();
    }

    public Image getImage() {
        this.timestamp = System.currentTimeMillis();
        return this.tileImage;
    }

    public void dropImage() {
        this.tileImage = null;
    }

    public long access_time() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WalkingPapersTile)) {
            return false;
        }
        WalkingPapersTile other = (WalkingPapersTile)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }
}

