/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import wmsturbochallenge.FakeMapView;
import wmsturbochallenge.WMSRacer;
import wmsturbochallenge.engine;

public class GameWindow
extends JFrame
implements ActionListener {
    protected engine car_engine;
    protected gps car_gps;
    protected double lat;
    protected double lon;
    protected double ele = 3.0E-6;
    protected double horizon = 0.63;
    protected double cardist = this.ele * 3.0;
    protected int scale = 5;
    protected BufferedImage screen_image;
    protected Graphics screen;
    protected int width = 320;
    protected int height = 200;
    protected int centre = this.width / 2;
    double maxdist = this.ele / (this.horizon - 0.6);
    double realwidth = this.maxdist * (double)this.width / (double)this.height;
    double pixelperlat = 1.0 * (double)this.width / this.realwidth;
    double sratio = 0.85;
    protected int sw = (int)(Math.PI * 2 * this.maxdist * this.pixelperlat * this.sratio);
    protected static final ImageIcon[] car = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car0-l.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car0.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car0-r.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car1-l.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car1.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car1-r.png")))};
    protected static final ImageIcon[] bg = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/bg0.png")))};
    protected static final ImageIcon[] skyline = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/horizon.png")))};
    protected static final ImageIcon[] cactus = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cactus0.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cactus1.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cactus2.png")))};
    protected static final ImageIcon[] cloud = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cloud0.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cloud1.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cloud2.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cloud3.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/cloud4.png")))};
    protected static final ImageIcon[] aircraft = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/aircraft0.png")))};
    protected static final ImageIcon loading = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/loading.png")));
    protected static Toolkit s = Toolkit.getDefaultToolkit();
    protected int current_bg = 0;
    protected int current_car = 0;
    protected boolean cacti_on = true;
    protected List<EastNorth> cacti = new ArrayList<EastNorth>();
    protected List<EastNorth> todelete = new ArrayList<EastNorth>();
    protected int splashframe = -1;
    protected EastNorth splashcactus;
    protected Layer ground;
    protected double heading = 0.0;
    protected double wheelangle = 0.0;
    protected double speed = 0.0;
    protected boolean[] key_down = new boolean[]{false, false, false, false};
    int frame;
    boolean downloading = false;
    protected BufferedImage sky_image;
    protected Graphics sky;
    protected static final int sizes = 8;
    protected static final int maxsprites = 32;
    protected sprite_pos[] sprites = new sprite_pos[32];
    public boolean no_super_repaint = false;
    JPanel panel = new GamePanel();
    protected Timer timer;
    protected FakeMapView ground_view;

    public GameWindow(Layer ground) {
        this.setTitle(I18n.tr((String)"The Ultimate WMS Super-speed Turbo Challenge II", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setSize(GameWindow.s.getScreenSize().width, GameWindow.s.getScreenSize().height);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        while (GameWindow.s.getScreenSize().width < this.width * this.scale || GameWindow.s.getScreenSize().height < this.height * this.scale) {
            --this.scale;
        }
        this.add(this.panel);
        this.setVisible(true);
        this.screen_image = new BufferedImage(this.width, this.height, 1);
        this.screen = this.screen_image.getGraphics();
        this.ground = ground;
        this.ground_view = new FakeMapView(Main.map.mapView, 1.0E-7);
        EastNorth start = this.ground_view.parent.getCenter();
        this.lat = start.north();
        this.lon = start.east();
        this.addKeyListener(new TAdapter());
        this.timer = new Timer(80, this);
        this.timer.start();
        this.car_gps = new gps();
        this.car_gps.start();
        this.car_engine = new engine();
        this.car_engine.start();
        for (int i = 0; i < 32; ++i) {
            this.sprites[i] = new sprite_pos();
        }
        this.generate_sky();
    }

    protected void move() {
        double alon;
        double alat;
        if (this.key_down[0]) {
            this.wheelangle -= 0.1 / (1.0 + Math.abs(this.speed));
        }
        if (this.key_down[1]) {
            this.wheelangle += 0.1 / (1.0 + Math.abs(this.speed));
        }
        if (this.wheelangle > 0.3) {
            this.wheelangle = 0.3;
        }
        if (this.wheelangle < -0.3) {
            this.wheelangle = -0.3;
        }
        this.wheelangle *= 0.7;
        if (this.key_down[2]) {
            this.speed += this.speed >= 0.0 ? 1.0 / (2.0 + this.speed) : 0.5;
        }
        if (this.key_down[3]) {
            this.speed = this.speed >= 0.5 ? (this.speed -= 0.5) : (this.speed >= 0.01 ? 0.0 : (this.speed -= 0.5 / (4.0 - this.speed)));
        }
        this.speed *= 0.97;
        this.car_engine.set_speed(this.speed);
        if (this.speed > -0.1 && this.speed < 0.1) {
            this.speed = 0.0;
        }
        this.heading += this.wheelangle * this.speed;
        boolean chop = false;
        double newlat = this.lat + Math.cos(this.heading) * this.speed * this.ele * 0.2;
        double newlon = this.lon + Math.sin(this.heading) * this.speed * this.ele * 0.2;
        for (EastNorth pos : this.cacti) {
            alat = Math.abs(pos.north() - newlat);
            if (!(alat + (alon = Math.abs(pos.east() - newlon)) < this.ele * 1.0)) continue;
            if (Math.abs(this.speed) < 2.0) {
                this.speed = this.speed > 0.0 ? -0.5 : 0.3;
                newlat = this.lat;
                newlon = this.lon;
                break;
            }
            chop = true;
            this.splashframe = 0;
            this.splashcactus = pos;
            this.todelete.add(pos);
        }
        this.lat = newlat;
        this.lon = newlon;
        if (this.cacti_on && Math.random() * 30.0 < this.speed) {
            double left_x = this.maxdist * (double)(this.width - this.centre) / (double)this.height;
            double right_x = this.maxdist * (double)(0 - this.centre) / (double)this.height;
            double x = left_x + Math.random() * (right_x - left_x);
            double clat = this.lat + (this.maxdist - this.cardist) * Math.cos(this.heading) - x * Math.sin(this.heading);
            double clon = this.lon + (this.maxdist - this.cardist) * Math.sin(this.heading) + x * Math.cos(this.heading);
            this.cacti.add(new EastNorth(clon, clat));
            chop = true;
        }
        if (chop) {
            for (EastNorth pos : this.cacti) {
                alat = Math.abs(pos.north() - this.lat);
                if (!(alat + (alon = Math.abs(pos.east() - this.lon)) > 2.0 * this.maxdist)) continue;
                this.todelete.add(pos);
            }
            this.cacti.removeAll(this.todelete);
            this.todelete = new ArrayList<EastNorth>();
        }
    }

    protected void screen_repaint() {
        this.sky_paint();
        this.ground_paint();
        ++this.frame;
        if ((this.frame & 8) == 0 && this.downloading) {
            this.screen.drawImage(loading.getImage(), this.centre - loading.getIconWidth() / 2, 50, this);
        }
        this.sprites_paint();
    }

    static double max3(double[] x) {
        return x[0] > x[1] ? (x[2] > x[0] ? x[2] : x[0]) : (x[2] > x[1] ? x[2] : x[1]);
    }

    static double min3(double[] x) {
        return x[0] < x[1] ? (x[2] < x[0] ? x[2] : x[0]) : (x[2] < x[1] ? x[2] : x[1]);
    }

    protected void ground_paint() {
        double sin = Math.sin(this.heading);
        double cos = Math.cos(this.heading);
        double left_x = this.maxdist * (double)(this.width - this.centre) / (double)this.height;
        double right_x = this.maxdist * (double)(0 - this.centre) / (double)this.height;
        double[] e_lat = new double[]{this.lat + (this.maxdist - this.cardist) * cos - left_x * sin, this.lat + (this.maxdist - this.cardist) * cos - right_x * sin, this.lat - this.cardist * cos};
        double[] e_lon = new double[]{this.lon + (this.maxdist - this.cardist) * sin + left_x * cos, this.lon + (this.maxdist - this.cardist) * sin + right_x * cos, this.lon - this.cardist * sin};
        this.ground_view.setProjectionBounds(new ProjectionBounds(new EastNorth(GameWindow.min3(e_lon), GameWindow.min3(e_lat)), new EastNorth(GameWindow.max3(e_lon), GameWindow.max3(e_lat))));
        if (this.ground instanceof WMSLayer) {
            WMSLayer wms = (WMSLayer)this.ground;
            this.downloading = wms.hasAutoDownload() && (null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])) || null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])) || null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])));
        }
        this.ground.paint(this.ground_view.graphics, (MapView)this.ground_view, null);
        for (int y = (int)((double)this.height * this.horizon + 0.1); y < this.height; ++y) {
            double dist = this.ele / (1.0 * (double)y / (double)this.height - 0.6);
            double lat_off = this.lat + (dist - this.cardist) * cos;
            double lon_off = this.lon + (dist - this.cardist) * sin;
            for (int x = 0; x < this.width; ++x) {
                double p_x = dist * (double)(x - this.centre) / (double)this.height;
                EastNorth en = new EastNorth(lon_off + p_x * cos, lat_off - p_x * sin);
                Point pt = this.ground_view.getPoint(en);
                int rgb = this.ground_view.ground_image.getRGB(pt.x, pt.y);
                this.screen_image.setRGB(x, y, rgb);
            }
        }
    }

    public void generate_sky() {
        this.sky_image = new BufferedImage(this.sw, 70, 2);
        this.sky = this.sky_image.getGraphics();
        int n = (int)(Math.random() * (double)this.sw * 0.03);
        for (int i = 0; i < n; ++i) {
            int t = (int)(Math.random() * 5.0);
            int x = (int)(Math.random() * (double)(this.sw - cloud[t].getIconWidth()));
            int y = (int)((1.0 - Math.random() * Math.random()) * (double)(70 - cloud[t].getIconHeight()));
            this.sky.drawImage(cloud[t].getImage(), x, y, this);
        }
        if (Math.random() < 0.5) {
            int t = 0;
            int x = (int)(300.0 + Math.random() * (double)(this.sw - 500 - aircraft[t].getIconWidth()));
            this.sky.drawImage(aircraft[t].getImage(), x, 0, this);
        }
    }

    public void sky_paint() {
        int hx = (int)(-this.heading * this.maxdist * this.pixelperlat);
        int hw = skyline[this.current_bg].getIconWidth();
        hx = (hx % hw - hw) % hw;
        int sx = (int)(-this.heading * this.maxdist * this.pixelperlat * this.sratio);
        sx = (sx % this.sw - this.sw) % this.sw;
        this.screen.drawImage(bg[this.current_bg].getImage(), 0, 0, this);
        this.screen.drawImage(this.sky_image, sx, 50, this);
        if (this.sw + sx < this.width) {
            this.screen.drawImage(this.sky_image, sx + this.sw, 50, this);
        }
        this.screen.drawImage(skyline[this.current_bg].getImage(), hx, 66, this);
        if (hw + hx < this.width) {
            this.screen.drawImage(skyline[this.current_bg].getImage(), hx + hw, 66, this);
        }
    }

    protected void sprites_paint() {
        int orientation = (this.wheelangle > -0.02 ? (this.wheelangle < 0.02 ? 1 : 2) : 0) + this.current_car * 3;
        this.sprites[0].sprite = car[orientation].getImage();
        this.sprites[0].dist = this.cardist;
        this.sprites[0].sx = car[orientation].getIconWidth();
        this.sprites[0].x = this.centre - this.sprites[0].sx / 2;
        this.sprites[0].sy = car[orientation].getIconHeight();
        this.sprites[0].y = this.height - this.sprites[0].sy - 10;
        double sin = Math.sin(-this.heading);
        double cos = Math.cos(-this.heading);
        int i = 1;
        for (EastNorth ll : this.cacti) {
            double clat = ll.north() - this.lat;
            double clon = ll.east() - this.lon;
            double dist = clat * cos - clon * sin + this.cardist;
            double p_x = clat * sin + clon * cos;
            if (dist * 8.0 <= this.cardist || dist > this.maxdist) continue;
            int x = (int)(p_x * (double)this.height / dist + (double)this.centre);
            int y = (int)((this.ele / dist + 0.6) * (double)this.height);
            if (i >= 32) break;
            if (x < -10 || x > this.width + 10) continue;
            int type = ((int)(ll.north() * 1.0E7) & 0x1F) % 3;
            int sx = cactus[type].getIconWidth();
            int sy = cactus[type].getIconHeight();
            sprite_pos pos = this.sprites[i++];
            pos.dist = dist;
            pos.sprite = cactus[type].getImage();
            pos.sx = (int)((double)sx * this.cardist * 0.7 / dist);
            pos.sy = (int)((double)sy * this.cardist * 0.7 / dist);
            pos.x = x - pos.sx / 2;
            pos.y = y - pos.sy;
        }
        Arrays.sort(this.sprites, 0, i);
        for (sprite_pos sprite : this.sprites) {
            if (i-- <= 0) break;
            this.screen.drawImage(sprite.sprite, sprite.x, sprite.y, sprite.sx, sprite.sy, this);
        }
        if (this.splashframe >= 0) {
            ++this.splashframe;
            if (this.splashframe >= 8) {
                this.splashframe = -1;
            }
            int type = ((int)(this.splashcactus.north() * 1.0E7) & 0x1F) % 3;
            int sx = cactus[type].getIconWidth();
            int sy = cactus[type].getIconHeight();
            Image image = cactus[type].getImage();
            for (i = 0; i < 50; ++i) {
                int x = (int)(Math.random() * (double)sx);
                int y = (int)(Math.random() * (double)sy);
                int w = (int)(Math.random() * 20.0);
                int h = (int)(Math.random() * 20.0);
                int nx = this.centre + this.splashframe * (x - sx / 2);
                int ny = this.height - this.splashframe * (sy - y);
                int nw = w + this.splashframe;
                int nh = h + this.splashframe;
                this.screen.drawImage(image, nx, ny, nx + nw, ny + nh, x, y, x + w, y + h, this);
            }
        }
    }

    protected void quit() {
        this.timer.stop();
        this.car_engine.stop();
        this.car_gps.stop();
        this.car_gps.save_trace();
        this.setVisible(false);
        this.panel = null;
        this.screen_image = null;
        this.screen = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.move();
        this.screen_repaint();
        this.no_super_repaint = true;
        this.panel.repaint();
    }

    protected class TAdapter
    extends KeyAdapter {
        protected TAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 37 && !GameWindow.this.key_down[0]) {
                GameWindow.this.wheelangle -= 0.02;
                GameWindow.this.key_down[0] = true;
            }
            if (key == 39 && !GameWindow.this.key_down[1]) {
                GameWindow.this.wheelangle += 0.02;
                GameWindow.this.key_down[1] = true;
            }
            if (key == 38) {
                GameWindow.this.key_down[2] = true;
            }
            if (key == 40) {
                GameWindow.this.key_down[3] = true;
            }
            if (key == 27) {
                GameWindow.this.quit();
            }
            if (key == 83) {
                if (GameWindow.this.car_engine.is_on()) {
                    GameWindow.this.car_engine.stop();
                } else {
                    GameWindow.this.car_engine.start();
                }
            }
            if (key == 67) {
                boolean bl = GameWindow.this.cacti_on = !GameWindow.this.cacti_on;
                if (!GameWindow.this.cacti_on) {
                    GameWindow.this.cacti = new ArrayList<EastNorth>();
                }
            }
            if (key == 86 && GameWindow.this.current_car++ >= 1) {
                GameWindow.this.current_car = 0;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 37) {
                GameWindow.this.key_down[0] = false;
            }
            if (key == 39) {
                GameWindow.this.key_down[1] = false;
            }
            if (key == 38) {
                GameWindow.this.key_down[2] = false;
            }
            if (key == 40) {
                GameWindow.this.key_down[3] = false;
            }
        }
    }

    protected class GamePanel
    extends JPanel {
        public GamePanel() {
            this.setBackground(Color.BLACK);
            this.setDoubleBuffered(true);
        }

        @Override
        public void paint(Graphics g) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight();
            if (GameWindow.this.no_super_repaint) {
                GameWindow.this.no_super_repaint = false;
            } else {
                super.paint(g);
            }
            g.drawImage(GameWindow.this.screen_image, (w - GameWindow.this.width * GameWindow.this.scale) / 2, (h - GameWindow.this.height * GameWindow.this.scale) / 2, GameWindow.this.width * GameWindow.this.scale, GameWindow.this.height * GameWindow.this.scale, this);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    protected class sprite_pos
    implements Comparable<sprite_pos> {
        double dist;
        int x;
        int y;
        int sx;
        int sy;
        Image sprite;

        @Override
        public int compareTo(sprite_pos x) {
            return (int)((x.dist - this.dist) * 1000000.0);
        }
    }

    protected class gps
    extends Timer
    implements ActionListener {
        protected Collection<WayPoint> segment;
        protected Collection<Collection<WayPoint>> trackSegs;

        public gps() {
            super(1000, null);
            this.addActionListener(this);
            this.trackSegs = new ArrayList<Collection<WayPoint>>();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.segment.add(new WayPoint(Main.getProjection().eastNorth2latlon(new EastNorth(GameWindow.this.lon, GameWindow.this.lat))));
        }

        @Override
        public void start() {
            super.start();
            this.segment = new ArrayList<WayPoint>();
            this.trackSegs.add(this.segment);
            this.actionPerformed(null);
        }

        public void save_trace() {
            int len = 0;
            for (Collection<WayPoint> seg : this.trackSegs) {
                len += seg.size();
            }
            if (len <= 5) {
                return;
            }
            GpxData data = new GpxData();
            data.tracks.add(new ImmutableGpxTrack(this.trackSegs, new HashMap()));
            GameWindow.this.ground_view.parent.addLayer((Layer)new GpxLayer(data, "Car GPS trace"));
        }
    }
}

