/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class PrintableMapView
extends MapView
implements Printable {
    protected int fixedMapScale = 0;
    protected double g2dFactor;
    protected MapView mapView;
    public static final int FONT_SIZE = 8;

    public PrintableMapView() {
        super(new JPanel(), null);
        ComponentListener[] listeners = this.getComponentListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeComponentListener(listeners[i]);
        }
        this.mapView = Main.map.mapView;
    }

    public void setFixedMapScale(int scale) {
        this.fixedMapScale = scale;
        this.rezoomToFixedScale();
    }

    public void unsetFixedMapScale() {
        this.setFixedMapScale(0);
        this.rezoomToFixedScale();
    }

    public int getMapScale() {
        if (this.fixedMapScale > 0 || this.g2dFactor == 0.0) {
            return this.fixedMapScale;
        }
        double dist100px = this.getDist100Pixel() / this.g2dFactor;
        int mapScale = (int)(dist100px * 72.0 / 2.54);
        return mapScale;
    }

    public void initialize(PageFormat pageFormat) {
        int resolution = Main.pref.getInteger("print.resolution.dpi", 100);
        this.g2dFactor = 72.0 / (double)resolution;
        this.setSize((int)(pageFormat.getImageableWidth() / this.g2dFactor), (int)(pageFormat.getImageableHeight() / this.g2dFactor));
    }

    public void setSize(int width, int height) {
        Dimension dim = this.getSize();
        if (dim.width != width || dim.height != height) {
            super.setSize(width, height);
            this.zoomTo(this.mapView.getRealBounds());
            this.rezoomToFixedScale();
        }
    }

    public void setSize(Dimension newSize) {
        Dimension dim = this.getSize();
        if (dim.width != newSize.width || dim.height != newSize.height) {
            super.setSize(newSize);
            this.zoomTo(this.mapView.getRealBounds());
            this.rezoomToFixedScale();
        }
    }

    protected void rezoomToFixedScale() {
        if (this.fixedMapScale > 0) {
            double dist100px = this.getDist100Pixel() / this.g2dFactor;
            double mapScale = dist100px * 72.0 / 2.54;
            double mapFactor = (double)this.fixedMapScale / mapScale;
            this.zoomToFactor(mapFactor);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        this.initialize(pageFormat);
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.paintMap(g2d, pageFormat);
        this.paintMapScale(g2d, pageFormat);
        this.paintMapAttribution(g2d, pageFormat);
        return 0;
    }

    public void paintMap(Graphics2D g2d, PageFormat pageFormat) {
        AffineTransform at = g2d.getTransform();
        g2d.scale(this.g2dFactor, this.g2dFactor);
        Bounds box = this.getRealBounds();
        List<Layer> visibleLayers = this.getVisibleLayersInZOrder();
        for (Layer l : visibleLayers) {
            if (l.getOpacity() < 1.0) {
                g2d.setComposite(AlphaComposite.getInstance(3, (float)l.getOpacity()));
            }
            l.paint(g2d, (MapView)this, box);
            g2d.setPaintMode();
        }
        g2d.setTransform(at);
    }

    public void paintMapScale(Graphics2D g2d, PageFormat pageFormat) {
        NavigatableComponent.SystemOfMeasurement som = PrintableMapView.getSystemOfMeasurement();
        double dist100px = this.getDist100Pixel() / this.g2dFactor;
        double dist = dist100px / som.aValue;
        if (!Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false) && dist > som.bValue / som.aValue) {
            dist = dist100px / som.bValue;
        }
        long distExponent = (long)Math.floor(Math.log(dist) / Math.log(10.0));
        double distMantissa = dist / Math.pow(10.0, distExponent);
        double distScale = 1.0;
        distScale = distMantissa <= 2.5 ? 2.5 / distMantissa : (distMantissa <= 4.0 ? 5.0 / distMantissa : 10.0 / distMantissa);
        Font labelFont = new Font("Arial", 0, 8);
        g2d.setFont(labelFont);
        int x = (int)(100.0 * distScale);
        Rectangle2D bound = g2d.getFontMetrics().getStringBounds("0", g2d);
        int xLeft = (int)(bound.getWidth() / 2.0);
        String rightLabel = som.getDistText(dist100px * distScale);
        bound = g2d.getFontMetrics().getStringBounds(rightLabel, g2d);
        int xRight = xLeft + (int)Math.max(0.95 * (double)x, (double)x - bound.getWidth() / 2.0);
        int h = 4;
        int yLexical = 3 * h;
        int yBar = 4 * h;
        int yLabel = 8 * h;
        int w = (int)(distScale * 100.0);
        int ws = (int)(distScale * 20.0);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(xLeft - 1, yBar - 1, w + 2, h + 2);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(xLeft, yBar, w, h);
        g2d.fillRect(xLeft, yBar, ws, h);
        g2d.fillRect(xLeft + (int)(distScale * 40.0), yBar, ws, h);
        g2d.fillRect(xLeft + w - ws, yBar, ws, h);
        g2d.setFont(labelFont);
        this.paintText(g2d, "0", 0, yLabel);
        this.paintText(g2d, rightLabel, xRight, yLabel);
        int mapScale = this.getMapScale();
        String lexicalScale = I18n.tr((String)"Scale", (Object[])new Object[0]) + " 1 : " + mapScale;
        Font scaleFront = new Font("Arial", 1, 8);
        g2d.setFont(scaleFront);
        bound = g2d.getFontMetrics().getStringBounds(lexicalScale, g2d);
        int xLexical = Math.max(0, xLeft + (w - (int)bound.getWidth()) / 2);
        this.paintText(g2d, lexicalScale, xLexical, yLexical);
    }

    public void paintMapAttribution(Graphics2D g2d, PageFormat pageFormat) {
        String text = Main.pref.get("print.attribution", "\u00a9 OpenStreetMap contributors");
        if (text == null) {
            return;
        }
        Font attributionFont = new Font("Arial", 0, 6);
        g2d.setFont(attributionFont);
        text = text + "\n";
        int y = 12;
        int from = 0;
        int to = text.indexOf("\n", from);
        while (to >= from) {
            String line = text.substring(from, to);
            Rectangle2D bound = g2d.getFontMetrics().getStringBounds(line, g2d);
            int x = (int)(pageFormat.getImageableWidth() - bound.getWidth() - 4.0);
            this.paintText(g2d, line, x, y);
            y += 10;
            from = to + 1;
            to = text.indexOf("\n", from);
        }
    }

    public void paintText(Graphics2D g2d, String text, int x, int y) {
        AffineTransform ax = g2d.getTransform();
        g2d.translate(x, y);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector gv = g2d.getFont().createGlyphVector(frc, text);
        Shape textOutline = gv.getOutline();
        g2d.setStroke(new BasicStroke(1.0f, 0, 1));
        g2d.setColor(Color.WHITE);
        g2d.draw(textOutline);
        g2d.setStroke(new BasicStroke());
        g2d.setColor(Color.BLACK);
        g2d.drawString(text, 0, 0);
        g2d.setTransform(ax);
    }

    public Layer getActiveLayer() {
        return this.mapView.getActiveLayer();
    }

    public int getLayerPos(Layer layer) {
        return this.mapView.getLayerPos(layer);
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer l : this.mapView.getAllLayersAsList()) {
            if (!l.isVisible()) continue;
            layers.add(l);
        }
        Collections.sort(layers, new Comparator<Layer>(){

            @Override
            public int compare(Layer l2, Layer l1) {
                if (l1 instanceof OsmDataLayer && l2 instanceof OsmDataLayer) {
                    if (l1 == PrintableMapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (l2 == PrintableMapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(PrintableMapView.this.getLayerPos(l1)).compareTo(PrintableMapView.this.getLayerPos(l2));
                }
                return Integer.valueOf(PrintableMapView.this.getLayerPos(l1)).compareTo(PrintableMapView.this.getLayerPos(l2));
            }
        });
        return layers;
    }
}

