/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.piclayer.actions.SavePictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromClipboardAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromFileAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.MovePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.RotatePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ShearPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.MovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.RemovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.TransformPointAction;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerPlugin
extends Plugin
implements MapView.LayerChangeListener {
    public static List<IconToggleButton> buttonList = null;
    JosmAction newLayerFromFileAction = new NewLayerFromFileAction();
    JosmAction newLayerFromClipboardAction = new NewLayerFromClipboardAction();

    public PicLayerPlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)Main.main.menu.imagerySubMenu, (JosmAction)this.newLayerFromFileAction);
        MainMenu.add((JMenu)Main.main.menu.imagerySubMenu, (JosmAction)this.newLayerFromClipboardAction);
        this.newLayerFromFileAction.setEnabled(false);
        this.newLayerFromClipboardAction.setEnabled(false);
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            MovePictureAction movePictureAction = new MovePictureAction(newFrame);
            MovePointAction movePointAction = new MovePointAction(newFrame);
            TransformPointAction transformPointAction = new TransformPointAction(newFrame);
            RemovePointAction removePointAction = new RemovePointAction(newFrame);
            RotatePictureAction rotatePictureAction = new RotatePictureAction(newFrame);
            ScaleXYPictureAction scaleXYPictureAction = new ScaleXYPictureAction(newFrame);
            ScaleXPictureAction scaleXPictureAction = new ScaleXPictureAction(newFrame);
            ScaleYPictureAction scaleYPictureAction = new ScaleYPictureAction(newFrame);
            ShearPictureAction shearPictureAction = new ShearPictureAction(newFrame);
            buttonList = new ArrayList<IconToggleButton>(7);
            buttonList.add(this.picLayerActionButtonFactory(movePictureAction));
            buttonList.add(this.picLayerActionButtonFactory(movePointAction));
            buttonList.add(this.picLayerActionButtonFactory(transformPointAction));
            buttonList.add(this.picLayerActionButtonFactory(removePointAction));
            buttonList.add(this.picLayerActionButtonFactory(rotatePictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleXYPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleXPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleYPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(shearPictureAction));
            for (IconToggleButton btn : buttonList) {
                newFrame.addMapMode(btn);
            }
        }
    }

    private IconToggleButton picLayerActionButtonFactory(MapMode action) {
        IconToggleButton button = new IconToggleButton((Action)action);
        button.setAutoHideDisabledButton(true);
        return button;
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        boolean oldPic = oldLayer instanceof PicLayerAbstract;
        boolean newPic = newLayer instanceof PicLayerAbstract;
        if (oldPic) {
            ((PicLayerAbstract)oldLayer).setDrawPoints(false);
        }
        if (newPic) {
            ((PicLayerAbstract)newLayer).setDrawPoints(true);
        }
    }

    public void layerAdded(Layer arg0) {
        this.newLayerFromFileAction.setEnabled(true);
        this.newLayerFromClipboardAction.setEnabled(true);
    }

    public void layerRemoved(Layer arg0) {
        if (arg0 instanceof PicLayerAbstract && ((PicLayerAbstract)arg0).getTransformer().isModified() && JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"Do you want to save current calibration of layer {0}?", (Object[])new Object[]{((PicLayerAbstract)arg0).getPicLayerName()}), UIManager.getString("OptionPane.titleText"), 0) == 0) {
            new SavePictureCalibrationAction((PicLayerAbstract)arg0).actionPerformed(null);
        }
        boolean enable = Main.map != null && Main.map.mapView != null && Main.map.mapView.getAllLayers() != null && Main.map.mapView.getAllLayers().size() != 0;
        this.newLayerFromFileAction.setEnabled(enable);
        this.newLayerFromClipboardAction.setEnabled(enable);
    }
}

