/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.util.LinkedList;
import javax.swing.AbstractListModel;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;

public class ActionQueue
extends AbstractListModel {
    private LinkedList<OsbAction> queue = new LinkedList();

    public boolean offer(OsbAction e) {
        boolean result = this.queue.offer(e);
        this.fireIntervalAdded(this, this.queue.size() - 1, this.queue.size() - 1);
        return result;
    }

    public OsbAction peek() {
        return this.queue.peek();
    }

    public OsbAction poll() {
        OsbAction action = this.queue.poll();
        this.fireIntervalRemoved(this, 0, 0);
        return action;
    }

    public boolean remove(Object o) {
        int index = this.queue.indexOf(o);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return this.queue.remove(o);
    }

    public void processQueue() throws Exception {
        while (!this.queue.isEmpty()) {
            OsbAction action = this.queue.peek();
            action.execute();
            for (OsbActionObserver obs : action.getActionObservers()) {
                obs.actionPerformed(action);
            }
            this.queue.remove();
            this.fireIntervalRemoved(this, 0, 0);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.queue.get(index);
    }

    @Override
    public int getSize() {
        return this.queue.size();
    }
}

