/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.Stroke;
import org.geotools.styling.Symbol;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;

public class RescaleStyleVisitor
extends DuplicatingStyleVisitor {
    private Expression scale;

    public RescaleStyleVisitor(double scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(Expression scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, double scale) {
        this(filterFactory, filterFactory.literal(scale));
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, Expression scale) {
        super(CommonFactoryFinder.getStyleFactory(null), filterFactory);
        this.scale = scale;
    }

    protected Expression rescale(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr == Expression.NIL) {
            return Expression.NIL;
        }
        Multiply rescale = this.ff.multiply(this.scale, expr);
        if (expr instanceof Literal && this.scale instanceof Literal) {
            double constant = rescale.evaluate(null, Double.class);
            return this.ff.literal(constant);
        }
        return rescale;
    }

    @Override
    public void visit(Stroke stroke) {
        Stroke copy = this.sf.getDefaultStroke();
        copy.setColor(this.copy(stroke.getColor()));
        copy.setDashArray(this.rescale(stroke.getDashArray()));
        copy.setDashOffset(this.rescale(stroke.getDashOffset()));
        copy.setGraphicFill(this.copy(stroke.getGraphicFill()));
        copy.setGraphicStroke(this.copy(stroke.getGraphicStroke()));
        copy.setLineCap(this.copy(stroke.getLineCap()));
        copy.setLineJoin(this.copy(stroke.getLineJoin()));
        copy.setOpacity(this.copy(stroke.getOpacity()));
        copy.setWidth(this.rescale(stroke.getWidth()));
        this.pages.push(copy);
    }

    float[] rescale(float[] original) {
        if (original == null) {
            return null;
        }
        float[] rescaled = new float[original.length];
        float scaleFactor = 1.0f;
        if (this.scale instanceof Literal) {
            scaleFactor = this.scale.evaluate(null, Float.class).floatValue();
        }
        for (int i = 0; i < rescaled.length; ++i) {
            rescaled[i] = scaleFactor * original[i];
        }
        return rescaled;
    }

    @Override
    public void visit(Graphic gr) {
        Graphic copy = null;
        Displacement displacementCopy = null;
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept(this);
            displacementCopy = (Displacement)this.pages.pop();
        }
        ExternalGraphic[] externalGraphics = gr.getExternalGraphics();
        ExternalGraphic[] externalGraphicsCopy = new ExternalGraphic[externalGraphics.length];
        int length = externalGraphics.length;
        for (int i = 0; i < length; ++i) {
            externalGraphicsCopy[i] = this.copy(externalGraphics[i]);
        }
        Mark[] marks = gr.getMarks();
        Mark[] marksCopy = new Mark[marks.length];
        length = marks.length;
        for (int i = 0; i < length; ++i) {
            marksCopy[i] = this.copy(marks[i]);
        }
        Expression opacityCopy = this.copy(gr.getOpacity());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.rescaleGraphicSize(gr);
        Symbol[] symbols = gr.getSymbols();
        length = symbols.length;
        Symbol[] symbolCopys = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            symbolCopys[i] = this.copy(symbols[i]);
        }
        copy = this.sf.createDefaultGraphic();
        copy.setDisplacement(displacementCopy);
        copy.setExternalGraphics(externalGraphicsCopy);
        copy.setMarks(marksCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setSymbols(symbolCopys);
        this.pages.push(copy);
    }

    protected Expression rescaleGraphicSize(Graphic gr) {
        return this.rescale(gr.getSize());
    }

    @Override
    public void visit(TextSymbolizer text) {
        Font[] fonts;
        super.visit(text);
        TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
        for (Font font : fonts = copy.getFonts()) {
            font.setSize(this.rescale(font.getSize()));
        }
        copy.setFonts(fonts);
        LabelPlacement placement = copy.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            Displacement disp = pointPlacement.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX()));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY()));
                pointPlacement.setDisplacement(disp);
            }
        } else if (placement instanceof LinePlacement) {
            LinePlacement linePlacement = (LinePlacement)placement;
            linePlacement.setGap(this.rescale(linePlacement.getGap()));
            linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap()));
            linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset()));
        }
        copy.setLabelPlacement(placement);
        if (copy.getHalo() != null) {
            copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius()));
        }
        Map<String, String> options = copy.getOptions();
        this.rescaleOption(options, "spaceAround", 0);
        this.rescaleOption(options, "maxDisplacement", 0);
        this.rescaleOption(options, "minGroupDistance", -1);
        this.rescaleOption(options, "repeat", 0);
        this.rescaleOption(options, "autoWrap", 0);
        this.rescaleArrayOption(options, "graphic-margin", 0);
    }

    protected void rescaleOption(Map<String, String> options, String key, double defaultValue) {
        double scaleFactor = this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            double rescaled = Converters.convert(options.get(key), Double.class) * scaleFactor;
            options.put(key, String.valueOf(rescaled));
        } else if (defaultValue != 0.0) {
            options.put(key, String.valueOf(defaultValue * scaleFactor));
        }
    }

    protected void rescaleOption(Map<String, String> options, String key, int defaultValue) {
        double scaleFactor = this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            int rescaled = (int)Math.round(Converters.convert(options.get(key), Double.class) * scaleFactor);
            options.put(key, String.valueOf(rescaled));
        } else if (defaultValue != 0) {
            options.put(key, String.valueOf((int)Math.round((double)defaultValue * scaleFactor)));
        }
    }

    protected void rescaleArrayOption(Map<String, String> options, String key, int defaultValue) {
        double scaleFactor = this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            String strValue = options.get(key);
            String[] splitted = strValue.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String value : splitted) {
                double rescaled = (int)Math.round(Double.parseDouble(value) * scaleFactor);
                sb.append((int)rescaled).append(" ");
            }
            sb.setLength(sb.length() - 1);
            options.put(key, sb.toString());
        } else if (defaultValue != 0) {
            options.put(key, String.valueOf((int)Math.round((double)defaultValue * scaleFactor)));
        }
    }
}

