/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;

public class Collection_UniqueFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object unique = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Unique", FunctionNameImpl.parameter("unique", Object.class), FunctionNameImpl.parameter("expression", Object.class));

    public Collection_UniqueFunction() {
        super(NAME);
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateUnique(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(expression);
        collection.accepts(uniqueVisitor, null);
        return uniqueVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        org.opengis.filter.expression.Expression expr = (org.opengis.filter.expression.Expression)args.get(0);
        expr = (org.opengis.filter.expression.Expression)expr.accept(new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        if (feature == null) {
            return new Integer(0);
        }
        SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)feature;
        Expression expr = (Expression)this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.unique = null;
                try {
                    CalcResult result = Collection_UniqueFunction.calculateUnique(featureCollection, expr);
                    if (result != null) {
                        this.unique = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.unique;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

