/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data.coverage.grid");
    protected int numOverviews = 0;
    protected MathTransform raster2Model = null;
    protected CoordinateReferenceSystem crs = null;
    protected GeneralEnvelope originalEnvelope = null;
    protected String coverageName = "geotools_coverage";
    protected Object source = null;
    protected Hints hints = GeoTools.getDefaultHints();
    protected double[] highestRes = null;
    protected boolean closeMe;
    protected boolean gzipped;
    protected GridEnvelope originalGridRange = null;
    protected ImageInputStream inStream = null;
    protected double[][] overViewResolutions = null;
    protected GridCoverageFactory coverageFactory;
    private ArrayList<Resolution> resolutionsLevels;
    protected ImageInputStreamSpi inStreamSPI;
    private ImageLayout imageLayout;

    @Override
    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getOriginalEnvelope();
    }

    @Override
    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getOriginalGridRange();
    }

    @Override
    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getOriginalGridToWorld(pixInCell);
    }

    private final boolean checkName(String coverageName) {
        Utilities.ensureNonNull("coverageName", coverageName);
        return coverageName.equalsIgnoreCase(this.coverageName);
    }

    @Override
    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (coverageName.equalsIgnoreCase(this.coverageName)) {
            return this.read(parameters);
        }
        throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getCoordinateReferenceSystem();
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getDynamicParameters();
    }

    @Override
    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getReadingResolutions(policy, requestedResolution);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCrs();
    }

    protected AbstractGridCoverage2DReader() {
    }

    public AbstractGridCoverage2DReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public AbstractGridCoverage2DReader(Object input, Hints hints) throws DataSourceException {
        Object factory;
        if (hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints = hints.clone();
        }
        if (this.hints.containsKey(Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get(Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
        }
        if (input == null) {
            IOException ex = new IOException(Errors.format(143, "input"));
            throw new DataSourceException(ex);
        }
        this.source = input;
    }

    @Override
    public abstract GridCoverage2D read(GeneralParameterValue[] var1) throws IllegalArgumentException, IOException;

    protected Integer setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        Integer imageChoice = new Integer(0);
        if (overviewPolicy == null) {
            overviewPolicy = this.extractOverviewPolicy();
        }
        readP.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        boolean useOverviews = this.numOverviews > 0;
        double[] requestedRes = AbstractGridCoverage2DReader.getResolution(requestedEnvelope, requestedDim, this.crs);
        if (requestedRes == null) {
            return imageChoice;
        }
        if (useOverviews) {
            imageChoice = this.pickOverviewLevel(overviewPolicy, requestedRes);
        }
        this.decimationOnReadingControl(imageChoice, readP, requestedRes);
        return imageChoice;
    }

    private OverviewPolicy extractOverviewPolicy() {
        OverviewPolicy overviewPolicy = null;
        if (this.hints != null && this.hints.containsKey(Hints.OVERVIEW_POLICY)) {
            overviewPolicy = (OverviewPolicy)((Object)this.hints.get(Hints.OVERVIEW_POLICY));
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (overviewPolicy != null);
        return overviewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer pickOverviewLevel(OverviewPolicy policy, double[] requestedRes) {
        double requestedScaleFactor;
        if (policy == null) {
            policy = this.extractOverviewPolicy();
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.resolutionsLevels == null) {
                this.resolutionsLevels = new ArrayList();
                this.resolutionsLevels.add(new Resolution(1.0, this.highestRes[0], this.highestRes[1], 0));
                if (this.numOverviews > 0) {
                    for (int i = 0; i < this.overViewResolutions.length; ++i) {
                        this.resolutionsLevels.add(new Resolution(this.overViewResolutions[i][0] / this.highestRes[0], this.overViewResolutions[i][0], this.overViewResolutions[i][1], i + 1));
                    }
                    Collections.sort(this.resolutionsLevels);
                }
            }
        }
        double reqx = requestedRes[0];
        double reqy = requestedRes[1];
        Resolution max = this.resolutionsLevels.get(0);
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0) {
            return max.imageChoice;
        }
        Resolution min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min.scaleFactor) {
            return min.imageChoice;
        }
        Resolution prev = max;
        int size = this.resolutionsLevels.size();
        for (int i = 1; i < size; ++i) {
            Resolution curr = this.resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                return curr.imageChoice;
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == OverviewPolicy.QUALITY) {
                    return prev.imageChoice;
                }
                if (policy == OverviewPolicy.SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
        }
        return max.imageChoice;
    }

    @Override
    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) {
        double[] result;
        if (this.numOverviews > 0) {
            int imageIdx = this.pickOverviewLevel(policy, requestedResolution);
            result = this.overViewResolutions[imageIdx];
        } else {
            result = this.highestRes;
        }
        double[] clone = new double[result.length];
        System.arraycopy(result, 0, clone, 0, result.length);
        return clone;
    }

    protected final void decimationOnReadingControl(Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        int h;
        int w;
        double[] selectedRes = new double[2];
        int choice = imageChoice;
        if (choice == 0) {
            w = this.originalGridRange.getSpan(0);
            h = this.originalGridRange.getSpan(1);
            selectedRes[0] = this.highestRes[0];
            selectedRes[1] = this.highestRes[1];
        } else {
            selectedRes[0] = this.overViewResolutions[choice - 1][0];
            selectedRes[1] = this.overViewResolutions[choice - 1][1];
            w = (int)Math.round(this.originalEnvelope.getSpan(0) / selectedRes[0]);
            h = (int)Math.round(this.originalEnvelope.getSpan(1) / selectedRes[1]);
        }
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    protected final GridCoverage createImageCoverage(PlanarImage image) throws IOException {
        return this.createImageCoverage(image, null);
    }

    protected final GridCoverage2D createImageCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension(colorInterpretation.name()).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(this.coverageName, image, this.crs, raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, new GeneralEnvelope(this.originalEnvelope), bands, null, null);
    }

    protected static final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null && crs != null) {
                MathTransform tr;
                SingleCRS crs2D = CRS.getHorizontalCRS(envelope.getCoordinateReferenceSystem());
                if (crs2D != null && !CRS.equalsIgnoreMetadata(crs, crs2D) && !(tr = CRS.findMathTransform(crs2D, crs, true)).isIdentity()) {
                    envelope = CRS.transform(tr, (Envelope)envelope);
                    envelope.setCoordinateReferenceSystem(crs);
                }
                requestedRes = new double[]{envelope.getSpan(0) / dim.getWidth(), envelope.getSpan(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
    }

    public final CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public GridEnvelope getOriginalGridRange() {
        assert (this.originalGridRange.getDimension() == 2);
        return new GridEnvelope2D(this.originalGridRange.getLow(0), this.originalGridRange.getLow(1), this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1));
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope() {
        return new GeneralEnvelope(this.originalEnvelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        AffineTransform tr;
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.raster2Model == null) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, this.originalEnvelope);
                geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.raster2Model = geMapper.createTransform();
            }
        }
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return this.raster2Model;
        }
        if (this.raster2Model instanceof AffineTransform) {
            tr = new AffineTransform((AffineTransform)((Object)this.raster2Model));
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        if (this.raster2Model instanceof IdentityTransform) {
            tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalud!");
    }

    @Override
    public final Object getSource() {
        return this.source;
    }

    @Override
    public void dispose() {
        block3: {
            if (this.inStream != null && this.closeMe) {
                try {
                    this.inStream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    @Override
    public void skip() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public boolean hasMoreGridCoverages() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public String[] listSubNames() {
        return this.getGridCoverageNames();
    }

    @Override
    public String[] getGridCoverageNames() {
        return new String[]{this.coverageName};
    }

    @Override
    public String getCurrentSubname() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public String[] getMetadataNames(String coverageName) {
        return null;
    }

    @Override
    public String[] getMetadataNames() {
        return null;
    }

    @Override
    public String getMetadataValue(String name) {
        return null;
    }

    @Override
    public String getMetadataValue(String coverageName, String name) {
        return null;
    }

    @Override
    public int getGridCoverageCount() {
        return 1;
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(this.source == null ? null : String.valueOf(this.source));
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            info.setTitle(url.getFile());
            try {
                info.setSource(url.toURI());
            }
            catch (URISyntaxException e) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                info.setTitle(file.getName());
            }
            info.setSource(file.toURI());
        }
        return info;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters() {
        return Collections.emptySet();
    }

    @Override
    public int getNumOverviews(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getNumOverviews();
    }

    @Override
    public int getNumOverviews() {
        return this.overViewResolutions != null ? this.overViewResolutions.length : 0;
    }

    public GridEnvelope getOverviewGridEnvelope(int overviewIndex) throws IOException {
        return this.getOverviewGridEnvelope(this.coverageName, overviewIndex);
    }

    public GridEnvelope getOverviewGridEnvelope(String coverageName, int overviewIndex) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    @Override
    public ImageLayout getImageLayout(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getImageLayout();
    }

    @Override
    public ImageLayout getImageLayout() throws IOException {
        return (ImageLayout)this.imageLayout.clone();
    }

    protected void setLayout(ImageReader reader) throws IOException {
        Utilities.ensureNonNull("reader", reader);
        ImageLayout2 layout = new ImageLayout2();
        ImageTypeSpecifier its = reader.getImageTypes(0).next();
        layout.setColorModel(its.getColorModel()).setSampleModel(its.getSampleModel());
        layout.setMinX(0).setMinY(0).setWidth(reader.getWidth(0)).setHeight(reader.getHeight(0));
        layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth(reader.getTileWidth(0)).setTileHeight(reader.getTileHeight(0));
        this.setlayout(layout);
    }

    protected void setlayout(ImageLayout layout) {
        Utilities.ensureNonNull("layout", layout);
        this.imageLayout = (ImageLayout)layout.clone();
    }

    @Override
    public double[][] getResolutionLevels() throws IOException {
        double[][] returnValue = new double[this.numOverviews + 1][2];
        System.arraycopy(this.highestRes, 0, returnValue[0], 0, 2);
        for (int i = 1; i < returnValue.length; ++i) {
            System.arraycopy(this.overViewResolutions[i - 1], 0, returnValue[i], 0, 2);
        }
        return returnValue;
    }

    @Override
    public double[][] getResolutionLevels(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getResolutionLevels();
    }

    private static class Resolution
    implements Comparable<Resolution> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public Resolution(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(Resolution other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Resolution[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }
    }
}

