/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.WMSException;
import cadastre_fr.WMSLayer;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CadastreInterface {
    public boolean downloadCanceled = false;
    public HttpURLConnection urlConn = null;
    private String cookie;
    private String interfaceRef = null;
    private String lastWMSLayerName = null;
    private URL searchFormURL;
    private Vector<String> listOfCommunes = new Vector();
    private Vector<String> listOfTA = new Vector();
    private Vector<PlanImage> listOfFeuilles = new Vector();
    private long cookieTimestamp;
    final String baseURL = "http://www.cadastre.gouv.fr";
    final String cImageFormat = "Cette commune est au format ";
    final String cCommuneListStart = "<select name=\"codeCommune\"";
    final String cCommuneListEnd = "</select>";
    final String c0ptionListStart = "<option value=\"";
    final String cOptionListEnd = "</option>";
    final String cBBoxCommunStart = "new GeoBox(";
    final String cBBoxCommunEnd = ")";
    final String cInterfaceVector = "afficherCarteCommune.do";
    final String cInterfaceRasterTA = "afficherCarteTa.do";
    final String cInterfaceRasterFeuille = "afficherCarteFeuille.do";
    final String cImageLinkStart = "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteFeuille.do?f=";
    final String cTAImageLinkStart = "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteTa.do?f=";
    final String cImageNameStart = ">Feuille ";
    final String cTAImageNameStart = "Tableau d'assemblage <strong>";
    static final long cCookieExpiration = 1800000L;
    final int cRetriesGetCookie = 10;

    public boolean retrieveInterface(WMSLayer wmsLayer) throws DuplicateLayerException, WMSException {
        if (wmsLayer.getName().equals("")) {
            return false;
        }
        boolean isCookieExpired = this.isCookieExpired();
        if (wmsLayer.getName().equals(this.lastWMSLayerName) && !isCookieExpired) {
            return true;
        }
        if (!wmsLayer.getName().equals(this.lastWMSLayerName)) {
            this.interfaceRef = null;
        }
        this.downloadCanceled = false;
        try {
            if (this.cookie == null || isCookieExpired) {
                this.getCookie();
                this.interfaceRef = null;
            }
            if (this.cookie == null) {
                throw new WMSException(I18n.tr((String)"Cannot open a new client session.\nServer in maintenance or temporary overloaded.", (Object[])new Object[0]));
            }
            if (this.interfaceRef == null) {
                this.getInterface(wmsLayer);
                this.lastWMSLayerName = wmsLayer.getName();
            }
            this.openInterface();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Town/city {0} not found or not available\nor action canceled", (Object[])new Object[]{wmsLayer.getLocation()}));
            return false;
        }
        return true;
    }

    private void getCookie() throws IOException {
        boolean cookied = false;
        int retries = 10;
        try {
            this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/accueil.do");
            while (!cookied && retries > 0) {
                this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
                this.urlConn.setRequestProperty("Connection", "close");
                this.urlConn.setRequestMethod("GET");
                this.urlConn.connect();
                if (this.urlConn.getResponseCode() == 200) {
                    System.out.println("GET " + this.searchFormURL);
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
                    while (in.readLine() != null) {
                    }
                    String headerName = null;
                    int i = 1;
                    while ((headerName = this.urlConn.getHeaderFieldKey(i)) != null) {
                        if (headerName.equals("Set-Cookie")) {
                            this.cookie = this.urlConn.getHeaderField(i);
                            this.cookie = this.cookie.substring(0, this.cookie.indexOf(";"));
                            this.cookieTimestamp = new Date().getTime();
                            System.out.println("received cookie=" + this.cookie + " at " + new Date(this.cookieTimestamp));
                            cookied = true;
                        }
                        ++i;
                    }
                    continue;
                }
                System.out.println("Request to home page failed. Http error:" + this.urlConn.getResponseCode() + ". Try again " + retries + " times");
                CadastrePlugin.safeSleep(3000L);
                --retries;
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
    }

    public void resetCookie() {
        this.lastWMSLayerName = null;
        this.cookie = null;
    }

    public boolean isCookieExpired() {
        long now = new Date().getTime();
        if (now - this.cookieTimestamp > 1800000L) {
            System.out.println("cookie received at " + new Date(this.cookieTimestamp) + " expired (now is " + new Date(now) + ")");
            return true;
        }
        return false;
    }

    public void resetInterfaceRefIfNewLayer(String newWMSLayerName) {
        if (!newWMSLayerName.equals(this.lastWMSLayerName)) {
            this.interfaceRef = null;
            this.cookie = null;
        }
    }

    public void setCookie() {
        this.urlConn.setRequestProperty("Cookie", this.cookie);
    }

    public void setCookie(HttpURLConnection urlConn) {
        urlConn.setRequestProperty("Cookie", this.cookie);
    }

    private void getInterface(WMSLayer wmsLayer) throws IOException, DuplicateLayerException {
        this.interfaceRef = this.postForm(wmsLayer, "");
        if (this.interfaceRef == null) {
            if (!wmsLayer.getCodeCommune().equals("")) {
                this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
            } else {
                int res;
                if (this.listOfCommunes.size() > 1) {
                    String selected = this.selectMunicipalityDialog(wmsLayer);
                    if (selected != null) {
                        String newCodeCommune = selected.substring(1, selected.indexOf(">") - 2);
                        String newLocation = selected.substring(selected.indexOf(">") + 1, selected.lastIndexOf(" - "));
                        wmsLayer.setCodeCommune(newCodeCommune);
                        wmsLayer.setLocation(newLocation);
                        Main.pref.put("cadastrewms.codeCommune", newCodeCommune);
                        Main.pref.put("cadastrewms.location", newLocation);
                    }
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
                }
                if (this.listOfCommunes.size() == 1 && wmsLayer.isRaster() && (res = this.selectFeuilleDialog()) != -1) {
                    wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).name);
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune());
                }
            }
        }
        if (this.interfaceRef == null) {
            throw new IOException("Town/city " + wmsLayer.getLocation() + " not found.");
        }
    }

    private void openInterface() throws IOException {
        try {
            String lines = null;
            String ln = null;
            URL interfaceURL = new URL("http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef);
            this.urlConn = (HttpURLConnection)interfaceURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.setCookie();
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot open Cadastre interface. GET response:" + this.urlConn.getResponseCode());
            }
            System.out.println("GET " + interfaceURL);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while ((ln = in.readLine()) != null) {
                lines = lines + ln;
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("CadastreGrabber: Illegal url.").initCause(e);
        }
    }

    private String postForm(WMSLayer wmsLayer, String codeCommune) throws IOException {
        try {
            String ln = null;
            String lines = null;
            this.listOfCommunes.clear();
            this.listOfTA.clear();
            String content = "numerovoie=";
            content = content + "&indiceRepetition=";
            content = content + "&nomvoie=";
            content = content + "&lieuDit=";
            if (codeCommune == "") {
                content = content + "&ville=" + new String(URLEncoder.encode(wmsLayer.getLocation(), "UTF-8"));
                content = content + "&codePostal=";
            } else {
                content = content + "&codeCommune=" + codeCommune;
            }
            content = content + "&codeDepartement=";
            content = content + wmsLayer.getDepartement();
            content = content + "&nbResultatParPage=10";
            content = content + "&x=0&y=0";
            this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/rechercherPlan.do");
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("POST");
            this.urlConn.setDoOutput(true);
            this.urlConn.setDoInput(true);
            this.setCookie();
            OutputStream wr = this.urlConn.getOutputStream();
            wr.write(content.getBytes());
            System.out.println("POST " + content);
            wr.flush();
            wr.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while ((ln = rd.readLine()) != null) {
                lines = lines + ln;
            }
            rd.close();
            this.urlConn.disconnect();
            if (lines != null) {
                int j;
                int i;
                if (lines.indexOf("Cette commune est au format ") != -1) {
                    i = lines.indexOf("Cette commune est au format ");
                    j = lines.indexOf(".", i);
                    wmsLayer.setRaster(lines.substring(i + "Cette commune est au format ".length(), j).equals("image"));
                }
                if (!wmsLayer.isRaster() && lines.indexOf("afficherCarteCommune.do") != -1) {
                    lines = lines.substring(lines.indexOf("afficherCarteCommune.do"), lines.length());
                    lines = lines.substring(0, lines.indexOf("'"));
                    System.out.println("interface ref.:" + lines);
                    return lines;
                }
                if (wmsLayer.isRaster() && lines.indexOf("afficherCarteTa.do") != -1) {
                    lines = this.getFeuillesList();
                    if (!this.downloadCanceled) {
                        int res;
                        this.parseFeuillesList(lines);
                        if (this.listOfFeuilles.size() > 0 && (res = this.selectFeuilleDialog()) != -1) {
                            wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).name);
                            this.checkLayerDuplicates(wmsLayer);
                            this.interfaceRef = this.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune());
                            wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).ref);
                            lines = this.buildRasterFeuilleInterfaceRef(this.listOfFeuilles.elementAt((int)res).ref);
                            System.out.println("interface ref.:" + lines);
                            return lines;
                        }
                    }
                    return null;
                }
                if (lines.indexOf("<select name=\"codeCommune\"") != -1 && lines.indexOf("</select>") != -1) {
                    i = lines.indexOf("<select name=\"codeCommune\"");
                    j = lines.indexOf("</select>", i);
                    this.parseCommuneList(lines.substring(i, j));
                }
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void parseCommuneList(String input) {
        if (input.indexOf("<option value=\"") != -1) {
            while (input.indexOf("<option value=\"") != -1) {
                int i = input.indexOf("<option value=\"");
                int j = input.indexOf("</option>", i + "<option value=\"".length());
                int k = input.indexOf("\"", i + "<option value=\"".length());
                if (j != -1 && k > i + "<option value=\"".length()) {
                    String lov = new String(input.substring(i + "<option value=\"".length() - 1, j));
                    if (lov.indexOf(">") != -1) {
                        System.out.println("parse " + lov);
                        this.listOfCommunes.add(lov);
                    } else {
                        System.err.println("unable to parse commune string:" + lov);
                    }
                }
                input = input.substring(j + "</option>".length());
            }
        }
    }

    private String getFeuillesList() {
        String ln = null;
        String lines = null;
        HttpURLConnection urlConn2 = null;
        try {
            URL getAllImagesURL = new URL("http://www.cadastre.gouv.fr/scpc/listerFeuillesParcommune.do?keepVolatileSession=&offset=2000");
            urlConn2 = (HttpURLConnection)getAllImagesURL.openConnection();
            this.setCookie(urlConn2);
            urlConn2.connect();
            System.out.println("GET " + getAllImagesURL);
            BufferedReader rd = new BufferedReader(new InputStreamReader(urlConn2.getInputStream()));
            while ((ln = rd.readLine()) != null) {
                lines = lines + ln;
            }
            rd.close();
            urlConn2.disconnect();
        }
        catch (IOException e) {
            this.listOfFeuilles.clear();
            e.printStackTrace();
        }
        return lines;
    }

    private void parseFeuillesList(String input) {
        this.listOfFeuilles.clear();
        String inputTA = input;
        if (Main.pref.getBoolean("cadastrewms.useTA", false)) {
            while (inputTA.indexOf("<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteTa.do?f=") != -1) {
                inputTA = inputTA.substring(inputTA.indexOf("<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteTa.do?f=") + "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteTa.do?f=".length());
                String refTA = inputTA.substring(0, inputTA.indexOf("'"));
                String nameTA = inputTA.substring(inputTA.indexOf("Tableau d'assemblage <strong>") + "Tableau d'assemblage <strong>".length());
                nameTA = nameTA.substring(0, nameTA.indexOf("<"));
                this.listOfFeuilles.add(new PlanImage(nameTA, refTA));
            }
        }
        while (input.indexOf("<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteFeuille.do?f=") != -1) {
            input = input.substring(input.indexOf("<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteFeuille.do?f=") + "<a href=\"#\" class=\"raster\" onClick=\"popup('afficherCarteFeuille.do?f=".length());
            String refFeuille = input.substring(0, input.indexOf("'"));
            String nameFeuille = input.substring(input.indexOf(">Feuille ") + ">Feuille ".length(), input.indexOf(" -"));
            this.listOfFeuilles.add(new PlanImage(nameFeuille, refFeuille));
        }
    }

    private String selectMunicipalityDialog(WMSLayer wmsLayer) {
        JPanel p = new JPanel(new GridBagLayout());
        String[] communeList = new String[this.listOfCommunes.size() + 1];
        communeList[0] = I18n.tr((String)"Choose from...", (Object[])new Object[0]);
        for (int i = 0; i < this.listOfCommunes.size(); ++i) {
            communeList[i + 1] = this.listOfCommunes.elementAt(i).substring(this.listOfCommunes.elementAt(i).indexOf(">") + 1);
        }
        JComboBox<String> inputCommuneList = new JComboBox<String>(communeList);
        p.add(inputCommuneList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select commune", (Object[])new Object[0]));
        CadastrePlugin.prepareDialog(dialog);
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        return this.listOfCommunes.elementAt(inputCommuneList.getSelectedIndex() - 1);
    }

    private int selectFeuilleDialog() {
        JPanel p = new JPanel(new GridBagLayout());
        Vector<String> ImageNames = new Vector<String>();
        for (PlanImage src : this.listOfFeuilles) {
            ImageNames.add(src.name);
        }
        JComboBox inputFeuilleList = new JComboBox(ImageNames);
        p.add(inputFeuilleList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null);
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select Feuille", (Object[])new Object[0]));
        CadastrePlugin.prepareDialog(dialog);
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return -1;
        }
        int result = inputFeuilleList.getSelectedIndex();
        return result;
    }

    private String buildRasterFeuilleInterfaceRef(String codeCommune) {
        return "afficherCarteFeuille.do?f=" + codeCommune;
    }

    public void retrieveCommuneBBox(WMSLayer wmsLayer) throws IOException {
        if (this.interfaceRef == null) {
            return;
        }
        String ln = null;
        String line = null;
        String content = "http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef;
        content = content + "&dontSaveLastForward&keepVolatileSession=";
        this.searchFormURL = new URL(content);
        this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
        this.urlConn.setRequestMethod("GET");
        this.setCookie();
        this.urlConn.connect();
        if (this.urlConn.getResponseCode() != 200) {
            throw new IOException("Cannot get Cadastre response.");
        }
        System.out.println("GET " + this.searchFormURL);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
        while ((ln = in.readLine()) != null) {
            line = line + ln;
        }
        in.close();
        this.urlConn.disconnect();
        this.parseBBoxCommune(wmsLayer, line);
        if (wmsLayer.isRaster() && !wmsLayer.isAlreadyGeoreferenced()) {
            this.parseGeoreferences(wmsLayer, line);
        }
    }

    private void parseBBoxCommune(WMSLayer wmsLayer, String input) {
        if (input.indexOf("new GeoBox(") != -1) {
            input = input.substring(input.indexOf("new GeoBox("));
            int i = input.indexOf(",");
            double minx = Double.parseDouble(input.substring("new GeoBox(".length(), i));
            int j = input.indexOf(",", i + 1);
            double miny = Double.parseDouble(input.substring(i + 1, j));
            int k = input.indexOf(",", j + 1);
            double maxx = Double.parseDouble(input.substring(j + 1, k));
            int l = input.indexOf(")", k + 1);
            double maxy = Double.parseDouble(input.substring(k + 1, l));
            wmsLayer.setCommuneBBox(new EastNorthBound(new EastNorth(minx, miny), new EastNorth(maxx, maxy)));
        }
    }

    private void parseGeoreferences(WMSLayer wmsLayer, String input) {
    }

    private double tryParseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private void checkLayerDuplicates(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (Main.map != null) {
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof WMSLayer) || !l.getName().equals(wmsLayer.getName()) || l == wmsLayer) continue;
                System.out.println("Try to grab into a new layer when " + wmsLayer.getName() + " is already opened.");
                Main.main.removeLayer((Layer)wmsLayer);
                throw new DuplicateLayerException();
            }
        }
    }

    public void cancel() {
        if (this.urlConn != null) {
            this.urlConn.setConnectTimeout(1);
            this.urlConn.setReadTimeout(1);
        }
        this.downloadCanceled = true;
        this.lastWMSLayerName = null;
    }

    class PlanImage {
        String name;
        String ref;

        PlanImage(String name, String ref) {
            this.name = name;
            this.ref = ref;
        }
    }
}

