/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.AnyAction;
import CommandLine.Command;
import CommandLine.CommandAction;
import CommandLine.CommandLineAction;
import CommandLine.DummyAction;
import CommandLine.GpxFilter;
import CommandLine.History;
import CommandLine.LengthAction;
import CommandLine.Loader;
import CommandLine.Mode;
import CommandLine.NodeAction;
import CommandLine.OsmToCmd;
import CommandLine.Parameter;
import CommandLine.PointAction;
import CommandLine.RelationAction;
import CommandLine.Relay;
import CommandLine.Type;
import CommandLine.WayAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class CommandLine
extends Plugin {
    protected JTextField textField;
    protected JTextField historyField;
    private String prefix;
    private Mode mode;
    private ArrayList<Command> commands;
    private JMenu commandMenu;
    protected Command currentCommand;
    protected String commandSymbol = ": ";
    protected History history = new History(100);
    protected MapFrame currentMapFrame;
    protected MapMode previousMode;
    static final String pluginDir = String.valueOf(Main.pref.getPluginsDirectory().getAbsolutePath()) + "/CommandLine/";

    public CommandLine(PluginInformation info) {
        super(info);
        this.historyField = new JTextField();
        this.textField = new JTextField(){

            @Override
            protected void processKeyEvent(KeyEvent e) {
                Command command;
                if (e.getID() == 401) {
                    int code = e.getKeyCode();
                    if (code == 10) {
                        String commandText = CommandLine.this.textField.getText().substring(CommandLine.this.prefix.length());
                        switch (CommandLine.this.mode) {
                            case IDLE: {
                                if (commandText.isEmpty()) {
                                    commandText = CommandLine.this.history.getLastItem();
                                } else {
                                    CommandLine.this.history.addItem(commandText);
                                }
                                Command command2 = CommandLine.this.findCommand(commandText, true);
                                if (command2 != null) {
                                    CommandLine.this.startCommand(command2);
                                    break;
                                }
                                CommandLine.this.setMode(Mode.IDLE);
                                break;
                            }
                            case SELECTION: {
                                if (CommandLine.this.currentMapFrame.mapMode instanceof WayAction || CommandLine.this.currentMapFrame.mapMode instanceof NodeAction || CommandLine.this.currentMapFrame.mapMode instanceof RelationAction || CommandLine.this.currentMapFrame.mapMode instanceof AnyAction) {
                                    Collection selected = Main.main.getCurrentDataSet().getSelected();
                                    if (selected.size() <= 0) break;
                                    CommandLine.this.loadParameter(selected, true);
                                    break;
                                }
                                CommandLine.this.loadParameter(commandText, CommandLine.this.currentCommand.parameters.get((int)CommandLine.this.currentCommand.currentParameterNum).maxInstances == 1);
                                break;
                            }
                        }
                        e.consume();
                    } else if (code == 38) {
                        CommandLine.this.textField.setText(String.valueOf(CommandLine.this.prefix) + CommandLine.this.history.getPrevItem());
                        e.consume();
                    } else if (code == 40) {
                        CommandLine.this.textField.setText(String.valueOf(CommandLine.this.prefix) + CommandLine.this.history.getNextItem());
                        e.consume();
                    } else if (code == 8 || code == 37) {
                        if (CommandLine.this.textField.getCaretPosition() <= CommandLine.this.prefix.length()) {
                            e.consume();
                        }
                    } else if (code == 36) {
                        this.setCaretPosition(CommandLine.this.prefix.length());
                        e.consume();
                    } else if (code == 27) {
                        if (CommandLine.this.textField.getText().length() == CommandLine.this.prefix.length() && CommandLine.this.mode == Mode.IDLE) {
                            CommandLine.this.deactivate();
                        } else {
                            CommandLine.this.endInput();
                        }
                        e.consume();
                    } else if (code != 127 && code != 39 && code != 35) {
                        e.consume();
                    }
                    if (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length() || CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length() && CommandLine.this.textField.getSelectionStart() > 0) {
                        e.consume();
                    }
                }
                if (e.getID() == 400 && (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length() || CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length() && CommandLine.this.textField.getSelectionStart() > 0)) {
                    e.consume();
                }
                super.processKeyEvent(e);
                if (CommandLine.this.textField.getText().length() < CommandLine.this.prefix.length()) {
                    CommandLine.this.setMode(CommandLine.this.mode);
                }
                if (e.getID() == 400 && e.getKeyChar() > 'A' && e.getKeyChar() < 'z' && (command = CommandLine.this.findCommand(CommandLine.this.textField.getText().substring(CommandLine.this.prefix.length()), false)) != null) {
                    int currentPos = CommandLine.this.textField.getSelectionStart() == 0 ? CommandLine.this.textField.getCaretPosition() : CommandLine.this.textField.getSelectionStart();
                    CommandLine.this.textField.setText(String.valueOf(CommandLine.this.prefix) + command.name);
                    CommandLine.this.textField.setCaretPosition(currentPos);
                    CommandLine.this.textField.select(currentPos, CommandLine.this.prefix.length() + command.name.length());
                }
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
                if (e.getButton() == 1 && e.getID() == 502) {
                    if (CommandLine.this.textField.getSelectionStart() > 0 && CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length()) {
                        CommandLine.this.textField.setSelectionStart(CommandLine.this.prefix.length());
                    } else if (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length()) {
                        CommandLine.this.textField.setCaretPosition(CommandLine.this.prefix.length());
                    }
                }
            }
        };
        if (Main.main.menu != null) {
            this.commandMenu = Main.main.menu.addMenu(I18n.marktr((String)"Commands"), 79, Main.main.menu.getDefaultMenuPos(), HelpUtil.ht((String)"/Plugin/CommandLine"));
            MainMenu.add((JMenu)this.commandMenu, (JosmAction)new CommandLineAction(this));
        }
        this.loadCommands();
        this.setMode(Mode.IDLE);
    }

    public void startCommand(String commandName) {
        Command command = this.findCommand(commandName, true);
        if (command != null) {
            this.startCommand(command);
        }
    }

    protected void startCommand(Command command) {
        if (Main.map == null) {
            return;
        }
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            return;
        }
        this.currentCommand = command;
        this.currentCommand.resetLoading();
        this.parseSelection(ds.getSelected());
        if (!(Main.map.mapMode instanceof AnyAction || Main.map.mapMode instanceof DummyAction || Main.map.mapMode instanceof LengthAction || Main.map.mapMode instanceof NodeAction || Main.map.mapMode instanceof PointAction || Main.map.mapMode instanceof RelationAction || Main.map.mapMode instanceof WayAction)) {
            this.previousMode = Main.map.mapMode;
        }
        if (this.currentCommand.currentParameterNum < this.currentCommand.parameters.size()) {
            this.setMode(Mode.SELECTION);
        } else {
            this.runTool();
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.currentMapFrame = newFrame;
        if (oldFrame == null && newFrame != null) {
            JToolBar tb = new JToolBar();
            tb.setLayout(new BorderLayout());
            tb.setFloatable(false);
            tb.setOrientation(0);
            tb.add((Component)this.historyField, "North");
            tb.add((Component)this.textField, "South");
            this.currentMapFrame.add((Component)tb, (Object)"North");
            this.printHistory("Loaded CommandLine, version " + this.getPluginInformation().version);
        }
    }

    protected void printHistory(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandLine.this.historyField.setText(text);
            }
        });
    }

    private void loadCommands() {
        this.commands = new Loader(this.getPluginDir()).load();
        for (Command command : this.commands) {
            this.commandMenu.add((Action)((Object)new CommandAction(command, this)));
        }
    }

    private Command findCommand(String text, boolean strict) {
        int i = 0;
        while (i < this.commands.size()) {
            if (strict ? this.commands.get((int)i).name.equalsIgnoreCase(text) : this.commands.get((int)i).name.toLowerCase().startsWith(text.toLowerCase()) && text.length() > 1) {
                return this.commands.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void setMode(Mode targetMode) {
        DataSet currentDataSet = Main.main.getCurrentDataSet();
        if (currentDataSet != null) {
            currentDataSet.clearSelection();
            Main.map.mapView.repaint();
        }
        if (targetMode == Mode.IDLE) {
            this.mode = Mode.IDLE;
            this.currentCommand = null;
            this.prefix = String.valueOf(I18n.tr((String)"Command", (Object[])new Object[0])) + this.commandSymbol;
            this.textField.setText(this.prefix);
        } else if (targetMode == Mode.SELECTION) {
            this.mode = Mode.SELECTION;
            Parameter currentParameter = this.currentCommand.parameters.get(this.currentCommand.currentParameterNum);
            this.prefix = I18n.tr((String)(currentParameter.description == null ? currentParameter.name : currentParameter.description), (Object[])new Object[0]);
            if (currentParameter.getRawValue() instanceof Relay) {
                this.prefix = String.valueOf(this.prefix) + " (" + ((Relay)currentParameter.getRawValue()).getOptionsString() + ")";
            }
            this.prefix = String.valueOf(this.prefix) + this.commandSymbol;
            String value = currentParameter.getValue();
            this.textField.setText(String.valueOf(this.prefix) + value);
            Type currentType = currentParameter.type;
            MapMode action = null;
            switch (currentType) {
                case POINT: {
                    action = new PointAction(this.currentMapFrame, this);
                    break;
                }
                case WAY: {
                    action = new WayAction(this.currentMapFrame, this);
                    break;
                }
                case NODE: {
                    action = new NodeAction(this.currentMapFrame, this);
                    break;
                }
                case RELATION: {
                    action = new RelationAction(this.currentMapFrame, this);
                    break;
                }
                case ANY: {
                    action = new AnyAction(this.currentMapFrame, this);
                    break;
                }
                case LENGTH: {
                    action = new LengthAction(this.currentMapFrame, this);
                    break;
                }
                case USERNAME: {
                    this.loadParameter(Main.pref.get("osm-server.username", null), true);
                    action = new DummyAction(this.currentMapFrame, this);
                    break;
                }
                case IMAGERYURL: {
                    Layer layer = Main.map.mapView.getActiveLayer();
                    if (layer != null && !(layer instanceof ImageryLayer)) {
                        List imageryLayers = Main.map.mapView.getLayersOfType(ImageryLayer.class);
                        if (imageryLayers.size() == 1) {
                            layer = (Layer)imageryLayers.get(0);
                        } else {
                            this.endInput();
                            return;
                        }
                    }
                    ImageryInfo info = ((ImageryLayer)layer).getInfo();
                    String url = info.getUrl();
                    String itype = info.getImageryType().getTypeString();
                    this.loadParameter(url.equals("") ? itype : url, true);
                    action = new DummyAction(this.currentMapFrame, this);
                    break;
                }
                case IMAGERYOFFSET: {
                    Layer olayer = Main.map.mapView.getActiveLayer();
                    if (olayer != null && !(olayer instanceof ImageryLayer)) {
                        List imageryLayers = Main.map.mapView.getLayersOfType(ImageryLayer.class);
                        if (imageryLayers.size() == 1) {
                            olayer = (Layer)imageryLayers.get(0);
                        } else {
                            this.endInput();
                            return;
                        }
                    }
                    this.loadParameter(String.valueOf(String.valueOf(((ImageryLayer)olayer).getDx())) + "," + String.valueOf(((ImageryLayer)olayer).getDy()), true);
                    action = new DummyAction(this.currentMapFrame, this);
                    break;
                }
                default: {
                    action = new DummyAction(this.currentMapFrame, this);
                }
            }
            this.currentMapFrame.selectMapMode(action);
            this.activate();
            this.textField.select(this.prefix.length(), this.textField.getText().length());
        } else if (targetMode == Mode.PROCESSING) {
            this.mode = Mode.PROCESSING;
            this.prefix = I18n.tr((String)"Processing...", (Object[])new Object[0]);
            this.textField.setText(this.prefix);
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void activate() {
        this.textField.requestFocus();
        this.textField.setCaretPosition(this.textField.getText().length());
    }

    public void deactivate() {
        Main.map.mapView.requestFocus();
    }

    public void abortInput() {
        this.printHistory(String.valueOf(I18n.tr((String)"Aborted", (Object[])new Object[0])) + ".");
        this.endInput();
    }

    public void endInput() {
        this.setMode(Mode.IDLE);
        Main.map.selectMapMode(this.previousMode);
        Main.map.mapView.repaint();
    }

    public void loadParameter(Object obj, boolean next) {
        if (this.currentCommand.loadObject(obj)) {
            if (this.currentCommand.hasNextParameter()) {
                if (next) {
                    Parameter currentParameter = this.currentCommand.parameters.get(this.currentCommand.currentParameterNum);
                    String prefix = I18n.tr((String)(currentParameter.description == null ? currentParameter.name : currentParameter.description), (Object[])new Object[0]);
                    prefix = String.valueOf(prefix) + this.commandSymbol;
                    String value = currentParameter.getValue();
                    this.printHistory(String.valueOf(prefix) + value);
                    this.currentCommand.nextParameter();
                    this.setMode(Mode.SELECTION);
                }
            } else {
                this.runTool();
            }
        } else {
            System.out.println("Invalid argument");
            this.endInput();
        }
    }

    private void parseSelection(Collection<OsmPrimitive> selection) {
        boolean ok = false;
        for (OsmPrimitive obj : selection) {
            ok = this.currentCommand.loadObject(obj);
            if (!ok) break;
        }
        if (ok) {
            this.currentCommand.nextParameter();
        } else {
            this.currentCommand.resetLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTool() {
        this.setMode(Mode.PROCESSING);
        String commandToRun = this.currentCommand.run;
        final boolean tracks = this.currentCommand.tracks;
        final ArrayList<Parameter> parameters = this.currentCommand.parameters;
        for (Parameter parameter : this.currentCommand.parameters) {
            commandToRun = commandToRun.replace("{" + parameter.name + "}", parameter.getValue());
        }
        for (Parameter parameter : this.currentCommand.optParameters) {
            commandToRun = commandToRun.replace("{" + parameter.name + "}", parameter.getValue());
        }
        String[] listToRun = commandToRun.split(" ");
        final Object syncObj = new Object();
        ProcessBuilder builder = new ProcessBuilder(listToRun);
        builder.directory(new File(this.getPluginDir()));
        final StringBuilder debugstr = new StringBuilder();
        for (String s : builder.command()) {
            debugstr.append(String.valueOf(s) + " ");
        }
        debugstr.append("\n");
        System.out.print(debugstr.toString());
        final ToolProcess tp = new ToolProcess();
        try {
            tp.process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            StringBuilder stringBuilder = debugstr;
            synchronized (stringBuilder) {
                System.out.print(String.valueOf(I18n.tr((String)"Error executing the script: ", (Object[])new Object[0])) + debugstr.toString() + e.getMessage() + "\n" + e.getStackTrace());
            }
            return;
        }
        tp.running = true;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    InputStream errStream = tp.process.getErrorStream();
                    while ((len = errStream.read(buffer)) > 0) {
                        StringBuilder stringBuilder = debugstr;
                        synchronized (stringBuilder) {
                            debugstr.append(new String(buffer, 0, len));
                        }
                        System.err.write(buffer, 0, len);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
        Thread osmWriteThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BBox bbox = null;
                OutputStream outputStream = tp.process.getOutputStream();
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "utf-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(printWriter, (boolean)true, null);
                Collection<OsmPrimitive> refObjects = CommandLine.this.currentCommand.getDepsObjects();
                osmWriter.header();
                ArrayList<OsmPrimitive> contents = new ArrayList<OsmPrimitive>();
                for (OsmPrimitive primitive : refObjects) {
                    contents.add(primitive);
                    if (bbox == null) {
                        bbox = new BBox(primitive.getBBox());
                        continue;
                    }
                    bbox.addPrimitive(primitive, 0.0);
                }
                osmWriter.writeNodes((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.nodePredicate));
                osmWriter.writeWays((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.wayPredicate));
                osmWriter.writeRelations((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.relationPredicate));
                osmWriter.footer();
                osmWriter.flush();
                for (Parameter parameter : parameters) {
                    if (!parameter.isOsm()) continue;
                    contents = new ArrayList();
                    osmWriter.header();
                    Collection<OsmPrimitive> pObjects = parameter.getParameterObjects();
                    for (OsmPrimitive primitive : pObjects) {
                        contents.add(primitive);
                        if (bbox == null) {
                            bbox = new BBox(primitive.getBBox());
                            continue;
                        }
                        bbox.addPrimitive(primitive, 0.0);
                    }
                    osmWriter.writeNodes((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.nodePredicate));
                    osmWriter.writeWays((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.wayPredicate));
                    osmWriter.writeRelations((Collection)new SubclassFilteredCollection(contents, OsmPrimitive.relationPredicate));
                    osmWriter.footer();
                    osmWriter.flush();
                }
                if (tracks) {
                    GpxWriter gpxWriter = new GpxWriter(printWriter);
                    GpxFilter gpxFilter = new GpxFilter();
                    gpxFilter.initBboxFilter(bbox);
                    List gpxLayers = Main.map.mapView.getLayersOfType(GpxLayer.class);
                    for (GpxLayer gpxLayer : gpxLayers) {
                        gpxFilter.addGpxData(gpxLayer.data);
                    }
                    gpxWriter.write(gpxFilter.getGpxData());
                    Utils.close((Closeable)gpxWriter);
                }
                Utils.close((Closeable)osmWriter);
                Object object = syncObj;
                synchronized (object) {
                    if (CommandLine.this.currentCommand.asynchronous) {
                        tp.running = false;
                        syncObj.notifyAll();
                    }
                }
            }
        });
        final DataSet currentDataSet = Main.main.getCurrentDataSet();
        final CommandLine that = this;
        Thread osmParseThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    try {
                        try {
                            OsmToCmd osmToCmd = new OsmToCmd(that, currentDataSet);
                            String commandName = CommandLine.this.currentCommand.name;
                            InputStream inputStream = tp.process.getInputStream();
                            osmToCmd.parseStream(inputStream);
                            LinkedList<org.openstreetmap.josm.command.Command> cmdlist = osmToCmd.getCommandList();
                            if (!cmdlist.isEmpty()) {
                                final SequenceCommand cmd = new SequenceCommand(commandName, cmdlist);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Main.main.undoRedo.add((org.openstreetmap.josm.command.Command)cmd);
                                    }
                                });
                            }
                        }
                        catch (Exception exception) {
                            Object object = syncObj;
                            synchronized (object) {
                                tp.running = false;
                                syncObj.notifyAll();
                                break block15;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = syncObj;
                        synchronized (object) {
                            tp.running = false;
                            syncObj.notifyAll();
                        }
                        throw throwable;
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        tp.running = false;
                        syncObj.notifyAll();
                    }
                }
            }
        });
        osmParseThread.start();
        osmWriteThread.start();
        Object object = syncObj;
        synchronized (object) {
            try {
                syncObj.wait(Main.pref.getInteger("commandline.timeout", 20000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tp.running) {
            new Thread((Runnable)new PleaseWaitRunnable(this.currentCommand.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void realRun() {
                    try {
                        this.progressMonitor.indeterminateSubTask(null);
                        Object object = syncObj;
                        synchronized (object) {
                            if (tp.running) {
                                syncObj.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void cancel() {
                    Object object = syncObj;
                    synchronized (object) {
                        tp.running = false;
                        tp.process.destroy();
                        syncObj.notifyAll();
                        CommandLine.this.endInput();
                    }
                }

                protected void finish() {
                }
            }).start();
        }
        this.endInput();
    }

    private class ToolProcess {
        public Process process;
        public volatile boolean running;

        private ToolProcess() {
        }
    }
}

