/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.xml.AppSchemaCache;
import org.geotools.xml.AppSchemaCatalog;

public class AppSchemaResolver {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaResolver.class.getPackage().getName());
    private AppSchemaCatalog catalog;
    private boolean classpath = true;
    private AppSchemaCache cache;
    private Map<String, String> resolvedLocationToOriginalLocationMap = new HashMap<String, String>();

    public AppSchemaResolver(AppSchemaCatalog catalog, boolean classpath, AppSchemaCache cache) {
        this.catalog = catalog;
        this.classpath = classpath;
        this.cache = cache;
    }

    public AppSchemaResolver(AppSchemaCatalog catalog, AppSchemaCache cache) {
        this(catalog, true, cache);
    }

    public AppSchemaResolver() {
        this(null, null);
    }

    public AppSchemaResolver(AppSchemaCatalog catalog) {
        this(catalog, null);
    }

    public AppSchemaResolver(AppSchemaCache cache) {
        this(null, cache);
    }

    public String resolve(String location, String context) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!locationUri.isAbsolute()) {
            URI contextUri;
            if (context == null) {
                throw new RuntimeException("Could not determine absolute schema location for " + location + " because context schema location is unknown");
            }
            String originalContext = this.resolvedLocationToOriginalLocationMap.get(context);
            if (originalContext == null) {
                originalContext = context;
            }
            try {
                contextUri = new URI(originalContext);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            locationUri = contextUri.resolve(locationUri);
        }
        return this.resolve(locationUri.toString());
    }

    public String resolve(String location) {
        String resolvedLocation = null;
        if (location.startsWith("file:") || location.startsWith("jar:file:")) {
            resolvedLocation = location;
        }
        if (resolvedLocation == null && this.catalog != null) {
            resolvedLocation = this.catalog.resolveLocation(location);
        }
        if (resolvedLocation == null && this.classpath) {
            resolvedLocation = AppSchemaResolver.resolveClasspathLocation(location);
        }
        if (resolvedLocation == null && this.cache != null) {
            resolvedLocation = this.cache.resolveLocation(location);
        }
        if (resolvedLocation == null) {
            throw new RuntimeException(String.format("Failed to resolve %s", location));
        }
        this.resolvedLocationToOriginalLocationMap.put(resolvedLocation, location);
        LOGGER.fine(String.format("Resolved %s -> %s", location, resolvedLocation));
        return resolvedLocation;
    }

    public static String getSimpleHttpResourcePath(String location) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return AppSchemaResolver.getSimpleHttpResourcePath(locationUri);
    }

    public static String getSimpleHttpResourcePath(URI location) {
        String scheme = location.getScheme();
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            return null;
        }
        String host = location.getHost();
        String path = location.getPath();
        String[] hostParts = host.split("\\.");
        StringBuffer buffer = new StringBuffer();
        for (int i = hostParts.length - 1; i >= 0; --i) {
            buffer.append("/");
            buffer.append(hostParts[i]);
        }
        buffer.append(path);
        return buffer.toString();
    }

    public static URL getClasspathResourceUrl(String location) {
        String path = AppSchemaResolver.getSimpleHttpResourcePath(location);
        if (path == null) {
            return null;
        }
        return AppSchemaResolver.class.getResource(path);
    }

    public static String resolveClasspathLocation(String location) {
        URL url = AppSchemaResolver.getClasspathResourceUrl(location);
        if (url == null) {
            return null;
        }
        return AppSchemaResolver.getClasspathResourceUrl(location).toExternalForm();
    }
}

