/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProjectionHandler {
    protected static final Logger LOGGER = Logging.getLogger(ProjectionHandler.class);
    ReferencedEnvelope renderingEnvelope;
    final ReferencedEnvelope validArea;

    public ProjectionHandler(ReferencedEnvelope renderingEnvelope, ReferencedEnvelope validArea) {
        this.renderingEnvelope = renderingEnvelope;
        this.validArea = validArea;
    }

    public ReferencedEnvelope getRenderingEnvelope() {
        return this.renderingEnvelope;
    }

    public void setRenderingEnvelope(ReferencedEnvelope renderingEnvelope) {
        this.renderingEnvelope = renderingEnvelope;
    }

    public List<ReferencedEnvelope> getQueryEnvelopes(CoordinateReferenceSystem queryCRS) throws TransformException, FactoryException {
        int i;
        ReferencedEnvelope re = this.renderingEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true, 10);
        if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
            return Collections.singletonList(this.renderingEnvelope.transform(queryCRS, true, 10));
        }
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
        envelopes.add(re);
        if (re.getMinX() < -180.0) {
            envelopes.add(new ReferencedEnvelope(re.getMinX() + 360.0, 180.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        if (re.getMaxX() > 180.0) {
            envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxX() - 360.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        boolean merged = true;
        while (merged && envelopes.size() > 1) {
            merged = false;
            for (i = 0; i < envelopes.size() - 1; ++i) {
                ReferencedEnvelope curr = (ReferencedEnvelope)envelopes.get(i);
                int j = i + 1;
                while (j < envelopes.size()) {
                    ReferencedEnvelope next = (ReferencedEnvelope)envelopes.get(j);
                    if (curr.intersects(next)) {
                        curr.expandToInclude(next);
                        envelopes.remove(j);
                        merged = true;
                        continue;
                    }
                    ++j;
                }
            }
        }
        for (i = 0; i < envelopes.size(); ++i) {
            envelopes.set(i, ((ReferencedEnvelope)envelopes.get(i)).transform(queryCRS, true, 10));
        }
        return envelopes;
    }

    public boolean requiresProcessing(CoordinateReferenceSystem geomCRS, Geometry geometry) {
        if (this.validArea == null) {
            return false;
        }
        return !CRS.equalsIgnoreMetadata((Object)geomCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem());
    }

    public Geometry preProcess(CoordinateReferenceSystem geomCRS, Geometry geometry) throws TransformException, FactoryException {
        Geometry result;
        if (CRS.equalsIgnoreMetadata((Object)geomCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem())) {
            return geometry;
        }
        if (this.validArea == null) {
            return geometry;
        }
        ReferencedEnvelope ge = new ReferencedEnvelope(geometry.getEnvelopeInternal(), geomCRS);
        ReferencedEnvelope geWGS84 = ge.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        if (this.validArea.contains(geWGS84)) {
            return geometry;
        }
        ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validArea.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (envIntWgs84.isEmpty()) {
            return null;
        }
        ReferencedEnvelope envInt = envIntWgs84.transform(geomCRS, true);
        Polygon envelopeGeometry = JTS.toGeometry((Envelope)envInt);
        try {
            result = geometry.intersection(envelopeGeometry);
        }
        catch (Exception e1) {
            try {
                result = EnhancedPrecisionOp.intersection(geometry, envelopeGeometry);
            }
            catch (Exception e2) {
                result = geometry;
            }
        }
        if (result instanceof GeometryCollection && ((GeometryCollection)result).isEmpty()) {
            return null;
        }
        return result;
    }

    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        return geometry;
    }
}

