/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Utils;
import org.mapdb.Volume;

public class StoreAppend
implements Engine {
    protected final File file;
    protected final boolean useRandomAccessFile;
    protected final boolean readOnly;
    protected static final long FILE_NUMBER_SHIFT = 28L;
    protected static final long FILE_OFFSET_MASK = 0xFFFFFFFL;
    protected static final long FILE_HEADER = 56465465456465L;
    protected static final int CONCURRENCY_FACTOR = 32;
    protected final ReentrantReadWriteLock[] readLocks;
    protected final Lock structuralLock = new ReentrantLock();
    protected static final Long THUMBSTONE = Long.MIN_VALUE;
    protected static final int THUMBSTONE_SIZE = -3;
    protected static final long EOF = -1L;
    protected static final long COMMIT = -2L;
    protected static final long ROLLBACK = -2L;
    protected volatile Volume currentVolume;
    protected volatile long currentVolumeNum;
    protected volatile int currentFileOffset;
    protected volatile long maxRecid;
    protected LongConcurrentHashMap<Volume> volumes = new LongConcurrentHashMap();
    protected final LongConcurrentHashMap<Long> recidsInTx = new LongConcurrentHashMap();
    protected final Volume recidsTable = new Volume.MemoryVol(true);
    protected static final int MAX_FILE_SIZE = 0xA00000;

    public StoreAppend(File file, boolean useRandomAccessFile, boolean readOnly, boolean transactionsDisabled) {
        this.file = file;
        this.useRandomAccessFile = useRandomAccessFile;
        this.readOnly = readOnly;
        this.readLocks = new ReentrantReadWriteLock[32];
        for (int i = 0; i < this.readLocks.length; ++i) {
            this.readLocks[i] = new ReentrantReadWriteLock();
        }
        File zeroFile = this.getFileNum(0L);
        if (zeroFile.exists()) {
            this.replayLog();
        } else {
            this.recidsTable.ensureAvailable(64L);
            for (long i = 0L; i <= 7L; ++i) {
                this.recidsTable.putLong(i * 8L, 0L);
            }
            this.maxRecid = 8L;
            this.currentVolume = Volume.volumeForFile(zeroFile, useRandomAccessFile, readOnly);
            this.currentVolume.ensureAvailable(8L);
            this.currentVolume.putLong(0L, 56465465456465L);
            this.currentFileOffset = 8;
            this.volumes.put(0L, this.currentVolume);
        }
    }

    protected void replayLog() {
        try {
            long fileNum = 0L;
            while (true) {
                File f;
                if (!(f = this.getFileNum(fileNum)).exists()) {
                    return;
                }
                this.currentVolume = Volume.volumeForFile(f, this.useRandomAccessFile, this.readOnly);
                this.volumes.put(fileNum, this.currentVolume);
                this.currentVolumeNum = fileNum;
                LongHashMap<Long> recidsTable2 = new LongHashMap<Long>();
                if (!this.currentVolume.isEmpty()) {
                    this.currentFileOffset = 0;
                    long header = this.currentVolume.getLong(this.currentFileOffset);
                    this.currentFileOffset += 8;
                    if (header != 56465465456465L) {
                        throw new InternalError();
                    }
                    while (true) {
                        long recid = this.currentVolume.getLong(this.currentFileOffset);
                        this.currentFileOffset += 8;
                        this.maxRecid = Math.max(recid, this.maxRecid);
                        if (recid == -1L || recid == 0L) break;
                        if (recid == -2L) {
                            this.commitRecids(recidsTable2);
                            continue;
                        }
                        if (recid == -2L) {
                            recidsTable2.clear();
                            continue;
                        }
                        long filePos = fileNum << 28 | (long)this.currentFileOffset;
                        int size = this.currentVolume.getInt(this.currentFileOffset);
                        this.currentFileOffset += 4;
                        if (size != -3) {
                            this.currentFileOffset += size;
                            recidsTable2.put(recid, filePos);
                            continue;
                        }
                        recidsTable2.put(recid, THUMBSTONE);
                    }
                }
                ++fileNum;
            }
        }
        catch (IOError iOError) {
            return;
        }
    }

    protected File getFileNum(long fileNum) {
        return new File(this.file.getPath() + "." + fileNum);
    }

    protected void commitRecids(LongMap<Long> recidsTable2) {
        LongMap.LongMapIterator<Long> iter = recidsTable2.longMapIterator();
        while (iter.moveToNext()) {
            long recidsTableOffset = iter.key() * 8L;
            this.recidsTable.ensureAvailable(recidsTableOffset + 8L);
            this.recidsTable.putLong(recidsTableOffset, iter.value());
        }
        recidsTable2.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        Volume vol;
        long volNum;
        long pos;
        long recid;
        DataOutput2 out = Utils.serializer(serializer, value);
        this.structuralLock.lock();
        try {
            recid = this.maxRecid++;
            pos = this.currentFileOffset;
            this.currentFileOffset += 12 + out.pos;
            this.currentVolume.ensureAvailable(this.currentFileOffset);
            volNum = this.currentVolumeNum;
            vol = this.currentVolume;
            this.rollOverFile();
        }
        finally {
            this.structuralLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock lock = this.readLocks[Utils.longHash(recid) % this.readLocks.length].writeLock();
        lock.lock();
        try {
            vol.putLong(pos, recid);
            long filePos = volNum << 28 | (pos += 8L);
            vol.putInt(pos, out.pos);
            vol.putData(pos += 4L, out.buf, 0, out.pos);
            this.recidsInTx.put(recid, filePos);
            long l = recid;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        ReentrantReadWriteLock.ReadLock lock = this.readLocks[Utils.longHash(recid) % this.readLocks.length].readLock();
        lock.lock();
        try {
            A a = this.getNoLock(recid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected <A> A getNoLock(long recid, Serializer<A> serializer) throws IOException {
        Long fileNum2 = this.recidsInTx.get(recid);
        if (fileNum2 == null) {
            this.recidsTable.ensureAvailable(recid * 8L + 8L);
            fileNum2 = this.recidsTable.getLong(recid * 8L);
        }
        if (fileNum2 == THUMBSTONE) {
            return null;
        }
        if (fileNum2 == 0L) {
            return serializer.deserialize(new DataInput2(new byte[0]), 0);
        }
        long fileNum = fileNum2;
        long fileOffset = fileNum & 0xFFFFFFFL;
        if (fileOffset > 0xA00000L) {
            throw new InternalError();
        }
        Volume v = this.volumes.get(fileNum >>>= 28);
        int size = v.getInt(fileOffset);
        DataInput2 input = v.getDataInput(fileOffset + 4L, size);
        return serializer.deserialize(input, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        DataOutput2 out = Utils.serializer(serializer, value);
        ReentrantReadWriteLock.WriteLock lock = this.readLocks[Utils.longHash(recid) % this.readLocks.length].writeLock();
        lock.lock();
        try {
            Volume vol;
            long volNum;
            long pos;
            this.structuralLock.lock();
            try {
                pos = this.currentFileOffset;
                this.currentFileOffset += 12 + out.pos;
                this.currentVolume.ensureAvailable(this.currentFileOffset);
                volNum = this.currentVolumeNum;
                vol = this.currentVolume;
                this.rollOverFile();
            }
            finally {
                this.structuralLock.unlock();
            }
            vol.putLong(pos, recid);
            long filePos = volNum << 28 | (pos += 8L);
            vol.putInt(pos, out.pos);
            vol.putData(pos += 4L, out.buf, 0, out.pos);
            this.recidsInTx.put(recid, filePos);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        ReentrantReadWriteLock.WriteLock lock = this.readLocks[Utils.longHash(recid) % this.readLocks.length].writeLock();
        lock.lock();
        try {
            Volume vol;
            long volNum;
            long pos;
            A oldVal = this.get(recid, serializer);
            if (!(oldVal == null && expectedOldValue == null || oldVal != null && oldVal.equals(expectedOldValue))) {
                boolean bl = false;
                return bl;
            }
            DataOutput2 out = Utils.serializer(serializer, newValue);
            this.structuralLock.lock();
            try {
                pos = this.currentFileOffset;
                this.currentFileOffset += 12 + out.pos;
                this.currentVolume.ensureAvailable(this.currentFileOffset);
                volNum = this.currentVolumeNum;
                vol = this.currentVolume;
                this.rollOverFile();
            }
            finally {
                this.structuralLock.unlock();
            }
            vol.putLong(pos, recid);
            long filePos = volNum << 28 | (pos += 8L);
            vol.putInt(pos, out.pos);
            vol.putData(pos += 4L, out.buf, 0, out.pos);
            this.recidsInTx.put(recid, filePos);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        ReentrantReadWriteLock.WriteLock lock = this.readLocks[Utils.longHash(recid) % this.readLocks.length].writeLock();
        lock.lock();
        try {
            this.structuralLock.lock();
            try {
                this.currentVolume.ensureAvailable(this.currentFileOffset + 8 + 4);
                this.currentVolume.putLong(this.currentFileOffset, recid);
                this.currentFileOffset += 8;
                this.currentVolume.putInt(this.currentFileOffset, -3);
                this.currentFileOffset += 4;
                this.recidsInTx.put(recid, THUMBSTONE);
                this.rollOverFile();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        this.structuralLock.lock();
        this.currentVolume.sync();
        this.currentVolume.close();
        this.currentVolume = null;
        this.volumes = null;
        this.structuralLock.unlock();
    }

    @Override
    public boolean isClosed() {
        return this.volumes == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.structuralLock.lock();
        try {
            this.commitRecids(this.recidsInTx);
            this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
            this.currentVolume.putLong(this.currentFileOffset, -2L);
            this.currentFileOffset += 8;
            this.currentVolume.sync();
            this.rollOverFile();
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.structuralLock.lock();
        try {
            this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
            this.currentVolume.putLong(this.currentFileOffset, -2L);
            this.currentFileOffset += 8;
            this.currentVolume.sync();
            this.recidsInTx.clear();
            this.rollOverFile();
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    protected void rollOverFile() {
        if (this.currentFileOffset < 0x9FFFF8) {
            return;
        }
        this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
        this.currentVolume.putLong(this.currentFileOffset, -1L);
        this.currentVolume.sync();
        ++this.currentVolumeNum;
        this.currentVolume = Volume.volumeForFile(this.getFileNum(this.currentVolumeNum), this.useRandomAccessFile, this.readOnly);
        this.currentVolume.ensureAvailable(0xA00000L);
        this.currentVolume.putLong(0L, 56465465456465L);
        this.currentFileOffset = 8;
        this.currentVolume.sync();
        this.volumes.put(this.currentVolumeNum, this.currentVolume);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        this.structuralLock.lock();
        try {
            if (!this.recidsInTx.isEmpty()) {
                throw new IllegalAccessError("Uncommited changes");
            }
            LongHashMap<Boolean> ff = new LongHashMap<Boolean>();
            for (long recid = 0L; recid < this.maxRecid; ++recid) {
                long indexVal = this.recidsTable.getLong(recid * 8L);
                if (indexVal == 0L) continue;
                long fileNum = indexVal >>> 28;
                ff.put(fileNum, true);
            }
            LongMap.LongMapIterator<Volume> iter = this.volumes.longMapIterator();
            while (iter.moveToNext()) {
                long recid = iter.key();
                if (ff.get(recid) != null) continue;
                Volume v = iter.value();
                v.close();
                v.deleteFile();
                iter.remove();
            }
        }
        finally {
            this.structuralLock.unlock();
        }
    }
}

