/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.Bind;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.SnapshotEngine;
import org.mapdb.Utils;

public class BTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Bind.MapWithModificationListener<K, V> {
    protected static final int DEFAULT_MAX_NODE_SIZE = 32;
    protected final long rootRecidRef;
    protected final BTreeKeySerializer keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Comparator comparator;
    protected final LongConcurrentHashMap<Thread> nodeLocks = new LongConcurrentHashMap();
    protected final int maxNodeSize;
    protected final Engine engine;
    protected final boolean hasValues;
    protected final boolean valsOutsideNodes;
    protected final long treeRecid;
    private final KeySet keySet;
    private final EntrySet entrySet = new EntrySet(this);
    private final Values values = new Values(this);
    protected final Serializer defaultSerializer;
    protected final Atomic.Long counter;
    protected final Serializer<BNode> nodeSerializer = new Serializer<BNode>(){

        @Override
        public void serialize(DataOutput out, BNode value) throws IOException {
            boolean right;
            boolean isLeaf = value.isLeaf();
            if (value.keys().length > 255) {
                throw new InternalError();
            }
            if (!isLeaf && value.child().length != value.keys().length) {
                throw new InternalError();
            }
            if (isLeaf && BTreeMap.this.hasValues && value.vals().length != value.keys().length) {
                throw new InternalError();
            }
            boolean left = value.keys()[0] == null;
            boolean bl = right = value.keys()[value.keys().length - 1] == null;
            int header = isLeaf ? (right ? (left ? 138 : 140) : (left ? 139 : 141)) : (right ? (left ? 142 : 144) : (left ? 143 : 145));
            out.write(header);
            out.write(value.keys().length);
            if (isLeaf) {
                Utils.packLong(out, ((LeafNode)value).next);
            } else {
                for (long child : ((DirNode)value).child) {
                    Utils.packLong(out, child);
                }
            }
            BTreeMap.this.keySerializer.serialize(out, left ? 1 : 0, right ? value.keys().length - 1 : value.keys().length, value.keys());
            if (isLeaf && BTreeMap.this.hasValues) {
                for (int i = 0; i < value.vals().length; ++i) {
                    Object val = value.vals()[i];
                    if (BTreeMap.this.valsOutsideNodes) {
                        long recid = val != null ? ((ValRef)val).recid : 0L;
                        Utils.packLong(out, recid);
                        continue;
                    }
                    BTreeMap.this.valueSerializer.serialize(out, val);
                }
            }
        }

        @Override
        public BNode deserialize(DataInput in, int available) throws IOException {
            int end;
            int header = in.readUnsignedByte();
            int size = in.readUnsignedByte();
            boolean isLeaf = header == 141 || header == 139 || header == 138 || header == 140;
            int start = header == 139 || header == 138 || header == 143 || header == 142 ? 1 : 0;
            int n = end = header == 140 || header == 138 || header == 144 || header == 142 ? size - 1 : size;
            if (isLeaf) {
                long next = Utils.unpackLong(in);
                Object[] keys = BTreeMap.this.keySerializer.deserialize(in, start, end, size);
                if (keys.length != size) {
                    throw new InternalError();
                }
                Object[] vals = null;
                if (BTreeMap.this.hasValues) {
                    vals = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        long recid;
                        vals[i] = BTreeMap.this.valsOutsideNodes ? ((recid = Utils.unpackLong(in)) == 0L ? null : new ValRef(recid)) : BTreeMap.this.valueSerializer.deserialize(in, size - 1);
                    }
                }
                return new LeafNode(keys, vals, next);
            }
            long[] child = new long[size];
            for (int i = 0; i < size; ++i) {
                child[i] = Utils.unpackLong(in);
            }
            Object[] keys = BTreeMap.this.keySerializer.deserialize(in, start, end, size);
            if (keys.length != size) {
                throw new InternalError();
            }
            return new DirNode(keys, child);
        }
    };
    protected final Object modListenersLock = new Object();
    protected Bind.MapListener<K, V>[] modListeners = new Bind.MapListener[0];

    public BTreeMap(Engine engine, int maxNodeSize, boolean hasValues, boolean valsOutsideNodes, boolean keepCounter, Serializer defaultSerializer, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator) {
        if (maxNodeSize % 2 != 0) {
            throw new IllegalArgumentException("maxNodeSize must be dividable by 2");
        }
        if (maxNodeSize < 6) {
            throw new IllegalArgumentException("maxNodeSize too low");
        }
        if (maxNodeSize > 126) {
            throw new IllegalArgumentException("maxNodeSize too high");
        }
        SerializerBase.assertSerializable(keySerializer);
        SerializerBase.assertSerializable(valueSerializer);
        SerializerBase.assertSerializable(comparator);
        if (defaultSerializer == null) {
            defaultSerializer = Serializer.BASIC_SERIALIZER;
        }
        this.defaultSerializer = defaultSerializer;
        this.hasValues = hasValues;
        this.valsOutsideNodes = valsOutsideNodes;
        this.engine = engine;
        this.maxNodeSize = maxNodeSize;
        this.comparator = comparator == null ? Utils.COMPARABLE_COMPARATOR : comparator;
        this.keySerializer = keySerializer == null ? new BTreeKeySerializer.BasicKeySerializer(defaultSerializer) : keySerializer;
        this.valueSerializer = valueSerializer == null ? defaultSerializer : valueSerializer;
        this.keySet = new KeySet(this, hasValues);
        LeafNode emptyRoot = new LeafNode(new Object[]{null, null}, new Object[]{null, null}, 0L);
        long rootRecidVal = engine.put(emptyRoot, this.nodeSerializer);
        this.rootRecidRef = engine.put(rootRecidVal, Serializer.LONG_SERIALIZER);
        long counterRecid = 0L;
        if (keepCounter) {
            counterRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
            this.counter = new Atomic.Long(engine, counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
        BTreeRoot r = new BTreeRoot();
        r.hasValues = this.hasValues;
        r.valsOutsideNodes = this.valsOutsideNodes;
        r.rootRecidRef = this.rootRecidRef;
        r.maxNodeSize = this.maxNodeSize;
        r.keySerializer = this.keySerializer;
        r.valueSerializer = this.valueSerializer;
        r.comparator = this.comparator;
        r.counterRecid = counterRecid;
        this.treeRecid = engine.put(r, new BTreeRootSerializer(this.defaultSerializer));
    }

    public BTreeMap(Engine engine, long recid, Serializer defaultSerializer) {
        this.engine = engine;
        this.treeRecid = recid;
        if (defaultSerializer == null) {
            defaultSerializer = Serializer.BASIC_SERIALIZER;
        }
        this.defaultSerializer = defaultSerializer;
        BTreeRoot r = engine.get(recid, new BTreeRootSerializer(defaultSerializer));
        this.hasValues = r.hasValues;
        this.rootRecidRef = r.rootRecidRef;
        this.maxNodeSize = r.maxNodeSize;
        this.keySerializer = r.keySerializer;
        this.valueSerializer = r.valueSerializer;
        this.comparator = r.comparator;
        this.valsOutsideNodes = r.valsOutsideNodes;
        this.keySet = new KeySet(this, this.hasValues);
        if (r.counterRecid != 0L) {
            this.counter = new Atomic.Long(engine, r.counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
    }

    protected final int findChildren(Object key, Object[] keys) {
        int right;
        int left = 0;
        if (keys[0] == null) {
            ++left;
        }
        int n = right = keys[keys.length - 1] == null ? keys.length - 1 : keys.length;
        do {
            int middle;
            if (keys[middle = (left + right) / 2] == null) {
                return middle;
            }
            if (this.comparator.compare(keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        } while (left < right);
        return right;
    }

    @Override
    public V get(Object key) {
        long rootRecid;
        if (key == null) {
            throw new NullPointerException();
        }
        Object v = key;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int pos = this.findChildren(v, leaf.keys);
        while (pos == leaf.keys.length) {
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
            pos = this.findChildren(v, leaf.keys);
        }
        if (pos == leaf.keys.length - 1) {
            return null;
        }
        if (leaf.keys[pos] != null && 0 == this.comparator.compare(v, leaf.keys[pos])) {
            String ret = this.hasValues ? leaf.vals[pos] : "";
            return this.valExpand(ret);
        }
        return null;
    }

    protected V valExpand(Object ret) {
        if (this.valsOutsideNodes && ret != null) {
            long recid = ((ValRef)ret).recid;
            ret = this.engine.get(recid, this.valueSerializer);
        }
        return (V)ret;
    }

    protected long nextDir(DirNode d, Object key) {
        int pos = this.findChildren(key, d.keys) - 1;
        if (pos < 0) {
            pos = 0;
        }
        return d.child[pos];
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, false);
    }

    protected V put2(K v, V value2, boolean putOnlyIfAbsent) {
        long q;
        BNode B;
        BNode A;
        long current;
        block22: {
            long rootRecid;
            if (v == null) {
                throw new IllegalArgumentException("null key");
            }
            if (value2 == null) {
                throw new IllegalArgumentException("null value");
            }
            Utils.checkMapValueIsNotCollecion(value2);
            Object value = value2;
            if (this.valsOutsideNodes) {
                long recid = this.engine.put(value2, this.valueSerializer);
                value = new ValRef(recid);
            }
            int stackPos = -1;
            long[] stackVals = new long[4];
            current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
            A = this.engine.get(current, this.nodeSerializer);
            while (!A.isLeaf()) {
                long t = current;
                current = this.nextDir((DirNode)A, v);
                if (current != A.child()[A.child().length - 1]) {
                    if (stackVals.length == ++stackPos) {
                        stackVals = Arrays.copyOf(stackVals, stackVals.length * 2);
                    }
                    stackVals[stackPos] = t;
                }
                A = this.engine.get(current, this.nodeSerializer);
            }
            int level = 1;
            long p = 0L;
            while (true) {
                Utils.lock(this.nodeLocks, current);
                boolean found = true;
                A = this.engine.get(current, this.nodeSerializer);
                int pos = this.findChildren(v, A.keys());
                if (pos < A.keys().length - 1 && v != null && A.keys()[pos] != null && 0 == this.comparator.compare(v, A.keys()[pos])) {
                    String oldVal;
                    String string = oldVal = this.hasValues ? A.vals()[pos] : "";
                    if (putOnlyIfAbsent) {
                        Utils.unlock(this.nodeLocks, current);
                        Utils.assertNoLocks(this.nodeLocks);
                        V ret = this.valExpand(oldVal);
                        this.notify(v, ret, value2);
                        return ret;
                    }
                    Object[] vals = null;
                    if (this.hasValues) {
                        vals = Arrays.copyOf(A.vals(), A.vals().length);
                        vals[pos] = value;
                    }
                    A = new LeafNode(Arrays.copyOf(A.keys(), A.keys().length), vals, ((LeafNode)A).next);
                    this.engine.update(current, A, this.nodeSerializer);
                    Utils.unlock(this.nodeLocks, current);
                    Utils.assertNoLocks(this.nodeLocks);
                    V ret = this.valExpand(oldVal);
                    this.notify(v, ret, value2);
                    return ret;
                }
                if (A.highKey() != null && this.comparator.compare(v, A.highKey()) > 0) {
                    long next;
                    Utils.unlock(this.nodeLocks, current);
                    found = false;
                    int pos2 = this.findChildren(v, A.keys());
                    while (A != null && pos2 == A.keys().length && (next = A.next()) != 0L) {
                        current = next;
                        A = this.engine.get(current, this.nodeSerializer);
                    }
                }
                if (!found) continue;
                if (A.keys().length - (A.isLeaf() ? 2 : 1) < this.maxNodeSize) {
                    pos = this.findChildren(v, A.keys());
                    Object[] keys = Utils.arrayPut(A.keys(), pos, v);
                    if (A.isLeaf()) {
                        Object[] vals = this.hasValues ? Utils.arrayPut(A.vals(), pos, value) : null;
                        LeafNode n = new LeafNode(keys, vals, ((LeafNode)A).next);
                        this.engine.update(current, n, this.nodeSerializer);
                    } else {
                        if (p == 0L) {
                            throw new InternalError();
                        }
                        long[] child = Utils.arrayLongPut(A.child(), pos, p);
                        DirNode d = new DirNode(keys, child);
                        this.engine.update(current, d, this.nodeSerializer);
                    }
                    Utils.unlock(this.nodeLocks, current);
                    Utils.assertNoLocks(this.nodeLocks);
                    this.notify(v, null, value2);
                    return null;
                }
                boolean isRoot = current == rootRecid;
                int pos2 = this.findChildren(v, A.keys());
                Object[] keys = Utils.arrayPut(A.keys(), pos2, v);
                Object[] vals = A.isLeaf() && this.hasValues ? Utils.arrayPut(A.vals(), pos2, value) : null;
                long[] child = A.isLeaf() ? null : Utils.arrayLongPut(A.child(), pos2, p);
                int splitPos = keys.length / 2;
                if (A.isLeaf()) {
                    Object[] vals2 = null;
                    if (this.hasValues) {
                        vals2 = Arrays.copyOfRange(vals, splitPos, vals.length);
                        vals2[0] = null;
                    }
                    B = new LeafNode(Arrays.copyOfRange(keys, splitPos, keys.length), vals2, ((LeafNode)A).next);
                } else {
                    B = new DirNode(Arrays.copyOfRange(keys, splitPos, keys.length), Arrays.copyOfRange(child, splitPos, keys.length));
                }
                q = this.engine.put(B, this.nodeSerializer);
                if (A.isLeaf()) {
                    Object[] keys2 = Arrays.copyOf(keys, splitPos + 2);
                    keys2[keys2.length - 1] = keys2[keys2.length - 2];
                    Object[] vals2 = null;
                    if (this.hasValues) {
                        vals2 = Arrays.copyOf(vals, splitPos + 2);
                        vals2[vals2.length - 1] = null;
                    }
                    A = new LeafNode(keys2, vals2, q);
                } else {
                    long[] child2 = Arrays.copyOf(child, splitPos + 1);
                    child2[splitPos] = q;
                    A = new DirNode(Arrays.copyOf(keys, splitPos + 1), child2);
                }
                this.engine.update(current, A, this.nodeSerializer);
                if (isRoot) break block22;
                Utils.unlock(this.nodeLocks, current);
                p = q;
                v = A.highKey();
                ++level;
                if (stackPos == -1) break;
                current = stackVals[stackPos--];
            }
            current = -1L;
            throw new InternalError();
        }
        DirNode R = new DirNode(new Object[]{A.keys()[0], A.highKey(), B.highKey()}, new long[]{current, q, 0L});
        long newRootRecid = this.engine.put(R, this.nodeSerializer);
        this.engine.update(this.rootRecidRef, newRootRecid, Serializer.LONG_SERIALIZER);
        Utils.unlock(this.nodeLocks, current);
        Utils.assertNoLocks(this.nodeLocks);
        this.notify(v, null, value2);
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.remove2(key, null);
    }

    private V remove2(Object key, Object value) {
        long rootRecid;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, key);
            A = this.engine.get(current, this.nodeSerializer);
        }
        block1: while (true) {
            Utils.lock(this.nodeLocks, current);
            A = this.engine.get(current, this.nodeSerializer);
            int pos = this.findChildren(key, A.keys());
            if (pos < A.keys().length && key != null && A.keys()[pos] != null && 0 == this.comparator.compare(key, A.keys()[pos])) {
                String oldVal = this.hasValues ? A.vals()[pos] : "";
                oldVal = this.valExpand(oldVal);
                if (value != null && !value.equals(oldVal)) {
                    Utils.unlock(this.nodeLocks, current);
                    return null;
                }
                if (pos == A.keys().length - 1 && value == null) {
                    Utils.unlock(this.nodeLocks, current);
                    return null;
                }
                Object[] keys2 = new Object[A.keys().length - 1];
                System.arraycopy(A.keys(), 0, keys2, 0, pos);
                System.arraycopy(A.keys(), pos + 1, keys2, pos, keys2.length - pos);
                Object[] vals2 = null;
                if (this.hasValues) {
                    vals2 = new Object[A.vals().length - 1];
                    System.arraycopy(A.vals(), 0, vals2, 0, pos);
                    System.arraycopy(A.vals(), pos + 1, vals2, pos, vals2.length - pos);
                }
                A = new LeafNode(keys2, vals2, ((LeafNode)A).next);
                this.engine.update(current, A, this.nodeSerializer);
                Utils.unlock(this.nodeLocks, current);
                this.notify(key, oldVal, null);
                return (V)oldVal;
            }
            Utils.unlock(this.nodeLocks, current);
            if (A.highKey() == null || this.comparator.compare(key, A.highKey()) <= 0) break;
            int pos2 = this.findChildren(key, A.keys());
            while (true) {
                if (pos2 != A.keys().length) continue block1;
                current = ((LeafNode)A).next;
                A = this.engine.get(current, this.nodeSerializer);
            }
            break;
        }
        return null;
    }

    @Override
    public void clear() {
        Iterator<K> iter = this.keyIterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    protected Map.Entry<K, V> makeEntry(Object key, Object value) {
        if (value instanceof ValRef) {
            throw new InternalError();
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
    }

    @Override
    public boolean isEmpty() {
        return !this.keyIterator().hasNext();
    }

    @Override
    public int size() {
        if (this.counter != null) {
            return (int)this.counter.get();
        }
        long size = 0L;
        BTreeIterator iter = new BTreeIterator();
        while (iter.hasNext()) {
            iter.moveToNext();
            ++size;
        }
        return (int)size;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.remove2(key, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        long rootRecid;
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
        BNode node = this.engine.get(current, this.nodeSerializer);
        while (!node.isLeaf()) {
            current = this.nextDir((DirNode)node, key);
            node = this.engine.get(current, this.nodeSerializer);
        }
        Utils.lock(this.nodeLocks, current);
        LeafNode leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
        int pos = this.findChildren(key, node.keys());
        while (pos == leaf.keys.length) {
            Utils.lock(this.nodeLocks, leaf.next);
            Utils.unlock(this.nodeLocks, current);
            current = leaf.next;
            leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
            pos = this.findChildren(key, node.keys());
        }
        boolean ret = false;
        if (key != null && leaf.keys()[pos] != null && 0 == this.comparator.compare(key, leaf.keys[pos])) {
            Object val = leaf.vals[pos];
            if (oldValue.equals(val = this.valExpand(val))) {
                Object[] vals = Arrays.copyOf(leaf.vals, leaf.vals.length);
                this.notify(key, oldValue, newValue);
                if (this.valsOutsideNodes) {
                    long recid = this.engine.put(newValue, this.valueSerializer);
                    newValue = new ValRef(recid);
                }
                vals[pos] = newValue;
                leaf = new LeafNode(Arrays.copyOf(leaf.keys, leaf.keys.length), vals, leaf.next);
                this.engine.update(current, leaf, this.nodeSerializer);
                ret = true;
            }
        }
        Utils.unlock(this.nodeLocks, current);
        return ret;
    }

    @Override
    public V replace(K key, V value) {
        long rootRecid;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
        BNode node = this.engine.get(current, this.nodeSerializer);
        while (!node.isLeaf()) {
            current = this.nextDir((DirNode)node, key);
            node = this.engine.get(current, this.nodeSerializer);
        }
        Utils.lock(this.nodeLocks, current);
        LeafNode leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
        int pos = this.findChildren(key, node.keys());
        while (pos == leaf.keys.length) {
            Utils.lock(this.nodeLocks, leaf.next);
            Utils.unlock(this.nodeLocks, current);
            current = leaf.next;
            leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
            pos = this.findChildren(key, node.keys());
        }
        V ret = null;
        if (key != null && leaf.keys()[pos] != null && 0 == this.comparator.compare(key, leaf.keys[pos])) {
            Object[] vals = Arrays.copyOf(leaf.vals, leaf.vals.length);
            Object oldVal = vals[pos];
            ret = this.valExpand(oldVal);
            this.notify(key, ret, value);
            if (this.valsOutsideNodes && value != null) {
                long recid = this.engine.put(value, this.valueSerializer);
                value = new ValRef(recid);
            }
            vals[pos] = value;
            leaf = new LeafNode(Arrays.copyOf(leaf.keys, leaf.keys.length), vals, leaf.next);
            this.engine.update(current, leaf, this.nodeSerializer);
        }
        Utils.unlock(this.nodeLocks, current);
        return ret;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        while (!n.isLeaf()) {
            n = this.engine.get(n.child()[0], this.nodeSerializer);
        }
        LeafNode l = (LeafNode)n;
        while (l.keys.length == 2) {
            if (l.next == 0L) {
                return null;
            }
            l = (LeafNode)this.engine.get(l.next, this.nodeSerializer);
        }
        return this.makeEntry(l.keys[1], this.hasValues ? this.valExpand(l.vals[1]) : "");
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> e;
        while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> e;
        while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    protected Map.Entry<K, V> findSmaller(K key, boolean inclusive) {
        if (key == null) {
            throw new NullPointerException();
        }
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> k = this.findSmallerRecur(n, key, inclusive);
        if (k == null || k.getValue() == null) {
            return null;
        }
        return k;
    }

    private Map.Entry<K, V> findSmallerRecur(BNode n, K key, boolean inclusive) {
        boolean leaf = n.isLeaf();
        int start = leaf ? n.keys().length - 2 : n.keys().length - 1;
        int end = leaf ? 1 : 0;
        int res = inclusive ? 1 : 0;
        for (int i = start; i >= end; --i) {
            BNode n2;
            Map.Entry<K, V> ret;
            int comp;
            Object key2 = n.keys()[i];
            int n3 = comp = key2 == null ? -1 : this.comparator.compare(key2, key);
            if (comp >= res) continue;
            if (leaf) {
                return key2 == null ? null : this.makeEntry(key2, this.hasValues ? this.valExpand(n.vals()[i]) : "");
            }
            long recid = n.child()[i];
            if (recid == 0L || (ret = this.findSmallerRecur(n2 = this.engine.get(recid, this.nodeSerializer), key, inclusive)) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> e = this.lastEntryRecur(n);
        if (e != null && e.getValue() == null) {
            return null;
        }
        return e;
    }

    private Map.Entry<K, V> lastEntryRecur(BNode n) {
        if (n.isLeaf()) {
            if (n.next() != 0L) {
                BNode n2 = this.engine.get(n.next(), this.nodeSerializer);
                return this.lastEntryRecur(n2);
            }
            for (int i = n.keys().length - 1; i >= 0; --i) {
                Object k = n.keys()[i];
                if (k == null) continue;
                return this.makeEntry(k, this.hasValues ? this.valExpand(n.vals()[i]) : "");
            }
        } else {
            for (int i = n.child().length - 1; i >= 0; --i) {
                BNode n2;
                Map.Entry<K, V> ret;
                long childRecid = n.child()[i];
                if (childRecid == 0L || (ret = this.lastEntryRecur(n2 = this.engine.get(childRecid, this.nodeSerializer))) == null) continue;
                return ret;
            }
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, false);
    }

    @Override
    public K lowerKey(K key) {
        Map.Entry<K, V> n = this.lowerEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, true);
    }

    @Override
    public K floorKey(K key) {
        Map.Entry<K, V> n = this.floorEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, true);
    }

    protected Map.Entry<K, V> findLarger(K key, boolean inclusive) {
        long rootRecid;
        if (key == null) {
            return null;
        }
        K v = key;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int comp = inclusive ? 1 : 0;
        while (true) {
            for (int i = 1; i < leaf.keys.length - 1; ++i) {
                if (leaf.keys[i] == null || this.comparator.compare(key, leaf.keys[i]) >= comp) continue;
                return this.makeEntry(leaf.keys[i], this.hasValues ? this.valExpand(leaf.vals[i]) : "");
            }
            if (leaf.next == 0L) {
                return null;
            }
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
        }
    }

    @Override
    public K ceilingKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.ceilingEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, false);
    }

    @Override
    public K higherKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.higherEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Iterator<V> valueIter = this.valueIterator();
        while (valueIter.hasNext()) {
            if (!value.equals(valueIter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public K firstKey() {
        Map.Entry<K, V> e = this.firstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> e = this.lastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    Iterator<K> keyIterator() {
        return new BTreeKeyIterator();
    }

    Iterator<V> valueIterator() {
        return new BTreeValueIterator();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new BTreeEntryIterator();
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        throw new UnsupportedOperationException("descending not supported");
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        throw new UnsupportedOperationException("descending not supported");
    }

    static final <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    public NavigableMap<K, V> snapshot() {
        Engine snapshot = SnapshotEngine.createSnapshotFor(this.engine);
        return new BTreeMap<K, V>(snapshot, this.treeRecid, this.defaultSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modListeners.length; ++i) {
                if (this.modListeners[i] != listener) continue;
                this.modListeners[i] = null;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        if (oldValue instanceof ValRef) {
            throw new InternalError();
        }
        if (newValue instanceof ValRef) {
            throw new InternalError();
        }
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    public void close() {
        this.engine.close();
    }

    public void printTreeStructure() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG_SERIALIZER);
        BTreeMap.printRecur(this, rootRecid, "");
    }

    private static void printRecur(BTreeMap m, long recid, String s) {
        BNode n = m.engine.get(recid, m.nodeSerializer);
        System.out.println(s + recid + "-" + n);
        if (!n.isLeaf()) {
            for (int i = 0; i < n.child().length - 1; ++i) {
                long recid2 = n.child()[i];
                if (recid2 == 0L) continue;
                BTreeMap.printRecur(m, recid2, s + "  ");
            }
        }
    }

    protected static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        protected final BTreeMap<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public SubMap(BTreeMap<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.comparator.compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            Iterator<K> i = this.keyIterator();
            int counter = 0;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return counter;
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!value.equals(i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> ret = this.m.floorEntry(key);
            if (ret != null && this.tooLow(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> ret = this.m.ceilingEntry(key);
            if (ret != null && this.tooHigh(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Map.Entry<K, V> r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> k = this.lo == null ? this.m.firstEntry() : this.m.findLarger(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> k = this.hi == null ? this.m.lastEntry() : this.m.findSmaller(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.comparator.compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.comparator.compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            throw new UnsupportedOperationException("Descending not supported");
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.hasValues);
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.comparator.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.comparator.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.hasValues);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            throw new UnsupportedOperationException("Descending not supported");
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this);
        }

        Iterator<K> keyIterator() {
            return new Iter<K>(){

                @Override
                public K next() {
                    this.advance();
                    return this.last.getKey();
                }
            };
        }

        Iterator<V> valueIterator() {
            return new Iter<V>(){

                @Override
                public V next() {
                    this.advance();
                    return this.last.getValue();
                }
            };
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new Iter<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    this.advance();
                    return this.last;
                }
            };
        }

        abstract class Iter<E>
        implements Iterator<E> {
            Map.Entry<K, V> current;
            Map.Entry<K, V> last;

            Iter() {
                this.current = SubMap.this.firstEntry();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            public void advance() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = SubMap.this.higherEntry(this.current.getKey());
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.remove(this.last.getKey());
                this.last = null;
            }
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> map) {
            this.m = map;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.m.get(key);
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            return this.m.remove(key, e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    static final class Values<E>
    extends AbstractCollection<E> {
        private final ConcurrentNavigableMap<Object, E> m;

        Values(ConcurrentNavigableMap<Object, E> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        protected final ConcurrentNavigableMap<E, Object> m;
        private final boolean hasValues;

        KeySet(ConcurrentNavigableMap<E, Object> map, boolean hasValues) {
            this.m = map;
            this.hasValues = hasValues;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap((Object)toElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap((Object)fromElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap(), this.hasValues);
        }

        @Override
        public boolean add(E k) {
            if (this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return this.m.put(k, "") == null;
        }
    }

    class BTreeEntryIterator
    extends BTreeIterator
    implements Iterator<Map.Entry<K, V>> {
        BTreeEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.keys[this.currentPos];
            Object val = this.currentLeaf.vals[this.currentPos];
            this.moveToNext();
            return BTreeMap.this.makeEntry(ret, BTreeMap.this.valExpand(val));
        }
    }

    class BTreeValueIterator
    extends BTreeIterator
    implements Iterator<V> {
        BTreeValueIterator() {
        }

        @Override
        public V next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.vals[this.currentPos];
            this.moveToNext();
            return BTreeMap.this.valExpand(ret);
        }
    }

    class BTreeKeyIterator
    extends BTreeIterator
    implements Iterator<K> {
        BTreeKeyIterator() {
        }

        @Override
        public K next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.keys[this.currentPos];
            this.moveToNext();
            return ret;
        }
    }

    class BTreeIterator {
        LeafNode currentLeaf;
        K lastReturnedKey;
        int currentPos;

        BTreeIterator() {
            long rootRecid = BTreeMap.this.engine.get(BTreeMap.this.rootRecidRef, Serializer.LONG_SERIALIZER);
            BNode node = BTreeMap.this.engine.get(rootRecid, BTreeMap.this.nodeSerializer);
            while (!node.isLeaf()) {
                node = BTreeMap.this.engine.get(node.child()[0], BTreeMap.this.nodeSerializer);
            }
            this.currentLeaf = (LeafNode)node;
            this.currentPos = 1;
            while (this.currentLeaf.keys.length == 2) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    return;
                }
                this.currentLeaf = (LeafNode)BTreeMap.this.engine.get(this.currentLeaf.next, BTreeMap.this.nodeSerializer);
            }
        }

        public boolean hasNext() {
            return this.currentLeaf != null;
        }

        public void remove() {
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            BTreeMap.this.remove(this.lastReturnedKey);
            this.lastReturnedKey = null;
        }

        protected void moveToNext() {
            if (this.currentLeaf == null) {
                return;
            }
            this.lastReturnedKey = this.currentLeaf.keys[this.currentPos];
            ++this.currentPos;
            if (this.currentPos == this.currentLeaf.keys.length - 1) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    this.currentPos = -1;
                    return;
                }
                this.currentPos = 1;
                this.currentLeaf = (LeafNode)BTreeMap.this.engine.get(this.currentLeaf.next, BTreeMap.this.nodeSerializer);
                while (this.currentLeaf.keys.length == 2) {
                    if (this.currentLeaf.next == 0L) {
                        this.currentLeaf = null;
                        this.currentPos = -1;
                        return;
                    }
                    this.currentLeaf = (LeafNode)BTreeMap.this.engine.get(this.currentLeaf.next, BTreeMap.this.nodeSerializer);
                }
            }
        }
    }

    protected static final class LeafNode
    implements BNode {
        final Object[] keys;
        final Object[] vals;
        final long next;

        LeafNode(Object[] keys, Object[] vals, long next) {
            this.keys = keys;
            this.vals = vals;
            this.next = next;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Object[] keys() {
            return this.keys;
        }

        @Override
        public Object[] vals() {
            return this.vals;
        }

        @Override
        public Object highKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public long[] child() {
            return null;
        }

        @Override
        public long next() {
            return this.next;
        }

        public String toString() {
            return "Leaf(K" + Arrays.toString(this.keys) + ", V" + Arrays.toString(this.vals) + ", L=" + this.next + ")";
        }
    }

    protected static final class DirNode
    implements BNode {
        final Object[] keys;
        final long[] child;

        DirNode(Object[] keys, long[] child) {
            this.keys = keys;
            this.child = child;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Object[] keys() {
            return this.keys;
        }

        @Override
        public Object[] vals() {
            return null;
        }

        @Override
        public Object highKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public long[] child() {
            return this.child;
        }

        @Override
        public long next() {
            return this.child[this.child.length - 1];
        }

        public String toString() {
            return "Dir(K" + Arrays.toString(this.keys) + ", C" + Arrays.toString(this.child) + ")";
        }
    }

    protected static interface BNode {
        public boolean isLeaf();

        public Object[] keys();

        public Object[] vals();

        public Object highKey();

        public long[] child();

        public long next();
    }

    protected static final class ValRef {
        final long recid;

        public ValRef(long recid) {
            this.recid = recid;
        }

        public boolean equals(Object obj) {
            throw new InternalError();
        }

        public int hashCode() {
            throw new InternalError();
        }
    }

    static final class BTreeRoot {
        long rootRecidRef;
        boolean hasValues;
        boolean valsOutsideNodes;
        int maxNodeSize;
        long counterRecid;
        BTreeKeySerializer keySerializer;
        Serializer valueSerializer;
        Comparator comparator;

        BTreeRoot() {
        }
    }

    static class BTreeRootSerializer
    implements Serializer<BTreeRoot> {
        protected final Serializer defaultSerializer;

        BTreeRootSerializer(Serializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        @Override
        public void serialize(DataOutput out, BTreeRoot value) throws IOException {
            out.writeByte(137);
            out.writeLong(value.rootRecidRef);
            out.writeBoolean(value.hasValues);
            out.writeBoolean(value.valsOutsideNodes);
            out.writeInt(value.maxNodeSize);
            out.writeLong(value.counterRecid);
            this.defaultSerializer.serialize(out, value.keySerializer);
            this.defaultSerializer.serialize(out, value.valueSerializer);
            this.defaultSerializer.serialize(out, value.comparator);
        }

        @Override
        public BTreeRoot deserialize(DataInput in, int available) throws IOException {
            BTreeRoot ret = new BTreeRoot();
            if (in.readUnsignedByte() != 137) {
                throw new InternalError();
            }
            ret.rootRecidRef = in.readLong();
            ret.hasValues = in.readBoolean();
            ret.valsOutsideNodes = in.readBoolean();
            ret.maxNodeSize = in.readInt();
            ret.counterRecid = in.readLong();
            ret.keySerializer = (BTreeKeySerializer)this.defaultSerializer.deserialize(in, -1);
            ret.valueSerializer = (Serializer)this.defaultSerializer.deserialize(in, -1);
            ret.comparator = (Comparator)this.defaultSerializer.deserialize(in, -1);
            return ret;
        }
    }
}

