/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public abstract class BTreeKeySerializer<K> {
    public static final BTreeKeySerializer<Long> ZERO_OR_POSITIVE_LONG = new BTreeKeySerializer<Long>(){

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            if (start >= end) {
                return;
            }
            long prev = (Long)keys[start];
            Utils.packLong(out, prev);
            for (int i = start + 1; i < end; ++i) {
                long curr = (Long)keys[i];
                Utils.packLong(out, curr - prev);
                prev = curr;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Long[size];
            long prev = 0L;
            for (int i = start; i < end; ++i) {
                ret[i] = prev += Utils.unpackLong(in);
            }
            return ret;
        }
    };
    public static final BTreeKeySerializer<Integer> ZERO_OR_POSITIVE_INT = new BTreeKeySerializer<Integer>(){

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            if (start >= end) {
                return;
            }
            int prev = (Integer)keys[start];
            Utils.packLong(out, prev);
            for (int i = start + 1; i < end; ++i) {
                int curr = (Integer)keys[i];
                Utils.packInt(out, curr - prev);
                prev = curr;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Integer[size];
            int prev = 0;
            for (int i = start; i < end; ++i) {
                ret[i] = prev += Utils.unpackInt(in);
            }
            return ret;
        }
    };
    public static final BTreeKeySerializer<String> STRING = new BTreeKeySerializer<String>(){

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = ((String)keys[i]).getBytes("UTF8");
                3.leadingValuePackWrite(out, b, previous, 0);
                previous = b;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = 3.leadingValuePackRead(in, previous, 0);
                if (b == null) continue;
                ret[i] = new String(b, "UTF8");
                previous = b;
            }
            return ret;
        }
    };

    public abstract void serialize(DataOutput var1, int var2, int var3, Object[] var4) throws IOException;

    public abstract Object[] deserialize(DataInput var1, int var2, int var3, int var4) throws IOException;

    public static byte[] leadingValuePackRead(DataInput in, byte[] previous, int ignoreLeadingCount) throws IOException {
        int len = Utils.unpackInt(in) - 1;
        if (len == -1) {
            return null;
        }
        int actualCommon = Utils.unpackInt(in);
        byte[] buf = new byte[len];
        if (previous == null) {
            actualCommon = 0;
        }
        if (actualCommon > 0) {
            in.readFully(buf, 0, ignoreLeadingCount);
            System.arraycopy(previous, ignoreLeadingCount, buf, ignoreLeadingCount, actualCommon - ignoreLeadingCount);
        }
        in.readFully(buf, actualCommon, len - actualCommon);
        return buf;
    }

    public static void leadingValuePackWrite(DataOutput out, byte[] buf, byte[] previous, int ignoreLeadingCount) throws IOException {
        if (buf == null) {
            Utils.packInt(out, 0);
            return;
        }
        int actualCommon = ignoreLeadingCount;
        if (previous != null) {
            int maxCommon;
            int n = maxCommon = buf.length > previous.length ? previous.length : buf.length;
            if (maxCommon > Short.MAX_VALUE) {
                maxCommon = Short.MAX_VALUE;
            }
            while (actualCommon < maxCommon && buf[actualCommon] == previous[actualCommon]) {
                ++actualCommon;
            }
        }
        Utils.packInt(out, buf.length + 1);
        Utils.packInt(out, actualCommon);
        out.write(buf, 0, ignoreLeadingCount);
        out.write(buf, actualCommon, buf.length - actualCommon);
    }

    static final class BasicKeySerializer
    extends BTreeKeySerializer<Object> {
        protected final Serializer defaultSerializer;

        BasicKeySerializer(Serializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                this.defaultSerializer.serialize(out, keys[i]);
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                ret[i] = this.defaultSerializer.deserialize(in, -1);
            }
            return ret;
        }
    }
}

