/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.TurnRestrictionBuilder;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorManager;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionSelectionPopupPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CreateOrEditTurnRestrictionAction
extends JosmAction {
    private static CreateOrEditTurnRestrictionAction instance;

    public static CreateOrEditTurnRestrictionAction getInstance() {
        if (instance == null) {
            instance = new CreateOrEditTurnRestrictionAction();
        }
        return instance;
    }

    protected CreateOrEditTurnRestrictionAction() {
        super(I18n.tr((String)"Create/Edit turn restriction...", (Object[])new Object[0]), null, I18n.tr((String)"Create or edit a turn restriction.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:turnrestriction", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Create or edit a turn restriction."}), (int)50, (int)5007), false);
    }

    public void actionPerformed(ActionEvent e) {
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer == null) {
            return;
        }
        Collection<Relation> trs = TurnRestrictionSelectionPopupPanel.getTurnRestrictionsParticipatingIn(layer.data.getSelected());
        if (trs.isEmpty()) {
            Relation tr = new TurnRestrictionBuilder().buildFromSelection(layer);
            TurnRestrictionEditor editor = new TurnRestrictionEditor((Component)Main.map.mapView, layer, tr);
            TurnRestrictionEditorManager.getInstance().positionOnScreen(editor);
            TurnRestrictionEditorManager.getInstance().register(layer, tr, editor);
            editor.setVisible(true);
        } else {
            TurnRestrictionSelectionPopupPanel pnl = new TurnRestrictionSelectionPopupPanel(layer);
            pnl.launch();
        }
    }
}

