/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import relcontext.actions.CreateMultipolygonAction;

public class TheRing {
    private static final String PREF_MULTIPOLY = "reltoolbox.multipolygon.";
    private Way source;
    private List<RingSegment> segments;
    private Relation relation = null;

    public TheRing(Way source) {
        this.source = source;
        this.segments = new ArrayList<RingSegment>(1);
        this.segments.add(new RingSegment(source));
    }

    public static boolean areAllOfThoseRings(Collection<Way> ways) {
        ArrayList<Way> rings = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                rings.add(way);
                continue;
            }
            return false;
        }
        if (rings.isEmpty() || ways.size() == 1) {
            return false;
        }
        int i = 0;
        while (i < rings.size() - 1) {
            int j = i + 1;
            while (j < rings.size()) {
                Geometry.PolygonIntersection intersection = Geometry.polygonIntersection((List)((Way)rings.get(i)).getNodes(), (List)((Way)rings.get(j)).getNodes());
                if (intersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND || intersection == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static List<Relation> makeManySimpleMultipolygons(Collection<Way> selection, List<Command> commands) {
        TheRing.log("---------------------------------------");
        ArrayList<TheRing> rings = new ArrayList<TheRing>(selection.size());
        for (Way w : selection) {
            rings.add(new TheRing(w));
        }
        int i = 0;
        while (i < rings.size() - 1) {
            int j = i + 1;
            while (j < rings.size()) {
                ((TheRing)rings.get(i)).collide((TheRing)rings.get(j));
                ++j;
            }
            ++i;
        }
        TheRing.redistributeSegments(rings);
        ArrayList<Relation> relations = new ArrayList<Relation>();
        HashMap<Relation, Relation> relationCache = new HashMap<Relation, Relation>();
        for (TheRing r : rings) {
            commands.addAll(r.getCommands(relationCache));
            relations.add(r.getRelation());
        }
        TheRing.updateCommandsWithRelations(commands, relationCache);
        return relations;
    }

    public void collide(TheRing other) {
        boolean collideNoted = false;
        int i = 0;
        while (i < this.segments.size()) {
            RingSegment segment1 = this.segments.get(i);
            if (!segment1.isReference()) {
                int j = 0;
                while (j < other.segments.size()) {
                    RingSegment segment2 = other.segments.get(j);
                    if (!segment2.isReference()) {
                        TheRing.log("Comparing " + segment1 + " and " + segment2);
                        Node[] split = TheRing.getSplitNodes(segment1.getNodes(), segment2.getNodes(), segment1.isRing(), segment2.isRing());
                        if (split != null) {
                            RingSegment otherSegment;
                            RingSegment segment;
                            if (!collideNoted) {
                                TheRing.log("Rings for ways " + this.source.getUniqueId() + " and " + other.source.getUniqueId() + " collide.");
                                collideNoted = true;
                            }
                            if (!this.areSegmentsEqual(segment = this.splitRingAt(i, split[0], split[1]), otherSegment = other.splitRingAt(j, split[2], split[3]))) {
                                throw new IllegalArgumentException("Error: algorithm gave incorrect segments: " + segment + " and " + otherSegment);
                            }
                            segment.makeReference(otherSegment);
                        }
                    }
                    if (segment1.isReference()) break;
                    ++j;
                }
            }
            ++i;
        }
    }

    public static Node[] getSplitNodes(List<Node> nodes1, List<Node> nodes2, boolean isRing1, boolean isRing2) {
        boolean collideFound;
        int pos = 0;
        while (pos < nodes1.size() && !nodes2.contains(nodes1.get(pos))) {
            ++pos;
        }
        boolean bl = collideFound = pos == nodes1.size();
        if (pos == 0 && isRing1) {
            pos = nodes1.size() - 1;
            while (pos > 0 && nodes2.contains(nodes1.get(pos))) {
                --pos;
            }
            if (pos == 0 && nodes1.size() == nodes2.size()) {
                JOptionPane.showMessageDialog(Main.parent, "Two rings are equal, and this must not be.", "Multipolygon from rings", 0);
                return null;
            }
            pos = pos == nodes1.size() - 1 ? 0 : pos + 1;
        }
        int firstPos = isRing1 ? pos : nodes1.size();
        while (!collideFound) {
            TheRing.log("pos=" + pos);
            int start1 = pos;
            int start2 = nodes2.indexOf(nodes1.get(start1));
            int last1 = TheRing.incrementBy(start1, 1, nodes1.size(), isRing1);
            int last2 = start2;
            int increment2 = 0;
            if (last1 >= 0) {
                last2 = TheRing.incrementBy(start2, -1, nodes2.size(), isRing2);
                if (last2 >= 0 && nodes1.get(last1).equals((Object)nodes2.get(last2))) {
                    increment2 = -1;
                } else {
                    last2 = TheRing.incrementBy(start2, 1, nodes2.size(), isRing2);
                    if (last2 >= 0 && nodes1.get(last1).equals((Object)nodes2.get(last2))) {
                        increment2 = 1;
                    }
                }
            }
            TheRing.log("last1=" + last1 + " last2=" + last2 + " increment2=" + increment2);
            if (increment2 != 0) {
                boolean reachedEnd = false;
                while (!reachedEnd) {
                    int newLast1 = TheRing.incrementBy(last1, 1, nodes1.size(), isRing1);
                    int newLast2 = TheRing.incrementBy(last2, increment2, nodes2.size(), isRing2);
                    if (newLast1 < 0 || newLast2 < 0 || !nodes1.get(newLast1).equals((Object)nodes2.get(newLast2))) {
                        reachedEnd = true;
                        continue;
                    }
                    last1 = newLast1;
                    last2 = newLast2;
                }
                TheRing.log("last1=" + last1 + " last2=" + last2);
                if (increment2 < 0) {
                    int tmp = start2;
                    start2 = last2;
                    last2 = tmp;
                }
                return new Node[]{nodes1.get(start1), nodes1.get(last1), nodes2.get(start2), nodes2.get(last2)};
            }
            pos = last1;
            while (pos != firstPos && pos >= 0 && !nodes2.contains(nodes1.get(pos))) {
                pos = TheRing.incrementBy(pos, 1, nodes1.size(), isRing1);
            }
            if (pos >= 0 && pos != firstPos && nodes2.contains(nodes1.get(pos))) continue;
            collideFound = true;
        }
        return null;
    }

    private static int incrementBy(int value, int increment, int limit1, boolean isRing) {
        int result = value + increment;
        if (result < 0) {
            return isRing ? result + limit1 : -1;
        }
        if (result >= limit1) {
            return isRing ? result - limit1 : -1;
        }
        return result;
    }

    private boolean areSegmentsEqual(RingSegment seg1, RingSegment seg2) {
        List<Node> nodes1 = seg1.getNodes();
        List<Node> nodes2 = seg2.getNodes();
        int size = nodes1.size();
        if (size != nodes2.size()) {
            return false;
        }
        boolean reverse = size > 1 && !nodes1.get(0).equals((Object)nodes2.get(0));
        int i = 0;
        while (i < size) {
            if (!nodes1.get(i).equals((Object)nodes2.get(reverse ? size - 1 - i : i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RingSegment splitRingAt(int segmentIndex, Node n1, Node n2) {
        RingSegment secondPart;
        boolean reversed;
        if (n1.equals((Object)n2)) {
            throw new IllegalArgumentException("Both nodes are equal, id=" + n1.getUniqueId());
        }
        RingSegment segment = this.segments.get(segmentIndex);
        boolean isRing = segment.isRing();
        TheRing.log("Split segment " + segment + " at nodes " + n1.getUniqueId() + " and " + n2.getUniqueId());
        boolean bl = reversed = segment.getNodes().indexOf(n2) < segment.getNodes().indexOf(n1);
        if (reversed && !isRing) {
            Node tmp = n1;
            n1 = n2;
            n2 = tmp;
        }
        RingSegment ringSegment = secondPart = isRing ? segment.split(n1, n2) : segment.split(n1);
        RingSegment thirdPart = isRing ? null : (secondPart == null ? segment.split(n2) : secondPart.split(n2));
        int pos = segmentIndex + 1;
        if (secondPart != null) {
            this.segments.add(pos++, secondPart);
        }
        if (thirdPart != null) {
            this.segments.add(pos++, thirdPart);
        }
        return isRing || secondPart == null ? segment : secondPart;
    }

    public static void redistributeSegments(List<TheRing> rings) {
        HashMap<RingSegment, TheRing> segmentMap = new HashMap<RingSegment, TheRing>();
        for (TheRing ring : rings) {
            for (RingSegment seg : ring.segments) {
                if (seg.isReference()) continue;
                segmentMap.put(seg, ring);
            }
        }
        int i = 0;
        while (i < rings.size()) {
            TheRing ring = rings.get(i);
            if (ring.countNonReferenceSegments() == 0) {
                for (RingSegment seg : ring.segments) {
                    TheRing otherRing = (TheRing)segmentMap.get(seg.references);
                    if (otherRing.countNonReferenceSegments() <= 1) continue;
                    seg.swapReference();
                }
            }
            ++i;
        }
        for (TheRing ring : rings) {
            ring.putSourceWayFirst();
        }
    }

    private int countNonReferenceSegments() {
        int count = 0;
        for (RingSegment seg : this.segments) {
            if (seg.isReference()) continue;
            ++count;
        }
        return count;
    }

    public void putSourceWayFirst() {
        for (RingSegment seg : this.segments) {
            if (seg.isReference()) continue;
            seg.overrideWay(this.source);
            return;
        }
    }

    public List<Command> getCommands() {
        return this.getCommands(true, null);
    }

    public List<Command> getCommands(Map<Relation, Relation> relationChangeMap) {
        return this.getCommands(true, relationChangeMap);
    }

    public List<Command> getCommands(boolean createMultipolygon, Map<Relation, Relation> relationChangeMap) {
        Way sourceCopy = new Way(this.source);
        if (createMultipolygon) {
            Collection linearTags = Main.pref.getCollection("reltoolbox.multipolygon.lineartags", CreateMultipolygonAction.DEFAULT_LINEAR_TAGS);
            this.relation = new Relation();
            this.relation.put("type", "multipolygon");
            for (String key : sourceCopy.keySet()) {
                if (linearTags.contains(key) || key.equals("natural") && sourceCopy.get("natural").equals("coastline")) continue;
                this.relation.put(key, sourceCopy.get(key));
                sourceCopy.remove(key);
            }
        }
        HashMap<Relation, Integer> referencingRelations = new HashMap<Relation, Integer>();
        ArrayList<ChangeCommand> relationCommands = new ArrayList<ChangeCommand>();
        for (OsmPrimitive p : this.source.getReferrers()) {
            if (!(p instanceof Relation)) continue;
            Relation rel = null;
            if (relationChangeMap != null) {
                if (relationChangeMap.containsKey((Relation)p)) {
                    rel = relationChangeMap.get((Relation)p);
                } else {
                    rel = new Relation((Relation)p);
                    relationChangeMap.put((Relation)p, rel);
                }
            } else {
                rel = new Relation((Relation)p);
                relationCommands.add(new ChangeCommand((OsmPrimitive)((Relation)p), (OsmPrimitive)rel));
            }
            int i = 0;
            while (i < rel.getMembersCount()) {
                if (rel.getMember(i).getMember().equals((Object)this.source)) {
                    referencingRelations.put(rel, i);
                }
                ++i;
            }
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean foundOwnWay = false;
        for (RingSegment seg : this.segments) {
            boolean needAdding = !seg.isWayConstructed();
            Way w = seg.constructWay(seg.isReference() ? null : sourceCopy);
            if (needAdding) {
                commands.add((Command)new AddCommand((OsmPrimitive)w));
            }
            if (w.equals((Object)this.source)) {
                if (createMultipolygon || !seg.getWayNodes().equals(this.source.getNodes())) {
                    sourceCopy.setNodes(seg.getWayNodes());
                    commands.add((Command)new ChangeCommand((OsmPrimitive)this.source, (OsmPrimitive)sourceCopy));
                }
                foundOwnWay = true;
            } else {
                for (Relation rel : referencingRelations.keySet()) {
                    int relIndex = (Integer)referencingRelations.get(rel);
                    rel.addMember(new RelationMember(rel.getMember(relIndex).getRole(), (OsmPrimitive)w));
                }
            }
            if (!createMultipolygon) continue;
            this.relation.addMember(new RelationMember("outer", (OsmPrimitive)w));
        }
        if (!foundOwnWay) {
            commands.add((Command)new DeleteCommand((OsmPrimitive)this.source));
        }
        commands.addAll(relationCommands);
        if (createMultipolygon) {
            commands.add((Command)new AddCommand((OsmPrimitive)this.relation));
        }
        return commands;
    }

    public static void updateCommandsWithRelations(List<Command> commands, Map<Relation, Relation> relationCache) {
        for (Relation src : relationCache.keySet()) {
            commands.add((Command)new ChangeCommand((OsmPrimitive)src, (OsmPrimitive)relationCache.get(src)));
        }
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TheRing@");
        sb.append(this.hashCode()).append('[').append("wayId: ").append(this.source == null ? "null" : Long.valueOf(this.source.getUniqueId())).append("; segments: ");
        if (this.segments.isEmpty()) {
            sb.append("empty");
        } else {
            sb.append(this.segments.get(0));
            int i = 1;
            while (i < this.segments.size()) {
                sb.append(", ").append(this.segments.get(i));
                ++i;
            }
        }
        return sb.append(']').toString();
    }

    private static void log(String s) {
    }

    private static class RingSegment {
        private List<Node> nodes;
        private RingSegment references;
        private Way resultingWay = null;
        private boolean wasTemplateApplied = false;
        private boolean isRing;

        public RingSegment(Way w) {
            this(w.getNodes());
        }

        public RingSegment(List<Node> nodes) {
            this.nodes = nodes;
            boolean bl = this.isRing = nodes.size() > 1 && nodes.get(0).equals((Object)nodes.get(nodes.size() - 1));
            if (this.isRing) {
                nodes.remove(nodes.size() - 1);
            }
            this.references = null;
        }

        public RingSegment split(Node n) {
            if (this.nodes == null) {
                throw new IllegalArgumentException("Cannot split segment: it is a reference");
            }
            int pos = this.nodes.indexOf(n);
            if (pos <= 0 || pos >= this.nodes.size() - 1) {
                return null;
            }
            ArrayList<Node> newNodes = new ArrayList<Node>(this.nodes.subList(pos, this.nodes.size()));
            this.nodes.subList(pos + 1, this.nodes.size()).clear();
            return new RingSegment(newNodes);
        }

        public RingSegment split(Node n1, Node n2) {
            int pos2;
            if (this.nodes == null) {
                throw new IllegalArgumentException("Cannot split segment: it is a reference");
            }
            if (!this.isRing) {
                if (n1 == null || this.nodes.get(0).equals((Object)n1) || this.nodes.get(this.nodes.size() - 1).equals((Object)n1)) {
                    return this.split(n2);
                }
                if (n2 == null || this.nodes.get(0).equals((Object)n2) || this.nodes.get(this.nodes.size() - 1).equals((Object)n2)) {
                    return this.split(n1);
                }
                throw new IllegalArgumentException("Split for two nodes is called for not-ring: " + this);
            }
            int pos1 = this.nodes.indexOf(n1);
            if (pos1 == (pos2 = this.nodes.indexOf(n2))) {
                return null;
            }
            ArrayList<Node> newNodes = new ArrayList<Node>();
            if (pos2 > pos1) {
                newNodes.addAll(this.nodes.subList(pos2, this.nodes.size()));
                newNodes.addAll(this.nodes.subList(0, pos1 + 1));
                if (pos2 + 1 < this.nodes.size()) {
                    this.nodes.subList(pos2 + 1, this.nodes.size()).clear();
                }
                if (pos1 > 0) {
                    this.nodes.subList(0, pos1).clear();
                }
            } else {
                newNodes.addAll(this.nodes.subList(pos2, pos1 + 1));
                this.nodes.addAll(new ArrayList<Node>(this.nodes.subList(0, pos2 + 1)));
                this.nodes.subList(0, pos1).clear();
            }
            this.isRing = false;
            return new RingSegment(newNodes);
        }

        public List<Node> getNodes() {
            return this.nodes == null ? this.references.nodes : this.nodes;
        }

        public List<Node> getWayNodes() {
            if (this.nodes == null) {
                throw new IllegalArgumentException("Won't give you wayNodes: it is a reference");
            }
            ArrayList<Node> wayNodes = new ArrayList<Node>(this.nodes);
            if (this.isRing) {
                wayNodes.add((Node)wayNodes.get(0));
            }
            return wayNodes;
        }

        public boolean isReference() {
            return this.nodes == null;
        }

        public boolean isRing() {
            return this.isRing;
        }

        public void makeReference(RingSegment segment) {
            TheRing.log(this + " was made a reference to " + segment);
            this.nodes = null;
            this.references = segment;
        }

        public void swapReference() {
            this.nodes = this.references.nodes;
            this.references.nodes = null;
            this.references.references = this;
            this.references = null;
        }

        public boolean isWayConstructed() {
            return this.isReference() ? this.references.isWayConstructed() : this.resultingWay != null;
        }

        public Way constructWay(Way template) {
            if (this.isReference()) {
                return this.references.constructWay(template);
            }
            if (this.resultingWay == null) {
                this.resultingWay = new Way();
                this.resultingWay.setNodes(this.getWayNodes());
            }
            if (template != null && !this.wasTemplateApplied) {
                this.resultingWay.setKeys(template.getKeys());
                this.wasTemplateApplied = true;
            }
            return this.resultingWay;
        }

        public void overrideWay(Way source) {
            if (this.isReference()) {
                this.references.overrideWay(source);
            } else {
                this.resultingWay = source;
                this.wasTemplateApplied = true;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RingSegment@");
            sb.append(this.hashCode()).append('[');
            if (this.isReference()) {
                sb.append("references ").append(this.references.hashCode());
            } else if (this.nodes.isEmpty()) {
                sb.append("empty");
            } else {
                if (this.isRing) {
                    sb.append("ring:");
                }
                sb.append(this.nodes.get(0).getUniqueId());
                int i = 1;
                while (i < this.nodes.size()) {
                    sb.append(',').append(this.nodes.get(i).getUniqueId());
                    ++i;
                }
            }
            return sb.append(']').toString();
        }
    }
}

