/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class RelationHelpAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public RelationHelpAction(ChosenRelation rel) {
        this.putValue("Name", I18n.tr((String)"Open relation wiki page", (Object[])new Object[0]));
        this.putValue("ShortDescription", I18n.tr((String)"Launch browser with wiki help for selected object", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"search"));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rel.get() == null) {
            return;
        }
        try {
            String base = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
            String lang = LanguageInfo.getWikiLanguagePrefix();
            final ArrayList<URI> uris = new ArrayList<URI>();
            String type = URLEncoder.encode(this.rel.get().get("type"), "UTF-8");
            if (type != null && !type.equals("")) {
                uris.add(new URI(String.format("%s%sRelation:%s", base, lang, type)));
                uris.add(new URI(String.format("%sRelation:%s", base, type)));
            }
            uris.add(new URI(String.format("%s%sRelations", base, lang)));
            uris.add(new URI(String.format("%sRelations", base)));
            Main.worker.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (URI u : uris) {
                            HttpURLConnection conn = (HttpURLConnection)u.toURL().openConnection();
                            conn.setConnectTimeout(5000);
                            if (conn.getResponseCode() != 200) {
                                System.out.println("INFO: " + u + " does not exist");
                                conn.disconnect();
                                continue;
                            }
                            int osize = conn.getContentLength();
                            conn.disconnect();
                            conn = (HttpURLConnection)new URI(u.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL().openConnection();
                            conn.setConnectTimeout(5000);
                            if (Math.abs(conn.getContentLength() - osize) > 200) {
                                System.out.println("INFO: " + u + " is a mediawiki redirect");
                                conn.disconnect();
                                continue;
                            }
                            System.out.println("INFO: browsing to " + u);
                            conn.disconnect();
                            OpenBrowser.displayUrl((String)u.toString());
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

