/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.MultipolygonCreate;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class ReconstructPolygonAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;
    private static final List<String> IRRELEVANT_KEYS = Arrays.asList("source", "created_by", "note");

    public ReconstructPolygonAction(ChosenRelation rel) {
        super(I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"filter"));
        this.putValue("LongDescription", "Reconstruct polygon from multipolygon relation");
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(this.isSuitableRelation(rel.get()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        ArrayList<Way> ways = new ArrayList<Way>();
        boolean wont = false;
        for (RelationMember m : r.getMembers()) {
            if (m.isWay()) {
                ways.add(m.getWay());
                continue;
            }
            wont = true;
        }
        if (wont) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Multipolygon must consist only of ways", (Object[])new Object[0]), I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), 0);
            return;
        }
        MultipolygonCreate mpc = new MultipolygonCreate();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            JOptionPane.showMessageDialog(Main.parent, error);
            return;
        }
        if (!mpc.innerWays.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Reconstruction of polygons can be done only from outer ways", (Object[])new Object[0]), I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), 0);
            return;
        }
        this.rel.clear();
        ArrayList<Way> newSelection = new ArrayList<Way>();
        ArrayList<Object> commands = new ArrayList<Object>();
        Command c = DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), Collections.singleton(r), (boolean)true, (boolean)true);
        if (c == null) {
            return;
        }
        commands.add(c);
        for (MultipolygonCreate.JoinedPolygon p : mpc.outerWays) {
            Map tags = ((Way)p.ways.get(0)).getKeys();
            List relations = ((Way)p.ways.get(0)).getReferrers();
            HashSet<String> noTags = new HashSet<String>(r.keySet());
            int i = 1;
            while (i < p.ways.size()) {
                Way w = (Way)p.ways.get(i);
                for (String key : w.keySet()) {
                    String value = w.get(key);
                    if (noTags.contains(key) || !tags.containsKey(key) || ((String)tags.get(key)).equals(value)) continue;
                    tags.remove(key);
                    noTags.add(key);
                }
                List referrers = w.getReferrers();
                Iterator ref1 = relations.iterator();
                while (ref1.hasNext()) {
                    if (referrers.contains(ref1.next())) continue;
                    ref1.remove();
                }
                ++i;
            }
            tags.putAll(r.getKeys());
            tags.remove("type");
            Way candidateWay = null;
            for (Way w : p.ways) {
                if (!w.getReferrers().equals(relations)) continue;
                HashSet keys = new HashSet(w.keySet());
                keys.removeAll(tags.keySet());
                keys.removeAll(IRRELEVANT_KEYS);
                if (!keys.isEmpty()) continue;
                if (candidateWay == null) {
                    candidateWay = w;
                    continue;
                }
                if (candidateWay.isNew() && !w.isNew()) {
                    Way tmp = w;
                    w = candidateWay;
                    candidateWay = tmp;
                }
                commands.add(new DeleteCommand((OsmPrimitive)w));
            }
            Way result = candidateWay == null ? new Way() : new Way(candidateWay);
            result.setNodes(p.nodes);
            result.addNode(result.firstNode());
            result.setKeys(tags);
            newSelection.add(candidateWay == null ? result : candidateWay);
            commands.add(candidateWay == null ? new AddCommand((OsmPrimitive)result) : new ChangeCommand((OsmPrimitive)candidateWay, (OsmPrimitive)result));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Reconstruct polygons from relation {0}", (Object[])new Object[]{r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        Main.main.getCurrentDataSet().setSelected(newSelection);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(this.isSuitableRelation(newRelation));
    }

    private boolean isSuitableRelation(Relation newRelation) {
        if (newRelation == null || !"multipolygon".equals(newRelation.get("type")) || newRelation.getMembersCount() == 0) {
            return false;
        }
        for (RelationMember m : newRelation.getMembers()) {
            if (!"inner".equals(m.getRole())) continue;
            return false;
        }
        return true;
    }
}

