/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsAcquirer
implements Runnable {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2947;
    private static final String C_HOST = "livegps.gpsd.host";
    private static final String C_PORT = "livegps.gpsd.port";
    private String gpsdHost;
    private int gpsdPort;
    private Socket gpsdSocket;
    private BufferedReader gpsdReader;
    private boolean connected = false;
    private boolean shutdownFlag = false;
    private boolean JSONProtocol = true;
    private final List<PropertyChangeListener> propertyChangeListener = new ArrayList<PropertyChangeListener>();
    private PropertyChangeEvent lastStatusEvent;
    private PropertyChangeEvent lastDataEvent;

    public LiveGpsAcquirer() {
        this.gpsdHost = Main.pref.get(C_HOST, DEFAULT_HOST);
        this.gpsdPort = Main.pref.getInteger(C_PORT, 2947);
        Main.pref.put(C_HOST, this.gpsdHost);
        Main.pref.putInteger(C_PORT, Integer.valueOf(this.gpsdPort));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.remove(listener);
        }
    }

    public void fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus status, String statusMessage) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "gpsstatus", null, new LiveGpsStatus(status, statusMessage));
        if (!event.equals(this.lastStatusEvent)) {
            this.firePropertyChangeEvent(event);
            this.lastStatusEvent = event;
        }
    }

    public void fireGpsDataChangeEvent(LiveGpsData oldData, LiveGpsData newData) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "gpsdata", oldData, newData);
        if (!event.equals(this.lastDataEvent)) {
            this.firePropertyChangeEvent(event);
            this.lastDataEvent = event;
        }
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListener) {
            listener.propertyChange(event);
        }
    }

    @Override
    public void run() {
        LiveGpsData oldGpsData = null;
        LiveGpsData gpsData = null;
        this.shutdownFlag = false;
        while (!this.shutdownFlag) {
            while (!this.connected) {
                try {
                    this.connect();
                }
                catch (IOException iox) {
                    this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"Connection Failed", (Object[])new Object[0]));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            assert (this.connected);
            try {
                String line = this.gpsdReader.readLine();
                if (line == null) {
                    throw new IOException();
                }
                gpsData = this.JSONProtocol ? this.ParseJSON(line) : this.ParseOld(line);
                if (gpsData == null) continue;
                this.fireGpsDataChangeEvent(oldGpsData, gpsData);
                oldGpsData = gpsData;
            }
            catch (IOException iox) {
                System.out.println("LiveGps: lost connection to gpsd");
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"Connection Failed", (Object[])new Object[0]));
                this.disconnect();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        System.out.println("LiveGps: Disconnected from gpsd");
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"Not connected", (Object[])new Object[0]));
        this.disconnect();
    }

    public void shutdown() {
        this.shutdownFlag = true;
    }

    private void connect() throws IOException {
        block12: {
            System.out.println("LiveGps: trying to connect to gpsd at " + this.gpsdHost + ":" + this.gpsdPort);
            this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
            InetAddress[] addrs = InetAddress.getAllByName(this.gpsdHost);
            for (int i = 0; i < addrs.length && this.gpsdSocket == null; ++i) {
                try {
                    this.gpsdSocket = new Socket(addrs[i], this.gpsdPort);
                    break;
                }
                catch (IOException e) {
                    System.out.println("LiveGps: Could not open connection to gpsd: " + e);
                    this.gpsdSocket = null;
                    continue;
                }
            }
            if (this.gpsdSocket == null || !this.gpsdSocket.isConnected()) {
                throw new IOException();
            }
            this.gpsdSocket.getOutputStream().write(new byte[]{119, 13, 10});
            this.gpsdReader = new BufferedReader(new InputStreamReader(this.gpsdSocket.getInputStream()));
            String line = this.gpsdReader.readLine();
            if (line == null) {
                return;
            }
            try {
                JSONObject greeting = new JSONObject(line);
                String type = greeting.getString("class");
                if (type.equals("VERSION")) {
                    String release = greeting.getString("release");
                    System.out.println("LiveGps: Connected to gpsd " + release);
                } else {
                    System.out.println("LiveGps: Unexpected JSON in gpsd greeting: " + line);
                }
            }
            catch (JSONException jex) {
                if (!line.startsWith("GPSD,")) break block12;
                this.connected = true;
                this.JSONProtocol = false;
                System.out.println("LiveGps: Connected to old gpsd protocol version.");
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTED, I18n.tr((String)"Connected", (Object[])new Object[0]));
            }
        }
        if (this.JSONProtocol) {
            JSONObject Watch = new JSONObject();
            try {
                Watch.put("enable", true);
                Watch.put("json", true);
            }
            catch (JSONException je) {
                // empty catch block
            }
            String Request = "?WATCH=" + Watch.toString() + ";\n";
            this.gpsdSocket.getOutputStream().write(Request.getBytes());
            this.connected = true;
            this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTED, I18n.tr((String)"Connected", (Object[])new Object[0]));
        }
    }

    private void disconnect() {
        assert (this.gpsdSocket != null);
        this.connected = false;
        try {
            this.gpsdSocket.close();
            this.gpsdSocket = null;
        }
        catch (Exception e) {
            System.out.println("LiveGps: Unable to close socket; reconnection may not be possible");
        }
    }

    private LiveGpsData ParseJSON(String line) {
        String type;
        JSONObject report;
        double lat = 0.0;
        double lon = 0.0;
        float speed = 0.0f;
        float course = 0.0f;
        float epx = 0.0f;
        float epy = 0.0f;
        try {
            report = new JSONObject(line);
            type = report.getString("class");
        }
        catch (JSONException jex) {
            System.out.println("LiveGps: line read from gpsd is not a JSON object:" + line);
            return null;
        }
        if (!type.equals("TPV")) {
            return null;
        }
        try {
            lat = report.getDouble("lat");
            lon = report.getDouble("lon");
            speed = new Float(report.getDouble("speed")).floatValue();
            course = new Float(report.getDouble("track")).floatValue();
            if (report.has("epx")) {
                epx = new Float(report.getDouble("epx")).floatValue();
            }
            if (report.has("epy")) {
                epy = new Float(report.getDouble("epy")).floatValue();
            }
            return new LiveGpsData(lat, lon, course, speed, epx, epy);
        }
        catch (JSONException je) {
            return null;
        }
    }

    private LiveGpsData ParseOld(String line) {
        double lat = 0.0;
        double lon = 0.0;
        float speed = 0.0f;
        float course = 0.0f;
        String[] words = line.split(",");
        if (words.length == 0 || !words[0].equals("GPSD")) {
            return null;
        }
        block6: for (int i = 1; i < words.length; ++i) {
            if (words[i].length() < 2 || words[i].charAt(1) != '=') continue;
            char what = words[i].charAt(0);
            String value = words[i].substring(2);
            switch (what) {
                case 'O': {
                    String[] status = value.split("\\s+");
                    if (status.length < 5) continue block6;
                    lat = Double.parseDouble(status[3]);
                    lon = Double.parseDouble(status[4]);
                    try {
                        speed = Float.parseFloat(status[9]);
                        course = Float.parseFloat(status[8]);
                    }
                    catch (NumberFormatException nex) {
                        // empty catch block
                    }
                    return new LiveGpsData(lat, lon, course, speed);
                }
                case 'P': {
                    String[] pos = value.split("\\s+");
                    if (pos.length < 2) continue block6;
                    lat = Double.parseDouble(pos[0]);
                    lon = Double.parseDouble(pos[1]);
                    speed = Float.NaN;
                    course = Float.NaN;
                    return new LiveGpsData(lat, lon, course, speed);
                }
            }
        }
        return null;
    }
}

