/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IVertexRenderer;
import org.openstreetmap.josm.plugins.elevation.grid.EleCoordinate;
import org.openstreetmap.josm.plugins.elevation.grid.EleVertex;
import org.openstreetmap.josm.plugins.elevation.gui.Triangle;
import org.openstreetmap.josm.tools.I18n;

public class ElevationGridTile
extends Tile {
    private final BlockingDeque<EleVertex> toDo = new LinkedBlockingDeque<EleVertex>();
    private final BlockingDeque<EleVertex> vertices = new LinkedBlockingDeque<EleVertex>();
    private Bounds box;

    public ElevationGridTile(TileSource source, int xtile, int ytile, int zoom) {
        super(source, xtile, ytile, zoom);
        this.box = this.tile2Bounds(xtile, ytile, zoom);
        this.initQueue();
    }

    public ElevationGridTile(TileSource source, int xtile, int ytile, int zoom, BufferedImage image) {
        super(source, xtile, ytile, zoom, image);
    }

    public void loadPlaceholderFromCache(TileCache cache) {
        super.loadPlaceholderFromCache(cache);
    }

    public String getUrl() throws IOException {
        return super.getUrl();
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        g.drawString(this.getStatus(), x, y);
    }

    public void paintTile(Graphics2D g, MapView mv, IVertexRenderer vertexRenderer) {
        BlockingDeque<EleVertex> list = this.getVertices();
        for (EleVertex eleVertex : list) {
            Point p0 = mv.getPoint((LatLon)eleVertex.get(0));
            Point p1 = mv.getPoint((LatLon)eleVertex.get(1));
            Point p2 = mv.getPoint((LatLon)eleVertex.get(2));
            Triangle shape = new Triangle(p0, p1, p2);
            g.setColor(vertexRenderer.getElevationColor(eleVertex));
            g.fill(shape);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadImage(InputStream input) throws IOException {
        if (!this.isLoaded()) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            vertex = this.toDo.poll();
            if (vertex.isFinished()) {
                this.vertices.add(vertex);
                continue;
            }
            newV = vertex.divide();
            for (EleVertex eleVertex : newV) {
                this.toDo.add(eleVertex);
            }
lbl13:
            // 3 sources

            ** while (this.toDo.size() > 0)
        }
lbl14:
        // 1 sources

        this.setLoaded(true);
    }

    public BlockingDeque<EleVertex> getVertices() {
        return this.vertices;
    }

    private Bounds tile2Bounds(int x, int y, int zoom) {
        Bounds bb = new Bounds(new LatLon(this.source.tileYToLat(y, zoom), this.source.tileXToLon(x, zoom)), new LatLon(this.source.tileYToLat(y + 1, zoom), this.source.tileXToLon(x + 1, zoom)));
        return bb;
    }

    private void initQueue() {
        LatLon min = this.box.getMin();
        LatLon max = this.box.getMax();
        LatLon h1 = new LatLon(min.lat(), max.lon());
        LatLon h2 = new LatLon(max.lat(), min.lon());
        double eleMin = ElevationHelper.getSrtmElevation(min);
        double eleMax = ElevationHelper.getSrtmElevation(max);
        if (!ElevationHelper.isValidElevation(eleMax) || !ElevationHelper.isValidElevation(eleMin)) {
            this.setError(I18n.tr((String)"No SRTM data", (Object[])new Object[0]));
            return;
        }
        EleCoordinate p0 = new EleCoordinate(min, eleMin);
        EleCoordinate p1 = new EleCoordinate(h1, ElevationHelper.getSrtmElevation(h1));
        EleCoordinate p2 = new EleCoordinate(max, eleMax);
        EleCoordinate p3 = new EleCoordinate(h2, ElevationHelper.getSrtmElevation(h2));
        EleVertex v1 = new EleVertex(p0, p1, p2);
        EleVertex v2 = new EleVertex(p2, p3, p0);
        this.toDo.add(v1);
        this.toDo.add(v2);
    }

    public String toString() {
        return "ElevationGridTile [box=" + this.box + ", xtile=" + this.xtile + ", ytile=" + this.ytile + "]";
    }
}

