/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gpx;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.IElevationModel;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.GpxIterator;
import org.openstreetmap.josm.plugins.elevation.gpx.IGpxVisitor;
import org.openstreetmap.josm.plugins.elevation.gpx.WayPointMap;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ElevationModel
implements IGpxVisitor,
IElevationModel {
    private int trackCounter;
    private GpxData gpxData;
    private String name;
    private WayPointMap profiles = new WayPointMap();
    private List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private List<WayPoint> buffer = new ArrayList<WayPoint>();
    private int currentProfileIndex = 0;
    private ElevationProfile curProfile = null;

    public ElevationModel() {
        this("", null);
    }

    public ElevationModel(String name, GpxData data) {
        this.gpxData = data;
        this.name = name;
        GpxIterator.visit(data, (IGpxVisitor)this);
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    protected WayPointMap getTracks() {
        return this.profiles;
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            if (this.profiles == null || this.profiles.size() <= 0) continue;
            listener.elevationProfileChanged(this.getCurrentProfile());
        }
    }

    @Override
    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public List<IElevationProfile> getProfiles() {
        return this.profiles;
    }

    @Override
    public IElevationProfile getCurrentProfile() {
        if (this.currentProfileIndex < 0 || this.currentProfileIndex >= this.profileCount()) {
            return null;
        }
        return (IElevationProfile)this.profiles.get(this.currentProfileIndex);
    }

    @Override
    public void setCurrentProfile(IElevationProfile newProfile) {
        CheckParameterUtil.ensureParameterNotNull((Object)newProfile);
        if (!this.profiles.contains(newProfile)) {
            this.profiles.add(newProfile);
        }
        this.setCurrentProfile(this.profiles.indexOf(newProfile));
    }

    @Override
    public void setCurrentProfile(int index) {
        if (index < 0 || index >= this.profileCount()) {
            throw new RuntimeException("Invalid arg for setCurrentProfile: " + index + ", value must be 0.." + this.profileCount());
        }
        this.currentProfileIndex = index;
        this.fireModelChanged();
    }

    @Override
    public int profileCount() {
        return this.profiles != null ? this.profiles.size() : 0;
    }

    @Override
    public void beginWayPoints() {
    }

    @Override
    public void endWayPoints() {
    }

    @Override
    public void visitWayPoint(WayPoint wp) {
    }

    @Override
    public void beginTrack(GpxTrack track) {
        this.createProfile((IWithAttributes)track);
    }

    @Override
    public void endTrack(GpxTrack track) {
        if (this.curProfile == null) {
            throw new RuntimeException("Internal error: No elevation profile");
        }
        this.curProfile.setDistance(track.length());
        this.commitProfile();
    }

    @Override
    public void beginTrackSegment(GpxTrack track, GpxTrackSegment segment) {
    }

    @Override
    public void endTrackSegment(GpxTrack track, GpxTrackSegment segment) {
    }

    @Override
    public void visitTrackPoint(WayPoint wp, GpxTrack track, GpxTrackSegment segment) {
        this.processWayPoint(wp);
    }

    @Override
    public void beginRoute(GpxRoute route) {
        this.createProfile((IWithAttributes)route);
    }

    @Override
    public void endRoute(GpxRoute route) {
        if (this.curProfile == null) {
            throw new RuntimeException("Internal error: No elevation profile");
        }
        this.curProfile.setDistance(0.0);
        this.commitProfile();
    }

    @Override
    public void visitRoutePoint(WayPoint wp, GpxRoute route) {
        this.processWayPoint(wp);
    }

    private void createProfile(IWithAttributes trackOrRoute) {
        String trackName = (String)trackOrRoute.get("name");
        if (trackName == null && (trackName = (String)trackOrRoute.get("meta.name")) == null) {
            trackName = String.valueOf(this.name) + "." + this.trackCounter;
        }
        this.curProfile = new ElevationProfile(trackName);
    }

    private void commitProfile() {
        if (this.buffer.size() > 0) {
            this.curProfile.setWayPoints(this.buffer);
            this.profiles.add(this.curProfile);
            this.buffer.clear();
        }
    }

    private void processWayPoint(WayPoint wp) {
        if (wp == null) {
            throw new RuntimeException("WPT must not be null!");
        }
        this.buffer.add(wp);
    }
}

