/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jopendocument.io.SaxContentUnmarshaller;
import org.jopendocument.model.OpenDocument;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OdsDocument
extends OpenDocument
implements OdConstants {
    public OdsDocument(InputStream in) {
        this.loadFrom(in);
    }

    private InputSource getEntryInputSource(ZipInputStream zis) throws IOException {
        int n = -1;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((n = zis.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return new InputSource(new ByteArrayInputStream(baos.toByteArray()));
    }

    public void loadFrom(InputStream in) {
        SaxContentUnmarshaller contentHandler = new SaxContentUnmarshaller();
        try {
            ZipInputStream zis = new ZipInputStream(in);
            XMLReader rdr = XMLReaderFactory.createXMLReader();
            ZipEntry entry = null;
            boolean contentParsed = false;
            while (!contentParsed && (entry = zis.getNextEntry()) != null) {
                if (!entry.getName().equals("content.xml")) continue;
                rdr.setContentHandler(contentHandler);
                System.out.println("Parsing content.xml");
                rdr.parse(this.getEntryInputSource(zis));
                contentParsed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init(contentHandler.getBody());
    }
}

